/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidOpenTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import java.util.Collections;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangOpenNotification
extends ClangFileBasedNotification<OpenData> {
    @Nullable
    public static ClangOpenNotification create(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile) {
        OpenData data = clangFile.withVirtualFile(virtualFile -> ClangOpenNotification.doPrepare(context, virtualFile, clangFile.getVersion()), () -> context.isStopped());
        return data != null ? new ClangOpenNotification(context, clangFile, data) : null;
    }

    private ClangOpenNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, @NotNull OpenData data) {
        super(context, clangFile, false, data);
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Open;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server) {
        if (this.myContext.getFilesRegistry().isClosedRemotely(this.myFile.getUrl())) {
            return ClangOpenNotification.doSend(server, (OpenData)this.myParams);
        }
        return false;
    }

    @Override
    protected void toNextRemoteState(@NotNull OpenData data) {
        ClangRequestsHelper.onContentSaved(data.context, data.url, !data.params.isSaved());
        ClangRequestsHelper.onContentChanged(data.context, data.url, data.params.getTextDocument().getText());
    }

    @Nullable
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull VirtualFile file, int version) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context.getProject().isDisposed()) {
            return null;
        }
        String url = file.getUrl();
        ClangIdeFacade ideFacade = context.getIdeFacade();
        boolean isFileSaved = !ideFacade.isModified(file);
        String fileText = ideFacade.getText(file);
        if (fileText == null) {
            ClangUtils.warnClangd(LOG, "Failed to get text of a file " + url);
            return null;
        }
        return ClangOpenNotification.doPrepare(context, url, version, fileText, isFileSaved);
    }

    @NotNull
    static OpenData doPrepare(@NotNull ClangDaemonContext context, @NotNull String url, int version, @NotNull String content, boolean saved) {
        String uri = context.getUrlConverter().toUri(url);
        ClionCompileCommandParams compileParams = new ClionCompileCommandParams(uri, uri, "/dev/null", Collections.emptyList(), "/dev/null", true);
        TextDocumentItem docItem = new TextDocumentItem(uri, "cpp", version, content);
        ClionDidOpenTextDocumentParams params = new ClionDidOpenTextDocumentParams(docItem, saved, compileParams, null);
        return new OpenData(context, url, params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull OpenData data) {
        server.clionDidOpen(data.params);
        return true;
    }

    public static class OpenData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionDidOpenTextDocumentParams params;

        OpenData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionDidOpenTextDocumentParams params) {
            this.context = context;
            this.url = url;
            this.params = params;
        }
    }
}

