/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangReparseNotification
extends ClangFileBasedNotification<ReparseData> {
    @Nullable
    public static ClangReparseNotification create(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile) {
        ReparseData reparseData = clangFile.withVirtualFile(virtualFile -> {
            boolean cancellable;
            if (context.getProject().isDisposed()) {
                return null;
            }
            Project project2 = context.getProject();
            String url = clangFile.getUrl();
            int version = clangFile.getVersion();
            boolean bl = cancellable = clangFile.getOperation() == ClangFile.Operation.Reparse;
            if (ClangRequestsHelper.acceptVersion(context, url, version)) {
                if (ClangRequestsHelper.isAllowedByGuard(context, url)) {
                    Ref macroDefinitions = Ref.create();
                    Ref clangTidyOptions = Ref.create();
                    ClionCompileCommandParams compileParams = ClangLanguageServiceUtils.createClionCompileCommandParams(context, project2, virtualFile, ClangRequestsHelper.getMacrosFilePath(context, url), (Ref<String>)macroDefinitions, (Ref<ClionClangTidyConfigParams>)clangTidyOptions);
                    if (compileParams == null) {
                        return null;
                    }
                    ClionWantDiagnostics WantDiags = cancellable ? ClionWantDiagnostics.Auto : ClionWantDiagnostics.Yes;
                    VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
                    docId.setUri(context.getUrlConverter().toUri(url));
                    docId.setVersion(version);
                    ClionReparseTextDocumentParams params = new ClionReparseTextDocumentParams(docId, compileParams, (ClionClangTidyConfigParams)clangTidyOptions.get(), WantDiags);
                    return new ReparseData(context, url, params, StringUtil.notNullize((String)((String)macroDefinitions.get())));
                }
                ClangUtils.warnClangd(LOG, "File [" + url + "] was banned!");
            }
            return null;
        }, () -> context.isStopped());
        return reparseData != null ? new ClangReparseNotification(context, clangFile, reparseData) : null;
    }

    private ClangReparseNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, @NotNull ReparseData data) {
        super(context, clangFile, true, data);
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Reparse;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server) {
        if (this.myContext.getFilesRegistry().isOpenedRemotely(this.myFile.getUrl())) {
            ClangUtils.warnClangd(LOG, "Reparsing file " + this.myFile);
            this.myContext.getTelemetry().getGeneralTelemetry().notifyReparseSent(this);
            return ClangReparseNotification.doSend(server, (ReparseData)this.myParams);
        }
        return false;
    }

    @Override
    protected void toNextRemoteState(@NotNull ReparseData data) {
        this.myFile.putUserData(ClangFile.UNSAVED_FILES, this.myContext.getFilesRegistry().getUnsavedFiles());
        ClangRequestsHelper.onCompilationCommandChanged(this.myContext, this.myFile.getUrl(), data.params);
        ClangRequestsHelper.onMacroContentChanged(this.myContext, this.myFile.getUrl(), data.macroDefinitions);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ReparseData data) {
        ClangRequestsHelper.updateMacrosFile(data.context, server, data.url, data.macroDefinitions);
        server.clionReparse(data.params);
        return true;
    }

    static class ReparseData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionReparseTextDocumentParams params;
        @NotNull
        public final String macroDefinitions;

        ReparseData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionReparseTextDocumentParams params, @NotNull String macroDefinitions) {
            this.context = context;
            this.url = url;
            this.params = params;
            this.macroDefinitions = macroDefinitions;
        }
    }
}

