/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangRequest {
    public static final Logger LOG = Logger.getInstance((String)ClangRequest.class.getName());

    @NotNull
    public ClangRequestType getType();

    public void send(@NotNull ClangServer var1);

    @NotNull
    default public String getDescription() {
        return (Object)((Object)this.getType()) + "[" + (this.requiresRecover() ? "recover needed" : "no recover") + "]";
    }

    default public boolean requiresRecover() {
        return false;
    }

    default public void onSkipped() {
    }

    @NotNull
    public static ClangRequest createSimple(@NotNull ClangRequestType requestType, @NotNull Consumer<? super ClangServer> action) {
        return ClangRequest.createSimple(requestType, action, false);
    }

    @NotNull
    public static ClangRequest createSimple(@NotNull ClangRequestType requestType, @NotNull Consumer<? super ClangServer> action, boolean recover) {
        return ClangRequest.newRequest(requestType).action(action).requiresRecover(recover).create();
    }

    @NotNull
    public static Builder newRequest(@NotNull ClangRequestType requestType) {
        return new Builder(requestType);
    }

    public static final class Builder {
        @NotNull
        private final ClangRequestType myRequestType;
        @Nullable
        private Consumer<? super ClangServer> myAction;
        private boolean myRequiresRecover;
        @Nullable
        private Runnable myOnSkipped;

        public Builder(@NotNull ClangRequestType requestType) {
            this.myRequestType = requestType;
        }

        @NotNull
        public Builder action(@NotNull Consumer<? super ClangServer> action) {
            this.myAction = action;
            return this;
        }

        @NotNull
        public Builder requiresRecover() {
            return this.requiresRecover(true);
        }

        @NotNull
        public Builder requiresRecover(boolean requiresRecover) {
            this.myRequiresRecover = requiresRecover;
            return this;
        }

        @NotNull
        public Builder onSkipped(@NotNull Runnable runnable) {
            this.myOnSkipped = runnable;
            return this;
        }

        @NotNull
        public ClangRequest create() {
            return new ClangRequest(){

                @Override
                @NotNull
                public ClangRequestType getType() {
                    return myRequestType;
                }

                @Override
                public void send(@NotNull ClangServer server) {
                    if (myAction != null) {
                        myAction.consume((Object)server);
                    }
                }

                @Override
                public boolean requiresRecover() {
                    return myRequiresRecover;
                }

                @Override
                public void onSkipped() {
                    if (myOnSkipped != null) {
                        myOnSkipped.run();
                    }
                }
            };
        }
    }
}

