/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidDeleteTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangBlackList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileSharedData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangRequestsHelper {
    @NotNull
    private static final String MACRO_PREDEFINES_BASE_PATH = "/clion_clangd_inmemory_directory/macros";

    private ClangRequestsHelper() {
        throw new AssertionError();
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NotNull ClangFile file) {
        return ClangRequestsHelper.isMacroFile(converter, file.getUrl());
    }

    public static boolean isMacroFile(@NotNull ClangDaemonContext context, @NotNull String url) {
        return ClangRequestsHelper.isMacroFile(context.getUrlConverter(), url);
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NotNull String url) {
        return converter.fromUri(url).contains(MACRO_PREDEFINES_BASE_PATH);
    }

    static boolean acceptVersion(@NotNull ClangDaemonContext context, @NotNull String url, int newVersion) {
        return newVersion > (Integer)ClangFileRemoteProperties.REMOTE_VERSION.getValue(context, url, null);
    }

    static boolean isAllowedByGuard(@NotNull ClangDaemonContext context, @NotNull String url) {
        ClangBlackList guard = context.getGuard();
        return guard == null || !guard.isBanned(url);
    }

    static boolean isMacroLSPSymbolKind(@Nullable SymbolKind kind) {
        return kind == SymbolKind.Module;
    }

    static void updateMacrosFile(@NotNull ClangDaemonContext context, @NotNull ClangServer server, @NotNull String url, @NotNull String definitions) {
        ClangFile clangMacrosFile = context.getFilesRegistry().apply(modifier -> {
            String macrosFileUrl = ClangRequestsHelper.getMacrosFileUrl(context, url);
            ClangFile file = context.getFilesRegistry().getFile(macrosFileUrl);
            if (file == null) {
                file = modifier.nextVersion(macrosFileUrl, null, ClangFile.Operation.Change);
                ClangFileSharedData sharedData = modifier.getSharedData(file);
                sharedData.put(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS, definitions);
                return file;
            }
            ClangFileSharedData sharedData = modifier.getSharedData(file);
            String prevDefinitions = sharedData.get(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS);
            if (Objects.equals(prevDefinitions, definitions)) {
                return null;
            }
            sharedData.put(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS, definitions);
            return modifier.nextVersion(macrosFileUrl, null, ClangFile.Operation.Change);
        });
        if (clangMacrosFile != null) {
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(context.getUrlConverter().toUri(clangMacrosFile.getUrl()));
            docId.setVersion(clangMacrosFile.getVersion());
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(definitions);
            ClangChangeNotification.create(context, clangMacrosFile, new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent)), false).send(server);
        }
    }

    static void closeMacrosFile(@NotNull ClangDaemonContext context, @NotNull ClangServer server, @NotNull String url) {
        ClangFilesRegistry filesRegistry = context.getFilesRegistry();
        ClangFile macrosFile = filesRegistry.apply(modifier -> {
            ClangFile clangMacrosFile = filesRegistry.getFile(ClangRequestsHelper.getMacrosFileUrl(context, url));
            if (clangMacrosFile != null) {
                clangMacrosFile = modifier.nextVersion(clangMacrosFile.getUrl(), null, ClangFile.Operation.Delete);
                ClangFileSharedData sharedData = modifier.getSharedData(clangMacrosFile);
                sharedData.put(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS, null);
                return clangMacrosFile;
            }
            return null;
        });
        if (macrosFile != null) {
            ClionDidDeleteTextDocumentParams params = new ClionDidDeleteTextDocumentParams(new TextDocumentIdentifier(context.getUrlConverter().toUri(macrosFile.getUrl())), macrosFile.getVersion());
            server.clionDidDelete(params);
            ClangLanguageServiceUtils.finishOperation(macrosFile, true);
        }
    }

    static String getMacrosFileUrl(@NotNull ClangDaemonContext context, @NotNull String url) {
        return "file://" + ClangRequestsHelper.getMacrosFilePath(context, url);
    }

    @NotNull
    static String getMacrosFilePath(@NotNull ClangDaemonContext context, @NotNull String url) {
        String path = context.getUrlConverter().fromUri(context.getUrlConverter().toUri(url));
        if (SystemInfo.isWindows && path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '/') {
            char driveLetter = path.charAt(0);
            path = path.replaceFirst(":", "");
            path = driveLetter + ":" + MACRO_PREDEFINES_BASE_PATH + (path.startsWith("/") ? path : "/" + path);
            return path;
        }
        return MACRO_PREDEFINES_BASE_PATH + (path.startsWith("/") ? path : "/" + path);
    }

    static void onContentSaved(@NotNull ClangDaemonContext context, @NotNull String url, boolean isModified) {
        ClangFile clangFile = context.getFilesRegistry().getFile(url);
        if (clangFile == null) {
            return;
        }
        context.getFilesRegistry().modify((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> {
            ClangFileSharedData sharedData = modifier.getSharedData(clangFile);
            Set<String> unsavedFiles = modifier.getUnsavedFiles();
            if (isModified) {
                sharedData.put(ClangFileRemoteProperties.REMOTE_IS_SAVED, false);
                unsavedFiles.add(url);
            } else {
                sharedData.put(ClangFileRemoteProperties.REMOTE_IS_SAVED, true);
                unsavedFiles.remove(url);
            }
        }));
    }

    static void onContentChanged(@NotNull ClangDaemonContext context, @NotNull String url, @Nullable String content) {
        ClangRequestsHelper.onPropertyChanged(context, url, ClangFileRemoteProperties.REMOTE_CONTENT, content);
    }

    static void onMacroContentChanged(@NotNull ClangDaemonContext context, @NotNull String url, @Nullable String content) {
        ClangRequestsHelper.onPropertyChanged(context, url, ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS, content);
    }

    static void onCompilationCommandChanged(@NotNull ClangDaemonContext context, @NotNull String url, @Nullable ClionReparseTextDocumentParams params) {
        ClangRequestsHelper.onPropertyChanged(context, url, ClangFileRemoteProperties.REMOTE_COMPILATION_COMMAND, params);
    }

    static <T> void onPropertyChanged(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClangFileSharedData.Key<T> key, @Nullable T value) {
        ClangFile clangFile = context.getFilesRegistry().getFile(url);
        if (clangFile == null) {
            return;
        }
        context.getFilesRegistry().modify((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> modifier.getSharedData(clangFile).put(key, value)));
    }
}

