/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangSaveRequest
implements ClangRequest {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final String myUrl;

    public ClangSaveRequest(@NotNull ClangDaemonContext context, @NotNull String url) {
        this.myContext = context;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Save;
    }

    @Override
    public void send(@NotNull ClangServer server) {
        server.getTextDocumentService().didSave(new DidSaveTextDocumentParams(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(this.myUrl))));
        ClangRequestsHelper.onContentSaved(this.myContext, this.myUrl, true);
    }

    @Override
    public void onSkipped() {
        ClangRequestsHelper.onContentSaved(this.myContext, this.myUrl, true);
    }
}

