/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidChangeTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionModeParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangBlackList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileSharedData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class ClangServerAccessorImpl
implements ClangServerAccessor {
    private static final long CLANGD_STARTUP_TIMEOUT = ApplicationManager.getApplication().isInternal() ? 60000L : 3600000L;
    private static final Logger LOG = Logger.getInstance((String)ClangServerAccessorImpl.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;
    private final boolean myRunSynchronously;
    private final ReentrantLock myRunSynchronouslyLock = new ReentrantLock(true);
    @NotNull
    private final ExecutorService myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"CLang Server Accessor");
    @NotNull
    private final StateHolder myStateHolder = new StateHolder();

    public ClangServerAccessorImpl(@NotNull ClangDaemonContext context, boolean runSynchronously) {
        this.myContext = context;
        this.myRunSynchronously = runSynchronously;
    }

    @Override
    public boolean isRunningSynchronously() {
        return this.myRunSynchronously;
    }

    @Override
    public CompletableFuture<Integer> shutDown() {
        State whenPostedState = this.myStateHolder.get();
        if (whenPostedState.stage == State.Stage.Initializing && this.myStateHolder.next(whenPostedState, new State(State.Stage.None, null))) {
            return CompletableFuture.completedFuture(0);
        }
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        this.post(ClangRequest.newRequest(ClangRequestType.ShutDown).action((Consumer<? super ClangServer>)((Consumer)server -> {
            State whenExecutedState = this.myStateHolder.get();
            if (whenExecutedState.isStopped()) {
                result.complete(0);
                return;
            }
            Session.stopSession(whenExecutedState.session).whenComplete((exitCode, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                } else {
                    result.complete((Integer)exitCode);
                }
            });
        })).onSkipped(() -> result.complete(0)).create());
        return result;
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> stop() {
        State state;
        while (!this.myStateHolder.next(state = this.myStateHolder.get(), new State(State.Stage.Stopped, null))) {
        }
        Session session = state.session;
        this.myExecutorService.shutdown();
        if (session == null) {
            return CompletableFuture.completedFuture(0);
        }
        Supplier<CompletableFuture> waitForTermination = () -> {
            boolean terminated = false;
            try {
                terminated = this.myExecutorService.awaitTermination(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                LOG.error((Throwable)ex);
            }
            if (!terminated) {
                LOG.warn("Failed to wait until all the tasks are terminated");
            }
            return Session.stopSession(session);
        };
        return CompletableFuture.supplyAsync(waitForTermination, PooledThreadExecutor.INSTANCE).thenCompose(result -> result);
    }

    @Override
    @Nullable
    public ServerCapabilities getCapabilities() {
        Session session = ((StateHolder)this.myStateHolder).get().session;
        return session != null ? session.serverCapabilities : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Future<?> post(@NotNull ClangRequest request) {
        if (this.myStateHolder.get().isStopped()) {
            return null;
        }
        ServerTask task = new ServerTask(request);
        if (this.myRunSynchronously) {
            this.myRunSynchronouslyLock.lock();
            try {
                task.run();
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
                return completableFuture;
            }
            finally {
                this.myRunSynchronouslyLock.unlock();
            }
        }
        try {
            return this.myExecutorService.submit(task);
        }
        catch (RejectedExecutionException ex) {
            request.onSkipped();
            return null;
        }
    }

    private static void logServerException(@NotNull Throwable throwable) {
        if (ClangServerAccessorImpl.isCrashedServerException(throwable)) {
            LOG.warn("Looks like server has crashed: " + throwable.getMessage());
        } else {
            LOG.error(throwable);
        }
    }

    private static boolean isCrashedServerException(@NotNull Throwable thr) {
        Throwable cause = thr;
        do {
            if (!(cause instanceof IOException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private static class ConnectionInOutLogger
    implements java.util.function.Consumer<String> {
        @NotNull
        private final Project myProject;
        private final boolean myIncoming;

        ConnectionInOutLogger(@NotNull Project listener, boolean incoming) {
            this.myProject = listener;
            this.myIncoming = incoming;
        }

        @Override
        public void accept(String line) {
            ClangUtils.infoClangd(LOG, (this.myIncoming ? "Incoming: " : "Outgoing: ") + line);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    ((ClangServerListener)this.myProject.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMessage(line, this.myIncoming);
                }
            });
        }
    }

    private static class ConnectionErrorsLogger
    implements java.util.function.Consumer<String> {
        private StringBuilder myStackDumpBuilder = new StringBuilder();
        private boolean myInsideStackDump = false;

        private ConnectionErrorsLogger() {
        }

        @Override
        public void accept(String line) {
            if (StringUtil.isEmpty((String)line)) {
                return;
            }
            if (line.contains("---Stack Dump Begin---")) {
                this.myInsideStackDump = true;
            } else if (line.contains("---Stack Dump End---")) {
                LOG.warn("clangd crash dump:\n" + this.myStackDumpBuilder.toString());
                this.myInsideStackDump = false;
                this.myStackDumpBuilder = new StringBuilder();
            } else if (this.myInsideStackDump) {
                this.myStackDumpBuilder.append(line).append('\n');
            } else {
                ClangUtils.warnClangd(LOG, "clangd: " + line);
            }
        }
    }

    private static class Session {
        @NotNull
        final ServerConnection connection;
        @NotNull
        final ClangClientServerProvider.ClientServerEndpoints endpoints;
        @NotNull
        final ServerCapabilities serverCapabilities;
        @NotNull
        private final AtomicBoolean myIsStopped = new AtomicBoolean(false);
        private boolean myIsShutDown;

        private Session(@NotNull ServerConnection connection, @NotNull ClangClientServerProvider.ClientServerEndpoints endpoints, @NotNull ServerCapabilities capabilities) {
            this.connection = connection;
            this.endpoints = endpoints;
            this.serverCapabilities = capabilities;
        }

        boolean isActive() {
            return this.connection.isActive();
        }

        boolean isShutDown() {
            return this.myIsShutDown;
        }

        @NotNull
        static CompletableFuture<Session> startSession(@NotNull ClangDaemonContext context) {
            ServerConnection connection = context.getConnectionProvider().create();
            if (connection == null) {
                LOG.warn("Failed to connect to the clangd");
                return CompletableFuture.completedFuture(null);
            }
            ClangClientServerProvider.ClientServerEndpoints endpoints = context.getClientServerProvider().bind(context, connection, new ConnectionErrorsLogger(), new ConnectionInOutLogger(context.getProject(), false), new ConnectionInOutLogger(context.getProject(), true));
            if (endpoints == null) {
                connection.stop();
                LOG.warn("Failed to bind client and server to a process");
                return CompletableFuture.completedFuture(null);
            }
            InitializeParams initParams = Session.createInitParams(context);
            if (initParams == null) {
                ClangUtils.warnClangd(LOG, "Project is already disposed or doesn't have base directory.");
                Session.stopSession(new Session(connection, endpoints, new ServerCapabilities()));
                return CompletableFuture.completedFuture(null);
            }
            try {
                return ((CompletableFuture)((CompletableFuture)endpoints.getServer().initialize(initParams).thenCompose(res -> Session.onInitializeResult(context, endpoints, res))).thenApply(res -> {
                    if (res == null) {
                        Session.stopSession(new Session(connection, endpoints, new ServerCapabilities()));
                        return null;
                    }
                    return new Session(connection, endpoints, res.getCapabilities());
                })).exceptionally(thr -> {
                    ClangServerAccessorImpl.logServerException(thr);
                    Session.stopSession(new Session(connection, endpoints, new ServerCapabilities()));
                    return null;
                });
            }
            catch (Throwable throwable) {
                ClangServerAccessorImpl.logServerException(throwable);
                Session.stopSession(new Session(connection, endpoints, new ServerCapabilities()));
                return CompletableFuture.completedFuture(null);
            }
        }

        @NotNull
        static CompletableFuture<Integer> stopSession(@Nullable Session session) {
            if (session == null) {
                return CompletableFuture.completedFuture(0);
            }
            if (!session.myIsStopped.compareAndSet(false, true)) {
                return session.connection.getStopFuture();
            }
            try {
                if (session.connection.isActive()) {
                    session.endpoints.getServer().shutdown();
                    session.endpoints.getServer().exit();
                    session.myIsShutDown = true;
                    Thread.sleep(50L);
                }
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
            Disposer.dispose((Disposable)session.endpoints);
            session.connection.stop();
            return session.connection.getStopFuture();
        }

        @NotNull
        private static CompletableFuture<InitializeResult> onInitializeResult(@NotNull ClangDaemonContext context, @NotNull ClangClientServerProvider.ClientServerEndpoints endpoints, @Nullable InitializeResult res) {
            if (res == null) {
                return CompletableFuture.completedFuture(null);
            }
            Object experimental = res.getCapabilities().getExperimental();
            if (experimental instanceof Map) {
                Object daemonVersion = ((Map)experimental).get("clionDaemon");
                if (daemonVersion instanceof Number) {
                    int daemonVersionValue = ((Number)daemonVersion).intValue();
                    if (daemonVersionValue == 37) {
                        ClionModeParams clionModeParams = new ClionModeParams(true);
                        return endpoints.getServer().clionModeOn(clionModeParams).thenApply(any -> res);
                    }
                    String message = "Version of clion-clangd is " + daemonVersionValue + ", but expected version is " + 37;
                    if (context.isCustomClangdUsed()) {
                        String customClangdMessage = "You are using custom clangd, check option \"CLANGD_PATH\". Did you forget to update it?";
                        message = PluginManagerCore.isRunningFromSources() ? message + "<br><br>DEVELOPER NOTICE:<br>" + customClangdMessage : message + "<br>" + customClangdMessage;
                    } else if (PluginManagerCore.isRunningFromSources()) {
                        message = message + "<br><br>DEVELOPER NOTICE:<br>Probably you need to execute `DownloadCLionDependencies` run configuration.";
                    }
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification(message), (Project)context.getProject());
                    LOG.warn(message);
                } else {
                    LOG.warn("Looks like the version of clion-clangd is too old");
                }
            } else {
                LOG.warn("Looks like this is not a clion-clangd");
            }
            return CompletableFuture.completedFuture(null);
        }

        @Nullable
        private static InitializeParams createInitParams(@NotNull ClangDaemonContext context) {
            String baseDirPath = context.getProject().getBasePath();
            if (baseDirPath == null) {
                return null;
            }
            InitializeParams initParams = new InitializeParams();
            initParams.setProcessId(Integer.valueOf(Integer.parseInt(OSProcessUtil.getApplicationPid())));
            initParams.setRootUri(context.getUrlConverter().toUri(baseDirPath));
            WorkspaceClientCapabilities workspaceClientCapabilities = new WorkspaceClientCapabilities();
            workspaceClientCapabilities.setApplyEdit(Boolean.TRUE);
            workspaceClientCapabilities.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.TRUE));
            workspaceClientCapabilities.setSymbol(new SymbolCapabilities());
            TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
            textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities());
            textDocumentClientCapabilities.setCodeLens(new CodeLensCapabilities());
            textDocumentClientCapabilities.setCompletion(new CompletionCapabilities(new CompletionItemCapabilities(Boolean.FALSE)));
            textDocumentClientCapabilities.setDefinition(new DefinitionCapabilities());
            textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
            textDocumentClientCapabilities.setDocumentLink(new DocumentLinkCapabilities());
            textDocumentClientCapabilities.setDocumentSymbol(new DocumentSymbolCapabilities());
            textDocumentClientCapabilities.setFormatting(new FormattingCapabilities());
            textDocumentClientCapabilities.setHover(new HoverCapabilities());
            textDocumentClientCapabilities.setOnTypeFormatting(null);
            textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
            textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
            textDocumentClientCapabilities.setRename(new RenameCapabilities());
            textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
            textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)));
            initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, null));
            return initParams;
        }
    }

    private static class StateHolder {
        @NotNull
        private State myState = new State(State.Stage.None, null);

        private StateHolder() {
        }

        @NotNull
        private synchronized State get() {
            return this.myState;
        }

        private synchronized boolean next(@NotNull State expected, @NotNull State next) {
            if (expected == this.myState) {
                this.myState = next;
                return true;
            }
            return false;
        }

        private synchronized boolean nextOrDie(@NotNull State expected, @NotNull State next) {
            if (!this.next(expected, next)) {
                Session.stopSession(next.session);
                return false;
            }
            return true;
        }
    }

    private static class State {
        public final Stage stage;
        @Nullable
        public final Session session;

        private State(Stage stage, @Nullable Session session) {
            this.stage = stage;
            this.session = session;
        }

        private boolean isStopped() {
            return this.stage == Stage.Stopped;
        }

        static enum Stage {
            None,
            Initializing,
            Running,
            Stopped;

        }
    }

    private class ServerTask
    implements Runnable {
        @NotNull
        private final ClangRequest myRequest;

        private ServerTask(ClangRequest request) {
            this.myRequest = request;
        }

        @Override
        public void run() {
            try {
                AtomicBoolean wasStopped = new AtomicBoolean();
                Session session = this.getActiveSession(wasStopped);
                if (wasStopped.get()) {
                    assert (session == null) : "Why service was stopped, but there is a session?";
                    ClangUtils.warnClangd(LOG, "Request '" + (Object)((Object)this.myRequest.getType()) + "' was skipped because the server was stopped.");
                    return;
                }
                if (session == null) {
                    this.myRequest.onSkipped();
                    ClangUtils.warnClangd(LOG, "Request '" + (Object)((Object)this.myRequest.getType()) + "' was skipped because the server is down. Recovery for the request is " + (this.myRequest.requiresRecover() ? "required." : "not required."));
                    return;
                }
                this.myRequest.send(session.endpoints.getServer());
            }
            catch (Throwable ex) {
                ClangServerAccessorImpl.logServerException(ex);
            }
        }

        @Nullable
        private Session getActiveSession(AtomicBoolean wasStopped) {
            State state = ClangServerAccessorImpl.this.myStateHolder.get();
            wasStopped.set(false);
            if (state.isStopped()) {
                wasStopped.set(true);
                return null;
            }
            if (state.session != null && state.session.isActive()) {
                return state.session;
            }
            return this.myRequest.requiresRecover() ? this.recover(state) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Session recover(@NotNull State oldState) {
            block16: {
                Session oldSession = oldState.session;
                assert (oldSession == null || !oldSession.isActive());
                if (oldState.stage == State.Stage.Initializing) {
                    return null;
                }
                State initState = new State(State.Stage.Initializing, null);
                if (!ClangServerAccessorImpl.this.myStateHolder.next(oldState, initState)) {
                    return null;
                }
                try {
                    Session.stopSession(oldSession);
                    Session newSession = this.waitForServer(initState, Session.startSession(ClangServerAccessorImpl.this.myContext), CLANGD_STARTUP_TIMEOUT);
                    if (newSession != null) {
                        block15: {
                            this.attachStopHandler(newSession);
                            this.update(newSession);
                            if (!ClangServerAccessorImpl.this.myStateHolder.nextOrDie(initState, new State(State.Stage.Running, newSession))) break block15;
                            Session session = newSession;
                            return session;
                        }
                        try {
                            ClangUtils.warnClangd(LOG, "Failed to swap sessions, most likely service was stopped earlier");
                        }
                        catch (Throwable thr) {
                            Session.stopSession(newSession);
                            LOG.error("Failed to restart server", thr);
                        }
                        break block16;
                    }
                    ClangUtils.warnClangd(LOG, "Failed to restart server");
                }
                catch (TimeoutException ex) {
                    LOG.error("Clangd server restarts too slow", (Throwable)ex);
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.error("Failed to restart server", (Throwable)ex);
                }
                finally {
                    ClangServerAccessorImpl.this.myStateHolder.next(initState, new State(State.Stage.None, null));
                }
            }
            return null;
        }

        @Nullable
        private Session waitForServer(@NotNull State initState, @NotNull CompletableFuture<Session> future, long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
            assert (initState.stage == State.Stage.Initializing);
            long start = System.currentTimeMillis();
            while (!future.isDone()) {
                try {
                    return future.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (ClangServerAccessorImpl.this.myStateHolder.get() != initState) {
                        future.cancel(false);
                        return null;
                    }
                    if (System.currentTimeMillis() - start <= timeoutMs) continue;
                    throw new TimeoutException("Waiting for clangd server to start up takes more than " + timeoutMs + "ms.");
                }
            }
            return future.get();
        }

        private void attachStopHandler(@NotNull Session session) {
            session.connection.getStopFuture().thenAccept(value -> {
                ClangServerAccessorImpl.this.myContext.getFilesRegistry().modify((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> modifier.completePendingAnswers()));
                ClangBlackList guard = ClangServerAccessorImpl.this.myContext.getGuard();
                if (guard != null) {
                    guard.completePendingFutures();
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    Project project2 = ClangServerAccessorImpl.this.myContext.getProject();
                    if (!ClangServerAccessorImpl.this.myContext.isStopped() && !project2.isDisposed()) {
                        if (session.isShutDown()) {
                            ((ClangServerListener)project2.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onServerShutDown();
                        } else {
                            ((ClangServerListener)project2.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onServerFailure();
                        }
                    }
                });
            });
        }

        private void update(@NotNull Session newSession) {
            ClangFilesRegistry filesRegistry = ClangServerAccessorImpl.this.myContext.getFilesRegistry();
            List toProcess = filesRegistry.apply(modifier -> {
                List<ClangFile> clangFiles = filesRegistry.getFiles();
                ArrayList<FileRecoveryData> result = new ArrayList<FileRecoveryData>(clangFiles.size());
                for (ClangFile clangFile : clangFiles) {
                    ClangFileSharedData fileData = modifier.getSharedData(clangFile);
                    int version = fileData.get(ClangFileRemoteProperties.REMOTE_VERSION);
                    boolean isOpened = fileData.get(ClangFileRemoteProperties.REMOTE_IS_OPENED);
                    String fileContent = fileData.get(ClangFileRemoteProperties.REMOTE_CONTENT);
                    String macroDefinitions = fileData.get(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS);
                    ClionReparseTextDocumentParams cc = fileData.get(ClangFileRemoteProperties.REMOTE_COMPILATION_COMMAND);
                    boolean isSaved = fileData.get(ClangFileRemoteProperties.REMOTE_IS_SAVED);
                    result.add(new FileRecoveryData(clangFile.getUrl(), version, isOpened, fileContent, macroDefinitions, cc, isSaved));
                }
                modifier.dropRemoteState();
                return result;
            });
            for (FileRecoveryData data : toProcess) {
                FileRecoveryData recovered = null;
                if (data.isOpened) {
                    boolean needReparse = this.recoveryNeedReparse(data);
                    FileRecoveryData openRecovery = new FileRecoveryData(data.url, needReparse ? data.version - 1 : data.version, data.isOpened, data.fileContent, data.macrosContent, null, data.wasSaved);
                    assert (openRecovery.version > 0) : "Recovery is not reliable";
                    assert (openRecovery.fileContent != null) : "No content in opened file?";
                    ClangOpenNotification.OpenData openRequestData = ClangOpenNotification.doPrepare(ClangServerAccessorImpl.this.myContext, openRecovery.url, openRecovery.version, openRecovery.fileContent, openRecovery.wasSaved);
                    if (ClangOpenNotification.doSend(newSession.endpoints.getServer(), openRequestData)) {
                        recovered = openRecovery;
                    }
                    if (needReparse) {
                        FileRecoveryData reparseRecovery = data;
                        assert (reparseRecovery.cc != null);
                        assert (reparseRecovery.macrosContent != null);
                        ClangReparseNotification.ReparseData reparseData = new ClangReparseNotification.ReparseData(ClangServerAccessorImpl.this.myContext, reparseRecovery.url, reparseRecovery.cc, reparseRecovery.macrosContent);
                        if (ClangReparseNotification.doSend(newSession.endpoints.getServer(), reparseData)) {
                            recovered = reparseRecovery;
                        }
                    }
                } else if (!data.wasSaved) {
                    FileRecoveryData changeRecovery = new FileRecoveryData(data.url, data.version, data.isOpened, data.fileContent, null, null, data.wasSaved);
                    VersionedTextDocumentIdentifier versionedDocId = new VersionedTextDocumentIdentifier();
                    versionedDocId.setUri(ClangServerAccessorImpl.this.myContext.getUrlConverter().toUri(changeRecovery.url));
                    versionedDocId.setVersion(changeRecovery.version);
                    TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
                    changeEvent.setText(changeRecovery.fileContent);
                    boolean success = ClangChangeNotification.doSend(newSession.endpoints.getServer(), new ClionDidChangeTextDocumentParams(versionedDocId, Collections.singletonList(changeEvent), false, changeRecovery.version));
                    if (success) {
                        recovered = changeRecovery;
                    }
                }
                if (recovered == null) continue;
                FileRecoveryData finalRecovered = recovered;
                filesRegistry.modify((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> {
                    ClangFileSharedData shared = modifier.getSharedData(finalRecovered.url);
                    assert (shared != null);
                    shared.put(ClangFileRemoteProperties.REMOTE_VERSION, finalRecovered.version);
                    shared.put(ClangFileRemoteProperties.REMOTE_IS_OPENED, finalRecovered.isOpened);
                    shared.put(ClangFileRemoteProperties.REMOTE_CONTENT, finalRecovered.fileContent);
                    shared.put(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS, finalRecovered.macrosContent);
                    shared.put(ClangFileRemoteProperties.REMOTE_COMPILATION_COMMAND, finalRecovered.cc);
                    shared.put(ClangFileRemoteProperties.REMOTE_IS_SAVED, finalRecovered.wasSaved);
                }));
            }
        }

        private boolean recoveryNeedReparse(@NotNull FileRecoveryData data) {
            if (this.myRequest instanceof ClangASTBasedRequest) {
                ClangFile file = ((ClangASTBasedRequest)this.myRequest).getFile();
                return file.getUrl().equals(data.url) && data.macrosContent != null && data.cc != null;
            }
            return false;
        }

        private class FileRecoveryData {
            @NotNull
            public final String url;
            public final int version;
            public final boolean isOpened;
            @Nullable
            public final String fileContent;
            @Nullable
            public final String macrosContent;
            @Nullable
            public final ClionReparseTextDocumentParams cc;
            public final boolean wasSaved;

            private FileRecoveryData(String url, int version, @Nullable boolean isOpened, @Nullable String fileContent, @Nullable String macrosContent, ClionReparseTextDocumentParams cc, boolean wasSaved) {
                this.url = url;
                this.version = version;
                this.isOpened = isOpened;
                this.fileContent = fileContent;
                this.macrosContent = macrosContent;
                this.cc = cc;
                this.wasSaved = wasSaved;
            }
        }
    }
}

