/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdClientsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangClientsTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangGeneralTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import org.jetbrains.annotations.NotNull;

public final class ClangTelemetry
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangGeneralTelemetry myGeneralTelemetry;
    @NotNull
    private final ClangPreambleTelemetry myPreambleTelemetry;
    @NotNull
    private final ClangClientsTelemetry myClientsTelemetry;

    public ClangTelemetry(@NotNull Project project2, @NotNull ClangUrlConverter converter) {
        this.myProject = project2;
        this.myGeneralTelemetry = new ClangGeneralTelemetry(converter);
        this.myPreambleTelemetry = new ClangPreambleTelemetry();
        this.myClientsTelemetry = new ClangClientsTelemetry();
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ClangdClientsListener.TOPIC, (Object)new ClangdClientsListener(){

            @Override
            public void onResolveViaClangd(@NotNull PsiReference reference) {
                ClangTelemetry.this.myClientsTelemetry.incResolvedViaClangd();
                ClangTelemetry.this.fireClientsEvent();
            }

            @Override
            public void onResolveViaClangdAvoided(@NotNull PsiReference reference) {
                ClangTelemetry.this.myClientsTelemetry.incResolveViaClangdAvoided();
                ClangTelemetry.this.fireClientsEvent();
            }

            @Override
            public void onResolveViaClangdFailed(@NotNull PsiReference reference) {
                ClangTelemetry.this.myClientsTelemetry.incResolveViaClangdFailed();
                ClangTelemetry.this.fireClientsEvent();
            }
        });
    }

    public void onServerTelemetryEvent(Object rawEvent) {
        if (this.myGeneralTelemetry.handle(rawEvent)) {
            this.fireGeneralEvent();
        } else if (this.myPreambleTelemetry.handle(rawEvent)) {
            this.firePreambleEvent();
        }
    }

    @NotNull
    public ClangGeneralTelemetry getGeneralTelemetry() {
        return this.myGeneralTelemetry;
    }

    @NotNull
    public ClangPreambleTelemetry getPreambleTelemetry() {
        return this.myPreambleTelemetry;
    }

    @NotNull
    public ClangClientsTelemetry getClientsTelemetry() {
        return this.myClientsTelemetry;
    }

    public void dispose() {
    }

    private void fireGeneralEvent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                ((ClangTelemetryListener)this.myProject.getMessageBus().syncPublisher(ClangTelemetryListener.TOPIC)).onGeneralTelemetry(this);
            }
        });
    }

    private void firePreambleEvent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                ((ClangTelemetryListener)this.myProject.getMessageBus().syncPublisher(ClangTelemetryListener.TOPIC)).onPreambleTelemetry(this);
            }
        });
    }

    private void fireClientsEvent() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                ((ClangTelemetryListener)this.myProject.getMessageBus().syncPublisher(ClangTelemetryListener.TOPIC)).onClientsTelemetry(this);
            }
        });
    }
}

