/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceNotification;
import org.jetbrains.annotations.NotNull;

public final class TraceChangeNotification
extends TraceNotification {
    @NotNull
    public final String url;
    public final int offset;
    public final int length;
    @NotNull
    public final String replacement;

    public TraceChangeNotification(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        super(TraceNotification.Kind.Change);
        this.url = file.getUrl();
        this.offset = event.getOffset();
        this.length = event.getOldLength();
        this.replacement = event.getNewFragment().toString();
    }

    @Override
    @NotNull
    public String[] getUrls() {
        return new String[]{this.url};
    }

    public String toString() {
        return "Change[" + this.url + ", " + this.offset + ", " + this.length + ", " + this.replacement + "]";
    }
}

