/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceClientServerMessage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceClientServerMessageKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TraceClientServerHistory
implements Consumer<TraceClientServerMessage> {
    @NotNull
    public static final String TITLE = "=== CLIENT-SERVER HISTORY ===";
    @NotNull
    private final List<TraceClientServerMessage> myMessages;

    public TraceClientServerHistory() {
        this.myMessages = Collections.synchronizedList(new ArrayList());
    }

    public TraceClientServerHistory(@NotNull Reader inReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(inReader);){
            TraceClientServerMessage next;
            this.myMessages = new ArrayList<TraceClientServerMessage>();
            while ((next = TraceClientServerMessage.parse(reader)) != null) {
                this.myMessages.add(next);
            }
        }
    }

    @Override
    public void accept(@NotNull TraceClientServerMessage message) {
        this.myMessages.add(message);
    }

    @NotNull
    public List<TraceClientServerMessage> getMessages() {
        return Arrays.asList(this.myMessages.toArray(new TraceClientServerMessage[0]));
    }

    @NotNull
    public List<TraceClientServerMessage> getIncomingMessages() {
        return Arrays.stream(this.myMessages.toArray(new TraceClientServerMessage[0])).filter(message -> message.getKind() == TraceClientServerMessageKind.Response).collect(Collectors.toList());
    }

    @NotNull
    public List<TraceClientServerMessage> getOutgoingMessages() {
        return Arrays.stream(this.myMessages.toArray(new TraceClientServerMessage[0])).filter(message -> message.getKind() == TraceClientServerMessageKind.Request).collect(Collectors.toList());
    }

    public void print(@NotNull PrintWriter writer, int idt) {
        for (TraceClientServerMessage message : this.myMessages) {
            message.print(writer, idt);
        }
    }
}

