/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceClientServerMessageKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceClientServerMessage {
    private static final int INDENT = 2;
    private static final String INCOMING_HEADER = "<----- (incoming)";
    private static final String OUTGOING_HEADER = "-----> (outgoing)";
    @NotNull
    private final TraceClientServerMessageKind myKind;
    @NotNull
    private final String myMessage;

    @NotNull
    public static TraceClientServerMessage request(@NotNull String message) {
        return new TraceClientServerMessage(TraceClientServerMessageKind.Request, message);
    }

    @NotNull
    public static TraceClientServerMessage response(@NotNull String message) {
        return new TraceClientServerMessage(TraceClientServerMessageKind.Response, message);
    }

    private TraceClientServerMessage(@NotNull TraceClientServerMessageKind kind, @NotNull String message) {
        this.myKind = kind;
        this.myMessage = message;
    }

    @NotNull
    public TraceClientServerMessageKind getKind() {
        return this.myKind;
    }

    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    public String toString() {
        return "TraceClientServerMessage{myKind=" + (Object)((Object)this.myKind) + ", myMessage='" + this.myMessage + '\'' + '}';
    }

    public void print(@NotNull PrintWriter writer, int idt) {
        String[] lines = this.myMessage.split("\n");
        switch (this.myKind) {
            case Request: {
                TraceUtils.indent(writer, idt).println("-----> (outgoing) " + lines.length);
                break;
            }
            case Response: {
                TraceUtils.indent(writer, idt).println("<----- (incoming) " + lines.length);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected: " + (Object)((Object)this.myKind)));
            }
        }
        for (String line : lines) {
            TraceUtils.indent(writer, idt + 2).println(line);
        }
    }

    @Nullable
    public static TraceClientServerMessage parse(@NotNull BufferedReader reader) throws IOException {
        TraceClientServerMessageKind kind;
        String line;
        String header;
        while ((header = reader.readLine()) != null && StringUtil.isEmpty((String)header)) {
        }
        if (header == null) {
            return null;
        }
        ArrayList<String> messageLines = new ArrayList<String>();
        while ((line = reader.readLine()) != null && !line.startsWith(OUTGOING_HEADER) && !line.startsWith(INCOMING_HEADER)) {
            messageLines.add(line.substring(2));
            reader.mark(OUTGOING_HEADER.length() + INCOMING_HEADER.length());
        }
        if (line != null) {
            reader.reset();
        }
        if (header.startsWith(OUTGOING_HEADER)) {
            kind = TraceClientServerMessageKind.Request;
        } else if (header.startsWith(INCOMING_HEADER)) {
            kind = TraceClientServerMessageKind.Response;
        } else {
            return null;
        }
        return new TraceClientServerMessage(kind, messageLines.stream().reduce("", (lhs, rhs) -> lhs + rhs));
    }
}

