/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceMoveNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceSaveNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceEnvironmentHistory {
    @NotNull
    public static final String TITLE = "=== ENVIRONMENT HISTORY ===";
    @NotNull
    private final List<TraceNotification> myNotifications = new ArrayList<TraceNotification>();
    @NotNull
    private final List<TraceClangIdeFacadeSnapshot> myFacadeSnapshots = new ArrayList<TraceClangIdeFacadeSnapshot>();

    @NotNull
    public static TraceEnvironmentHistory loadFromFile(@NotNull File file) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(TraceNotification.class, (Object)new TraceNotificationDeserializer()).create();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            TraceEnvironmentHistory traceEnvironmentHistory = (TraceEnvironmentHistory)gson.fromJson((Reader)reader, TraceEnvironmentHistory.class);
            return traceEnvironmentHistory;
        }
    }

    @NotNull
    public static TraceEnvironmentHistory loadFromContent(@NotNull String content) {
        Gson gson = new GsonBuilder().registerTypeAdapter(TraceNotification.class, (Object)new TraceNotificationDeserializer()).create();
        try (StringReader reader = new StringReader(content);){
            TraceEnvironmentHistory traceEnvironmentHistory = (TraceEnvironmentHistory)gson.fromJson((Reader)reader, TraceEnvironmentHistory.class);
            return traceEnvironmentHistory;
        }
    }

    @NotNull
    public List<TraceNotification> getNotifications() {
        return this.myNotifications;
    }

    @NotNull
    public List<? extends ClangIdeFacade> getFacadeSnapshots() {
        return this.myFacadeSnapshots;
    }

    public void onNotification(@NotNull TraceNotification notification, @NotNull ClangIdeFacade facade, @NotNull Project project2, @NotNull List<VirtualFile> interestingFiles) {
        this.myNotifications.add(notification);
        if (this.myFacadeSnapshots.isEmpty()) {
            this.myFacadeSnapshots.add(TraceClangIdeFacadeSnapshot.create(facade, project2, interestingFiles));
        } else {
            TraceClangIdeFacadeSnapshot last = this.myFacadeSnapshots.get(this.myFacadeSnapshots.size() - 1);
            this.myFacadeSnapshots.add(TraceClangIdeFacadeSnapshot.makeNext(facade, project2, interestingFiles, last));
        }
    }

    public void print(@NotNull PrintWriter writer, int idt) {
        TraceUtils.indent(writer, idt).println("ENVIRONMENT HISTORY, tracked " + this.myNotifications.size() + " notifications");
        if (!this.myNotifications.isEmpty()) {
            TraceUtils.indent(writer, idt).println("  NOTIFICATIONS");
            for (int i = 0; i < this.myNotifications.size(); ++i) {
                TraceNotification notification = this.myNotifications.get(i);
                TraceUtils.indent(writer, idt).println("    " + notification);
                TraceClangIdeFacadeSnapshot facadeSnapshot = this.myFacadeSnapshots.get(i);
                facadeSnapshot.print(writer, idt + 6);
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, 0);
        pw.flush();
        return sw.toString();
    }

    private static class TraceNotificationDeserializer
    implements JsonDeserializer<TraceNotification> {
        private TraceNotificationDeserializer() {
        }

        public TraceNotification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            switch (TraceNotification.Kind.valueOf(jObject.get("myKind").getAsString())) {
                case Open: {
                    return (TraceNotification)context.deserialize(json, TraceOpenNotification.class);
                }
                case Close: {
                    return (TraceNotification)context.deserialize(json, TraceCloseNotification.class);
                }
                case Reparse: {
                    return (TraceNotification)context.deserialize(json, TraceReparseNotification.class);
                }
                case CancelParse: {
                    return (TraceNotification)context.deserialize(json, TraceCancelParseNotification.class);
                }
                case Change: {
                    return (TraceNotification)context.deserialize(json, TraceChangeNotification.class);
                }
                case Save: {
                    return (TraceNotification)context.deserialize(json, TraceSaveNotification.class);
                }
                case Delete: {
                    return (TraceNotification)context.deserialize(json, TraceDeleteNotification.class);
                }
                case Move: {
                    return (TraceNotification)context.deserialize(json, TraceMoveNotification.class);
                }
            }
            return null;
        }
    }

    private static class TraceVirtualFileSnapshot {
        @NotNull
        public final String url;
        @NotNull
        public final List<String> openRequests;
        @Nullable
        public final String text;
        public final boolean modified;
        @Nullable
        public final ClangUtils.ClangCompilationCommand compilationCommand;
        @Nullable
        public final String clangTidyChecks;

        @NotNull
        public static TraceVirtualFileSnapshot create(@NotNull ClangIdeFacade facade, @NotNull Project project2, @NotNull String url, @Nullable VirtualFile vf) {
            if (vf != null) {
                List<String> openRequests = facade.getOpenRequests(project2, vf).stream().map(id -> id.getId()).collect(Collectors.toList());
                return new TraceVirtualFileSnapshot(vf.getUrl(), openRequests, facade.getText(vf), facade.isModified(vf), facade.getCompilationCommand(project2, vf), facade.getClangTidyConfig(project2, vf, false));
            }
            return new TraceVirtualFileSnapshot(url, Collections.emptyList(), null, false, null, null);
        }

        private TraceVirtualFileSnapshot(@NotNull String url, @NotNull List<String> openRequests, @Nullable String text, boolean modified, @Nullable ClangUtils.ClangCompilationCommand compilationCommand, @Nullable String clangTidyChecks) {
            this.url = url;
            this.openRequests = openRequests;
            this.text = text;
            this.modified = modified;
            this.compilationCommand = compilationCommand;
            this.clangTidyChecks = clangTidyChecks;
        }

        private TraceVirtualFileSnapshot() {
            this.url = "";
            this.openRequests = Collections.singletonList("");
            this.text = null;
            this.modified = false;
            this.compilationCommand = null;
            this.clangTidyChecks = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceVirtualFileSnapshot snapshot = (TraceVirtualFileSnapshot)o;
            return this.modified == snapshot.modified && Objects.equals(this.url, snapshot.url) && Objects.equals(this.openRequests, snapshot.openRequests) && Objects.equals(this.text, snapshot.text) && Objects.equals(this.compilationCommand, snapshot.compilationCommand) && Objects.equals(this.clangTidyChecks, snapshot.clangTidyChecks);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.openRequests, this.text, this.modified, this.compilationCommand, this.clangTidyChecks);
        }

        public void print(@NotNull PrintWriter writer, int idt) {
            TraceUtils.indent(writer, idt).println("FILE SNAPSHOT (" + this.url + ")");
            TraceUtils.indent(writer, idt += 2).println("Editors = " + this.openRequests);
            TraceUtils.indent(writer, idt).println("Text = " + TraceUtils.escapeLineBreaks(this.text));
            TraceUtils.indent(writer, idt).println("Modified = " + this.modified);
            TraceUtils.indent(writer, idt).println("Compilation command = " + this.compilationCommand);
            TraceUtils.indent(writer, idt).println("Clang tidy checks = " + this.clangTidyChecks);
        }
    }

    private static class TraceClangIdeFacadeSnapshot
    implements ClangIdeFacade {
        @NotNull
        private final SortedMap<String, TraceVirtualFileSnapshot> myFilesMap;

        @NotNull
        public static TraceClangIdeFacadeSnapshot makeNext(@NotNull ClangIdeFacade facade, @NotNull Project project2, @NotNull List<VirtualFile> interestingFiles, @NotNull TraceClangIdeFacadeSnapshot prev) {
            TraceClangIdeFacadeSnapshot next = TraceClangIdeFacadeSnapshot.create(facade, project2, interestingFiles);
            if (prev.equals(next)) {
                return prev;
            }
            return next;
        }

        public static TraceClangIdeFacadeSnapshot create(@NotNull ClangIdeFacade facade, @NotNull Project project2, @NotNull List<VirtualFile> interestingFiles) {
            TreeMap<String, TraceVirtualFileSnapshot> nextFilesMap = new TreeMap<String, TraceVirtualFileSnapshot>();
            for (VirtualFile file : interestingFiles) {
                nextFilesMap.put(file.getUrl(), TraceVirtualFileSnapshot.create(facade, project2, file.getUrl(), file));
            }
            return new TraceClangIdeFacadeSnapshot(nextFilesMap);
        }

        private TraceClangIdeFacadeSnapshot(@NotNull SortedMap<String, TraceVirtualFileSnapshot> filesMap) {
            this.myFilesMap = filesMap;
        }

        private TraceClangIdeFacadeSnapshot() {
            this.myFilesMap = new TreeMap<String, TraceVirtualFileSnapshot>();
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile(@NotNull String url) {
            return null;
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull VirtualFile file) {
            String text = this.getText(file);
            if (text != null) {
                return new DocumentImpl(text);
            }
            return null;
        }

        @Override
        @NotNull
        public List<OpenRequestId> getOpenRequests(@NotNull Project project2, @NotNull VirtualFile file) {
            List<String> requests = ((TraceVirtualFileSnapshot)this.myFilesMap.get((Object)file.getUrl())).openRequests;
            return requests.stream().map(id -> new SimpleOpenRequestId((String)id)).collect(Collectors.toList());
        }

        @Override
        public boolean isModified(@NotNull VirtualFile file) {
            return ((TraceVirtualFileSnapshot)this.myFilesMap.get((Object)file.getUrl())).modified;
        }

        @Override
        @Nullable
        public String getText(@NotNull VirtualFile file) {
            TraceVirtualFileSnapshot fileSnapshot = (TraceVirtualFileSnapshot)this.myFilesMap.get(file.getUrl());
            return fileSnapshot != null ? fileSnapshot.text : null;
        }

        @Override
        @Nullable
        public ClangUtils.ClangCompilationCommand getCompilationCommand(@NotNull Project project2, @NotNull VirtualFile file) {
            return ((TraceVirtualFileSnapshot)this.myFilesMap.get((Object)file.getUrl())).compilationCommand;
        }

        @Override
        @Nullable
        public String getClangTidyConfig(@NotNull Project project2, @NotNull VirtualFile file, boolean takeOurClangTidyConfig) {
            return takeOurClangTidyConfig ? "-*" : ((TraceVirtualFileSnapshot)this.myFilesMap.get((Object)file.getUrl())).clangTidyChecks;
        }

        @Override
        @Nullable
        public Long getPsiModificationCounter(@NotNull Project project2) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraceClangIdeFacadeSnapshot snapshot = (TraceClangIdeFacadeSnapshot)o;
            return Objects.equals(this.myFilesMap, snapshot.myFilesMap);
        }

        public int hashCode() {
            return Objects.hash(this.myFilesMap);
        }

        public void print(@NotNull PrintWriter writer, int idt) {
            TraceUtils.indent(writer, idt).println("FACADE SNAPSHOT, contains " + this.myFilesMap.size() + " file states");
            idt += 2;
            for (Map.Entry<String, TraceVirtualFileSnapshot> entry : this.myFilesMap.entrySet()) {
                TraceVirtualFileSnapshot fileSnapshot = entry.getValue();
                fileSnapshot.print(writer, idt + 2);
            }
        }
    }
}

