/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.memory;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangMemoryUsagePanel
extends JButton
implements CustomStatusBarWidget,
UISettingsListener,
Activatable,
ClangMemoryUsageWatchDogListener {
    public static final String WIDGET_ID = "ClangdMemory";
    private static final Color USED_COLOR = new JBColor((Color)Gray._185, (Color)Gray._110);
    private static final String MSG_PATTERN = "%5d/%dM";
    private static final String TOOLTIP_PATTERN = "Clangd uses %5dM of %5dM";
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySample;
    private volatile long myLastReported = 0L;
    private volatile long myShown = 0L;
    private volatile long myLastLimit = 0L;
    private volatile long myLimitShown = 0L;
    private BufferedImage myBufferedImage;
    private boolean myWasPressed;

    public ClangMemoryUsagePanel(@NotNull Project project2) {
        this.myProject = project2;
        this.mySample = String.format(MSG_PATTERN, 99999, 99999);
        this.setOpaque(false);
        this.setFocusable(false);
        ClangLanguageServiceProvider clangServiceProvider = ClangLanguageServiceProvider.getProvider(this.myProject);
        this.addActionListener(e -> ClangLanguageServiceProvider.getLanguageService(clangServiceProvider).shutDownServer());
        this.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.setToolTipText(String.format(TOOLTIP_PATTERN, this.myShown / 0x100000L, this.myLimitShown / 0x100000L));
        this.updateUI();
        new UiNotifyConnector((Component)this, (Activatable)this);
        project2.getMessageBus().connect((Disposable)project2).subscribe(ClangMemoryUsageWatchDogListener.TOPIC, (Object)this);
        this.setShowing(UISettings.getInstance().getShowMemoryIndicator());
    }

    public void showNotify() {
        this.updateState();
    }

    public void hideNotify() {
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return null;
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public void setShowing(boolean showing) {
        if (showing != this.isVisible()) {
            this.setVisible(showing);
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        this.myBufferedImage = null;
        super.updateUI();
        this.setFont(ClangMemoryUsagePanel.getWidgetFont());
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.myBufferedImage = null;
        this.setShowing(uiSettings.getShowMemoryIndicator());
    }

    private static Font getWidgetFont() {
        return JBUI.Fonts.label((float)11.0f);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean pressed = this.getModel().isPressed();
        boolean stateChanged = this.myWasPressed != pressed;
        this.myWasPressed = pressed;
        if (this.myBufferedImage == null || stateChanged) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            this.myBufferedImage = UIUtil.createImage((Graphics)g, (int)size.width, (int)size.height, (int)2);
            Graphics2D g2 = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)this.myBufferedImage.createGraphics());
            UISettings.setupAntialiasing((Graphics)g2);
            g2.setFont(this.getFont());
            int textHeight = g2.getFontMetrics().getAscent();
            boolean disabled = this.myLimitShown <= 0L;
            long maxMem = disabled ? 0L : this.myLimitShown;
            long usedMem = disabled ? 0L : this.myShown;
            int usedBarLength = disabled ? 0 : (int)((long)size.width * usedMem / maxMem);
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(0, 0, size.width, size.height);
            g2.setColor(USED_COLOR);
            g2.fillRect(0, 0, usedBarLength, size.height);
            g2.setColor(pressed ? UIUtil.getLabelDisabledForeground() : JBColor.foreground());
            String text = String.format(MSG_PATTERN, usedMem / 0x100000L, maxMem / 0x100000L);
            int textX = insets.left;
            int textY = insets.top + (size.height - insets.top - insets.bottom - textHeight) / 2 + textHeight - JBUI.scale((int)1);
            g2.drawString(text, textX, textY);
            g2.dispose();
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myBufferedImage, (int)0, (int)0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics metrics = this.getFontMetrics(ClangMemoryUsagePanel.getWidgetFont());
        Insets insets = this.getInsets();
        int width = metrics.stringWidth(this.mySample) + insets.left + insets.right + JBUI.scale((int)2);
        int height = metrics.getHeight() + insets.top + insets.bottom + JBUI.scale((int)2);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void onMaxMemoryChanged(long maxMemory) {
        this.myLastLimit = maxMemory;
        if (this.isShowing()) {
            this.updateState();
        }
    }

    @Override
    public void onUsedMemoryChanged(long usedMemory) {
        this.myLastReported = usedMemory;
        ClangMemoryUsageWatchDog memoryUsageWatchDog = ClangLanguageServiceProvider.getLanguageService(this.myProject).getMemoryUsageWatchDog();
        if (memoryUsageWatchDog != null) {
            this.myLastLimit = memoryUsageWatchDog.getMaxMemory();
        }
        if (this.isShowing()) {
            this.updateState();
        }
    }

    private void updateState() {
        if (this.myLastReported != this.myShown || this.myLastLimit != this.myLimitShown) {
            this.myShown = this.myLastReported;
            this.myLimitShown = this.myLastLimit;
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myBufferedImage = null;
                this.repaint();
            });
            this.setToolTipText(String.format(TOOLTIP_PATTERN, this.myShown / 0x100000L, this.myLimitShown / 0x100000L));
        }
    }
}

