/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangFile
extends UserDataHolderEx {
    public static final Key<Set<String>> UNSAVED_FILES = new Key("UnsavedFiles");
    public static final Key<Long> MODIFICATION_STAMP = new Key("ModificationStamp");
    public static final Key<Long> MODIFICATION_COUNT = new Key("ModificationCount");
    public static final Key<Long> PSI_GLOBAL_MODIFICATION_COUNTER = new Key("PsiGlobalModificationCounter");

    public long getGlobalVersion();

    @NotNull
    public String getUrl();

    @NotNull
    public String getName();

    @Nullable
    public <T> T withVirtualFile(@NotNull Function<VirtualFile, T> var1);

    @Nullable
    public <T> T withVirtualFile(@NotNull Function<VirtualFile, T> var1, @Nullable BooleanSupplier var2);

    public int getVersion();

    public boolean isOpened();

    @NotNull
    public Operation getOperation();

    @NotNull
    public CompletableFuture<Boolean> getOperationState();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics();

    public static boolean isInDoneState(@NotNull ClangFile file) {
        return file.getOperationState().isDone();
    }

    public static boolean isInFinishedState(@NotNull ClangFile file) {
        try {
            return ClangFile.isInDoneState(file) && file.getOperationState().get() != false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static boolean isInFailedState(@NotNull ClangFile file) {
        try {
            return ClangFile.isInDoneState(file) && file.getOperationState().get() == false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static void completeAnswers(@NotNull ClangFile file) {
        file.getDiagnostics().complete(null);
        file.getOurTidyDiagnostics().complete(null);
        file.getTidyDiagnostics().complete(null);
        file.getHighlightings().complete(null);
    }

    public static boolean didAnswersCome(@NotNull ClangFile file) {
        return file.getDiagnostics().isDone() && file.getOurTidyDiagnostics().isDone() && file.getTidyDiagnostics().isDone() && file.getHighlightings().isDone() && !file.getDiagnostics().isCompletedExceptionally() && !file.getOurTidyDiagnostics().isCompletedExceptionally() && !file.getTidyDiagnostics().isCompletedExceptionally() && !file.getHighlightings().isCompletedExceptionally();
    }

    public static enum Operation {
        Open(false),
        Close(false),
        Delete(false),
        Change(false),
        Reparse(true),
        StrongReparse(true),
        CancelParse(false);

        private final boolean myExpectDiagnostics;

        private Operation(boolean expectDiagnostics) {
            this.myExpectDiagnostics = expectDiagnostics;
        }

        public boolean isReparseEvent() {
            return this == Reparse || this == StrongReparse;
        }

        public boolean getExpectDiagnostics() {
            return this.myExpectDiagnostics;
        }

        public boolean isCancellable() {
            return this != StrongReparse;
        }
    }
}

