/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangFileSharedData {
    @NotNull
    public Set<Key<?>> keys();

    public <T> T get(@NotNull Key<T> var1);

    public <T> void put(@NotNull Key<T> var1, T var2);

    public void dropRemoteProperties();

    public static final class Key<T> {
        @NotNull
        private final String key;
        private final boolean remoteProperty;
        @Nullable
        private final Supplier<T> defValueProvider;

        public Key(@NotNull String key, boolean remoteProperty, @Nullable Supplier<T> defValueProvider) {
            this.key = key;
            this.remoteProperty = remoteProperty;
            this.defValueProvider = defValueProvider;
        }

        public Key(@NotNull String key, boolean remoteProperty) {
            this(key, remoteProperty, null);
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        public T getValue(@NotNull ClangDaemonContext context, @NotNull String url) {
            return this.getValue(context.getFilesRegistry(), url, null);
        }

        public T getValue(@NotNull ClangDaemonContext context, @NotNull String url, @Nullable T whenFileNotFound) {
            return this.getValue(context.getFilesRegistry(), url, whenFileNotFound);
        }

        public T getValue(@NotNull ClangFilesRegistry registry, @NotNull String url) {
            return this.getValue(registry, url, null);
        }

        public T getValue(@NotNull ClangFilesRegistry registry, @NotNull String url, @Nullable T whenFileNotFound) {
            ClangFile file = registry.getFile(url);
            return (T)(file != null ? registry.apply(modifier -> modifier.getSharedData(file).get(this)) : whenFileNotFound);
        }

        public T getValue(@NotNull ClangFilesRegistry registry, @NotNull ClangFile file) {
            return (T)registry.apply(modifier -> this.getValue(modifier.getSharedData(file)));
        }

        public T getValue(@NotNull ClangFileSharedData shared) {
            return shared.get(this);
        }

        public boolean isRemoteProperty() {
            return this.remoteProperty;
        }

        public T createDefaultValue() {
            return this.defValueProvider != null ? (T)this.defValueProvider.get() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

