/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileSharedData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistryListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangFilesRegistry {
    private static final Logger LOG = Logger.getInstance((String)ClangFilesRegistry.class.getName());
    private static final boolean LOG_VERSIONS = false;
    private static final boolean DEBUG_KEEP_HISTORY = false;
    private static final int FILE_INITIAL_VERSION = 2;
    private static final int REMOTE_FILE_INITIAL_VERSION = 0;
    private static final int FILES_STORAGE_SIZE = 32;
    private long myGlobalVersionCounter = 0L;
    @NotNull
    private final ClangUrlConverter myConverter;
    @NotNull
    private final Map<String, ClangFilesList> myUrl2LatestFileMap = new ConcurrentHashMap<String, ClangFilesList>();
    @NotNull
    private final List<ClangFilesRegistryListener> myListeners = new CopyOnWriteArrayList<ClangFilesRegistryListener>();
    @NotNull
    private final Set<String> myUnsavedFiles = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Object myLock = new Object();

    public ClangFilesRegistry() {
        this(new ClangUrlConverter());
    }

    public ClangFilesRegistry(@NotNull ClangUrlConverter converter) {
        this.myConverter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(@NotNull Consumer<RegistryModifier> modifier) {
        Object object = this.myLock;
        synchronized (object) {
            modifier.consume((Object)new RegistryModifier());
        }
    }

    public void modifyWithRead(@NotNull Consumer<RegistryModifier> modifier) {
        ReadAction.run(() -> this.modify(modifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T apply(@NotNull Function<RegistryModifier, T> modifier) {
        Object object = this.myLock;
        synchronized (object) {
            return modifier.apply(new RegistryModifier());
        }
    }

    public <T> T applyWithRead(@NotNull Function<RegistryModifier, T> modifier) {
        return (T)ReadAction.compute(() -> this.apply(modifier));
    }

    public void addListener(@NotNull ClangFilesRegistryListener listener) {
        this.myListeners.add(listener);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    @NotNull
    public List<ClangFile> getFiles() {
        return this.apply(modifier -> {
            ArrayList<ClangFileImpl> files = new ArrayList<ClangFileImpl>(this.myUrl2LatestFileMap.size());
            for (ClangFilesList list : this.myUrl2LatestFileMap.values()) {
                ClangFileImpl last = list.getLast();
                assert (last != null);
                files.add(last);
            }
            return files;
        });
    }

    @NotNull
    public Set<String> getUnsavedFiles() {
        return new HashSet<String>(this.myUnsavedFiles);
    }

    @Nullable
    public ClangFile getOpenedFile(@NotNull String url) {
        ClangFileImpl clangFile = this.getFileImpl(url);
        return clangFile != null && clangFile.isOpened() ? clangFile : null;
    }

    @Nullable
    public ClangFile getClosedFile(@NotNull String url) {
        ClangFileImpl clangFile = this.getFileImpl(url);
        return clangFile != null && !clangFile.isOpened() ? clangFile : null;
    }

    public boolean isOpenedLocally(@NotNull String url) {
        return this.getOpenedFile(url) != null;
    }

    public boolean isClosedLocally(@NotNull String url) {
        return this.getClosedFile(url) != null;
    }

    public boolean isLatest(@NotNull ClangFile clangFile) {
        return this.isLatest(clangFile.getUrl(), clangFile.getVersion());
    }

    public boolean isLatest(@NotNull String url, int version) {
        ClangFileImpl curClangFile = this.getFileImpl(url);
        assert (curClangFile != null) : "Why client possess opened file which is not registered?!";
        return curClangFile.getVersion() == version;
    }

    public boolean isOpenedRemotely(@NotNull String url) {
        ClangFileImpl openedFile = this.getFileImpl(url);
        return openedFile != null && ClangFileRemoteProperties.REMOTE_IS_OPENED.getValue(this, openedFile) != false;
    }

    public boolean isClosedRemotely(@NotNull String url) {
        return !this.isOpenedRemotely(url);
    }

    public boolean isRegistered(@NotNull String url) {
        return this.getFile(url) != null;
    }

    @Nullable
    public ClangFile getFile(@NotNull String url) {
        return this.getFileImpl(url);
    }

    @Nullable
    private ClangFileImpl getFileImpl(@NotNull String url) {
        ClangFilesList files = this.myUrl2LatestFileMap.get(url);
        return files != null ? files.getLast() : null;
    }

    @Nullable
    public ClangFile getFile(@NotNull String url, int version) {
        return this.apply(modifier -> {
            ClangFilesList files = this.myUrl2LatestFileMap.get(url);
            if (files == null) {
                return null;
            }
            if (files.getLast().getVersion() == version) {
                return files.getLast();
            }
            for (ClangFileImpl clangFile : files) {
                if (clangFile.getVersion() != version) continue;
                return clangFile;
            }
            return null;
        });
    }

    public void debugPrintHistory(@NotNull String url) {
    }

    @NotNull
    private ClangFileImpl putNextFile(@NotNull ClangFilesList files, @NotNull String url, @Nullable VirtualFile file, int nextVersion, @NotNull ClangFile.Operation op, @NotNull ClangFileSharedData sharedData) {
        ClangFileImpl nextFile = new ClangFileImpl(url, this.myConverter.fromUri(url), file, sharedData, nextVersion, op, this.myGlobalVersionCounter);
        ++this.myGlobalVersionCounter;
        files.onClangFileCreated(nextFile);
        return nextFile;
    }

    private void postCreate(@NotNull ClangFilesList files, @Nullable VirtualFile virtualFile, @NotNull ClangFile file, @NotNull ClangFile.Operation op, @Nullable ClangFile prevFile) {
        if (!op.getExpectDiagnostics()) {
            file.getDiagnostics().complete(null);
            file.getHighlightings().complete(null);
            file.getTidyDiagnostics().complete(null);
            file.getOurTidyDiagnostics().complete(null);
        }
        if (op.getExpectDiagnostics()) {
            CompletableFuture.allOf(file.getOperationState(), file.getDiagnostics(), file.getTidyDiagnostics(), file.getOurTidyDiagnostics()).whenComplete((data, ex) -> files.onClangFileProcessed(file));
        }
        file.getOperationState().thenAccept(success -> {
            if (success.booleanValue()) {
                this.modify((Consumer<RegistryModifier>)((Consumer)modifier -> {
                    ClangFileSharedData sharedData = modifier.getSharedData(file);
                    int prevVersion = ClangFileRemoteProperties.REMOTE_VERSION.getValue(sharedData);
                    sharedData.put(ClangFileRemoteProperties.REMOTE_VERSION, file.getVersion());
                    if (ClangFilesRegistry.isOpeningOp(op)) {
                        sharedData.put(ClangFileRemoteProperties.REMOTE_IS_OPENED, true);
                    } else if (ClangFilesRegistry.isClosingOp(op)) {
                        sharedData.put(ClangFileRemoteProperties.REMOTE_IS_OPENED, false);
                    }
                    sharedData.put(ClangFileRemoteProperties.REMOTE_OPERATION, op);
                    assert (prevVersion < file.getVersion()) : "Wrong order of operations!";
                }));
            }
        });
        if (prevFile != null && prevFile.getOperation().getExpectDiagnostics() && prevFile.getOperation().isCancellable()) {
            prevFile.getDiagnostics().complete(null);
            prevFile.getHighlightings().complete(null);
            prevFile.getTidyDiagnostics().complete(null);
            prevFile.getOurTidyDiagnostics().complete(null);
        }
        if (virtualFile != null) {
            file.putUserData(ClangFile.MODIFICATION_STAMP, virtualFile.getModificationStamp());
            file.putUserData(ClangFile.MODIFICATION_COUNT, virtualFile.getModificationCount());
        }
        this.fireOnCreated(file);
    }

    private void fireOnCreated(@NotNull ClangFile file) {
        for (ClangFilesRegistryListener listener : this.myListeners) {
            listener.onCreated(file);
        }
    }

    private static int firstVersion(@NotNull ClangFile.Operation op) {
        if (ClangFilesRegistry.isOpeningOp(op)) {
            return 2;
        }
        return -2;
    }

    private static int incVersion(int version, @NotNull ClangFile.Operation op) {
        assert (version != 0);
        if (ClangFilesRegistry.isOpeningOp(op)) {
            if (version > 0) {
                return version + 1;
            }
            return -version + 1;
        }
        if (ClangFilesRegistry.isClosingOp(op)) {
            if (version > 0) {
                return -version - 1;
            }
            return version - 1;
        }
        if (version > 0) {
            return version + 1;
        }
        return version - 1;
    }

    private static boolean isOpeningOp(@NotNull ClangFile.Operation op) {
        switch (op) {
            case Open: {
                return true;
            }
            case Close: 
            case Delete: 
            case Change: 
            case Reparse: 
            case StrongReparse: 
            case CancelParse: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected operation " + (Object)((Object)op)));
    }

    private static boolean isClosingOp(@NotNull ClangFile.Operation op) {
        switch (op) {
            case Close: 
            case Delete: {
                return true;
            }
            case Open: 
            case Change: 
            case Reparse: 
            case StrongReparse: 
            case CancelParse: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected operation " + (Object)((Object)op)));
    }

    private static class ClangFilesList
    implements Iterable<ClangFileImpl> {
        @NotNull
        private final ClangFileImpl[] myData;
        private volatile ClangFileImpl myLast;
        private int mySize;
        private int myStart;

        ClangFilesList(int alloc) {
            this.myData = new ClangFileImpl[alloc];
            this.mySize = 0;
            this.myStart = 0;
        }

        private ClangFileImpl getLast() {
            return this.myLast;
        }

        public ClangFileImpl get(int i) {
            if (i < 0 || i >= this.mySize) {
                throw new IndexOutOfBoundsException();
            }
            return this.myData[(this.myStart + i) % this.mySize];
        }

        public boolean onClangFileCreated(ClangFileImpl t) {
            this.myLast = t;
            if (ClangFilesList.isRequest(t)) {
                if (this.mySize == this.myData.length) {
                    this.myData[this.myStart] = t;
                    this.myStart = (this.myStart + 1) % this.mySize;
                } else {
                    this.myData[this.mySize] = t;
                    ++this.mySize;
                }
            }
            return true;
        }

        public boolean onClangFileProcessed(@NotNull ClangFile t) {
            if (this.mySize <= 0) {
                return false;
            }
            if (!ClangFilesList.isRequest(t)) {
                return false;
            }
            if (this.myData[this.myStart] == t) {
                this.myStart = (this.myStart + 1) % this.mySize;
                --this.mySize;
                return true;
            }
            for (int i = 0; i < this.mySize; ++i) {
                if (this.myData[(this.myStart + i) % this.mySize] != t) continue;
                for (int k = i + 1; k < this.mySize; ++k) {
                    this.myData[(this.myStart + k - 1) % this.mySize] = this.myData[(this.myStart + k) % this.mySize];
                }
                --this.mySize;
                return true;
            }
            return false;
        }

        public int sizeOfPending() {
            return this.mySize;
        }

        public void clearPending() {
            this.myStart = 0;
            this.mySize = 0;
        }

        @Override
        @NotNull
        public Iterator<ClangFileImpl> iterator() {
            return new Iterator<ClangFileImpl>(){
                int curIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.curIndex < this.sizeOfPending();
                }

                @Override
                public ClangFileImpl next() {
                    return this.get(this.curIndex++);
                }
            };
        }

        private static boolean isRequest(@NotNull ClangFile file) {
            return file.getOperation() == ClangFile.Operation.StrongReparse;
        }
    }

    private static class TracingClangFileImpl
    extends ClangFileImpl {
        @Nullable
        private final TracingClangFileImpl myPrevious;

        TracingClangFileImpl(@Nullable TracingClangFileImpl previous, @NotNull String url, @NotNull String path, @Nullable VirtualFile file, @NotNull ClangFileSharedData sharedData, int version, @NotNull ClangFile.Operation op, long globalVersion) {
            super(url, path, file, sharedData, version, op, globalVersion);
            this.myPrevious = previous;
        }

        @Nullable
        public TracingClangFileImpl getPrevious() {
            return this.myPrevious;
        }
    }

    private static class ClangFileImpl
    extends UserDataHolderBase
    implements ClangFile {
        private final long myGlobalVersion;
        @NotNull
        private final String myUrl;
        @Nullable
        private final VirtualFile myFile;
        @NotNull
        private final ClangFileSharedData mySharedData;
        private final int myVersion;
        @NotNull
        private final ClangFile.Operation myOperation;
        @NotNull
        private final CompletableFuture<Boolean> myOperationState = new CompletableFuture();
        @NotNull
        private final CompletableFuture<Supplier<List<ClangDiagnostic>>> myDiagnostics = new CompletableFuture();
        @NotNull
        private final CompletableFuture<Supplier<List<ClangHighlighting>>> myHighlightings = new CompletableFuture();
        @NotNull
        private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myOurTidyDiagnostics = new CompletableFuture();
        @NotNull
        private final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> myTidyDiagnostics = new CompletableFuture();

        ClangFileImpl(@NotNull String url, @NotNull String path, @Nullable VirtualFile file, @NotNull ClangFileSharedData sharedData, int version, @NotNull ClangFile.Operation op, long globalVersion) {
            this.myGlobalVersion = globalVersion;
            this.myUrl = url;
            this.myFile = file;
            this.mySharedData = sharedData;
            this.myVersion = version;
            this.myOperation = op;
            if (Registry.is((String)"clion.clang.clangd.debug")) {
                long startTime = System.currentTimeMillis();
                String fileName = new File(path).getName();
                this.myDiagnostics.thenAccept(res -> {
                    long diagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                    ClangUtils.infoClangd(LOG, "Calculation of diagnostics for " + fileName + " took " + diagnosticsCalculationDuration + " ms");
                });
                this.myHighlightings.thenAccept(res -> {
                    long highlightingsCalculationDuration = System.currentTimeMillis() - startTime;
                    ClangUtils.infoClangd(LOG, "Calculation of highlightings for " + fileName + " took " + highlightingsCalculationDuration + " ms");
                });
                this.myOurTidyDiagnostics.thenAccept(res -> {
                    long calculationDuration = System.currentTimeMillis() - startTime;
                    ClangUtils.infoClangd(LOG, "Calculation of our clang-tidy diagnostics for " + fileName + " took " + calculationDuration + " ms");
                });
                this.myTidyDiagnostics.thenAccept(res -> {
                    long tidyDiagnosticsCalculationDuration = System.currentTimeMillis() - startTime;
                    ClangUtils.infoClangd(LOG, "Calculation of clang-tidy diagnostics for " + fileName + " took " + tidyDiagnosticsCalculationDuration + " ms");
                });
            }
        }

        @Override
        public long getGlobalVersion() {
            return this.myGlobalVersion;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        @NotNull
        public String getName() {
            String url = this.getUrl();
            int index = url.lastIndexOf(47);
            return index == -1 ? url : url.substring(index + 1);
        }

        @Override
        @Nullable
        public <T> T withVirtualFile(@NotNull Function<VirtualFile, T> consumer) {
            return this.withVirtualFile(consumer, null);
        }

        @Override
        @Nullable
        public <T> T withVirtualFile(@NotNull Function<VirtualFile, T> consumer, @Nullable BooleanSupplier expireCondition) {
            Ref computed = Ref.create(null);
            Runnable validateAndCompute = () -> {
                if (this.myFile == null) {
                    return;
                }
                if (!this.myFile.isValid()) {
                    return;
                }
                if (!this.myUrl.contentEquals(this.myFile.getUrl())) {
                    return;
                }
                computed.set(consumer.apply(this.myFile));
            };
            ClangLanguageServiceUtils.runClangReadAction(validateAndCompute, expireCondition);
            return (T)computed.get();
        }

        @Override
        public int getVersion() {
            return Math.abs(this.myVersion);
        }

        @Override
        public boolean isOpened() {
            return this.getInternalVersion() >= 2;
        }

        @Override
        @NotNull
        public ClangFile.Operation getOperation() {
            return this.myOperation;
        }

        @Override
        @NotNull
        public CompletableFuture<Boolean> getOperationState() {
            return this.myOperationState;
        }

        @Override
        @NotNull
        public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics() {
            return this.myDiagnostics;
        }

        @Override
        @NotNull
        public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings() {
            return this.myHighlightings;
        }

        @Override
        @NotNull
        public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics() {
            return this.myOurTidyDiagnostics;
        }

        @Override
        @NotNull
        public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics() {
            return this.myTidyDiagnostics;
        }

        private int getInternalVersion() {
            return this.myVersion;
        }

        public String toString() {
            return this.getUrl() + "([" + this.getOperation().name() + ", " + this.getVersion() + ", " + (this.isOpened() ? "Opened" : "Closed") + "] -> [" + (Object)((Object)ClangFileRemoteProperties.REMOTE_OPERATION.getValue(this.mySharedData)) + ", " + ClangFileRemoteProperties.REMOTE_VERSION.getValue(this.mySharedData) + ", " + (ClangFileRemoteProperties.REMOTE_IS_OPENED.getValue(this.mySharedData) != false ? "Opened" : "Closed") + "])";
        }
    }

    public final class RegistryModifier {
        @NotNull
        public ClangFile nextVersion(@NotNull ClangFile file, @NotNull ClangFile.Operation operation) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            return this.nextVersion(file.getUrl(), file.withVirtualFile(vf -> vf), operation);
        }

        @NotNull
        public ClangFile nextVersion(@NotNull String url, @Nullable VirtualFile file, @NotNull ClangFile.Operation operation) {
            ClangFileImpl nextFile;
            ClangFileImpl prevFile;
            ClangFilesList files = (ClangFilesList)ClangFilesRegistry.this.myUrl2LatestFileMap.get(url);
            if (files == null) {
                files = new ClangFilesList(32);
                ClangFilesRegistry.this.myUrl2LatestFileMap.put(url, files);
            }
            if ((prevFile = files.getLast()) != null) {
                int nextVersion = ClangFilesRegistry.incVersion(prevFile.getInternalVersion(), operation);
                nextFile = ClangFilesRegistry.this.putNextFile(files, url, file, nextVersion, operation, prevFile.mySharedData);
            } else {
                int nextVersion = ClangFilesRegistry.firstVersion(operation);
                nextFile = ClangFilesRegistry.this.putNextFile(files, url, file, nextVersion, operation, new ClangFileSharedDataImpl(url, ClangFilesRegistry.this.myListeners));
            }
            ClangFilesRegistry.this.postCreate(files, file, nextFile, operation, prevFile);
            return nextFile;
        }

        @NotNull
        public ClangFileSharedData getSharedData(@NotNull ClangFile file) {
            return ((ClangFileImpl)file).mySharedData;
        }

        @Nullable
        public ClangFileSharedData getSharedData(@NotNull String url) {
            ClangFile file = ClangFilesRegistry.this.getFile(url);
            return file != null ? this.getSharedData(file) : null;
        }

        @NotNull
        public Set<String> getUnsavedFiles() {
            return ClangFilesRegistry.this.myUnsavedFiles;
        }

        public void dropRemoteState() {
            ClangFilesRegistry.this.myUnsavedFiles.clear();
            this.completePendingAnswers();
            for (ClangFilesList filesList : ClangFilesRegistry.this.myUrl2LatestFileMap.values()) {
                this.getSharedData(filesList.getLast()).dropRemoteProperties();
            }
        }

        public void completePendingAnswers() {
            for (ClangFilesList filesList : ClangFilesRegistry.this.myUrl2LatestFileMap.values()) {
                int size = filesList.sizeOfPending();
                for (int i = size - 1; i >= 0; --i) {
                    ClangFileImpl file = filesList.get(i);
                    if (!ClangFile.isInDoneState(file)) continue;
                    ClangFile.completeAnswers(file);
                }
            }
        }
    }

    private static final class ClangFileSharedDataImpl
    implements ClangFileSharedData {
        @NotNull
        private final String myUrl;
        @NotNull
        private final List<ClangFilesRegistryListener> myListeners;
        @NotNull
        private final Map<ClangFileSharedData.Key<?>, Object> myData = new HashMap();

        ClangFileSharedDataImpl(@NotNull String url, @NotNull List<ClangFilesRegistryListener> listeners) {
            this.myUrl = url;
            this.myListeners = listeners;
        }

        @Override
        @NotNull
        public Set<ClangFileSharedData.Key<?>> keys() {
            return this.myData.keySet();
        }

        @Override
        public <T> void put(@NotNull ClangFileSharedData.Key<T> key, T data) {
            this.myData.put(key, data);
            this.fireOnSharedDataPut(this.myUrl, key, data);
        }

        @Override
        public <T> T get(@NotNull ClangFileSharedData.Key<T> key) {
            if (this.myData.containsKey(key)) {
                return (T)this.myData.get(key);
            }
            T val = key.createDefaultValue();
            if (val != null) {
                this.put(key, val);
            }
            return val;
        }

        @Override
        public void dropRemoteProperties() {
            Iterator<ClangFileSharedData.Key<?>> keysIter = this.myData.keySet().iterator();
            while (keysIter.hasNext()) {
                ClangFileSharedData.Key<?> nextKey = keysIter.next();
                if (!nextKey.isRemoteProperty()) continue;
                keysIter.remove();
            }
            this.fireOnSharedRemotePropertiesDropped(this.myUrl);
        }

        private void fireOnSharedDataPut(@NotNull String url, @NotNull ClangFileSharedData.Key<?> key, @Nullable Object data) {
            for (ClangFilesRegistryListener listener : this.myListeners) {
                listener.onSharedDataPut(url, key, data);
            }
        }

        private void fireOnSharedRemotePropertiesDropped(@NotNull String url) {
            for (ClangFilesRegistryListener listener : this.myListeners) {
                listener.onSharedRemotePropertiesDropped(url);
            }
        }
    }
}

