/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageServiceReparsingPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)OCLanguageServiceReparsingPass.class.getName());
    @NotNull
    private final PsiFile myFile;

    public OCLanguageServiceReparsingPass(@NotNull Project project2, @NotNull PsiFile file, @Nullable Document document2) {
        super(project2, document2);
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (!ClangAnnotatorUtilsKt.shouldReparse(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            LOG.warn("Unsupported PSI file: " + this.myFile.getName());
            return;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(this.myProject);
        ClangFile currentFile = service.getLastClangFile(virtualFile);
        if (ClangUtils.needReparse(this.myProject, currentFile)) {
            service.notifyCancelRequired(virtualFile);
            currentFile = service.notifyReparseRequired(virtualFile, true);
        }
    }

    public void doApplyInformationToEditor() {
    }
}

