/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdConfigurable
extends CPPLanguageConfigurable {
    private JBCheckBox myShowErrorsFromClangdJBCheckBox;
    private JBCheckBox myUseClangTidyViaJBCheckBox;
    private JPanel myRootPanel;
    private JPanel myClangWarningsEditor;
    private JPanel myClangErrorsAndWarningsPanel;
    private JPanel myClangTidyPanel;
    private JPanel myClangNavigationPanel;
    private JBCheckBox myUseNavigationViaClangdCheckBox;
    private JBLabel myEnabledCLionInspectionsHint;
    private JBCheckBox myClangdEnableJBCheckBox;
    private JPanel myClangdOptionsPanel;
    private JTextPane mySeeTheListOfTextPane;
    @NotNull
    private final Project myProject;
    private Disposable myUILifeTimeDisposable;
    @NotNull
    private final ClangdSettings mySettings;
    public static final String ID = "language.cpp.clangd";

    public ClangdConfigurable(@NotNull Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.mySettings = ClangdSettings.getInstance(project2);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        this.initializeUI();
        return this.myRootPanel;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.clangd";
    }

    @Override
    public boolean isModified() {
        return this.myShowErrorsFromClangdJBCheckBox.isSelected() != this.mySettings.isClangdShowErrors() || this.myUseClangTidyViaJBCheckBox.isSelected() != this.mySettings.isClangTidyViaClangd() || this.myUseNavigationViaClangdCheckBox.isSelected() != this.mySettings.isNavigationViaClangd() || this.myClangdEnableJBCheckBox.isSelected() != this.mySettings.isClangdEnabled() || !Objects.equals(this.mySettings.getClangWarnings(), ((TextAccessor)this.myClangWarningsEditor).getText());
    }

    @Override
    public void apply() throws ConfigurationException {
        this.saveSettings();
        ClangdSettings.rehighlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ClangdSettings clangdSettings = this.mySettings;
        synchronized (clangdSettings) {
            this.myClangdEnableJBCheckBox.setSelected(this.mySettings.isClangdEnabled());
            this.myShowErrorsFromClangdJBCheckBox.setSelected(this.mySettings.isClangdShowErrors());
            this.myUseClangTidyViaJBCheckBox.setSelected(this.mySettings.isClangTidyViaClangd());
            this.myUseNavigationViaClangdCheckBox.setSelected(this.mySettings.isNavigationViaClangd());
            ((TextAccessor)this.myClangWarningsEditor).setText(this.mySettings.getClangWarnings());
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "Clangd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        ClangdSettings clangdSettings = this.mySettings;
        synchronized (clangdSettings) {
            this.mySettings.setClangdShowErrors(this.myShowErrorsFromClangdJBCheckBox.isSelected());
            this.mySettings.setClangTidyViaClangd(this.myUseClangTidyViaJBCheckBox.isSelected());
            this.mySettings.setNavigationViaClangd(this.myUseNavigationViaClangdCheckBox.isSelected());
            this.mySettings.setClangdEnabled(this.myClangdEnableJBCheckBox.isSelected());
            this.mySettings.setClangWarnings(((TextAccessor)this.myClangWarningsEditor).getText());
        }
    }

    private void initializeUI() {
        this.myClangErrorsAndWarningsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Clang errors and warnings", (boolean)false));
        this.myClangTidyPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Clang-Tidy and CLion inspections", (boolean)false));
        this.myClangNavigationPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Navigation", (boolean)false));
        ((TextAccessor)this.myClangWarningsEditor).setText(this.mySettings.getClangWarnings());
        this.myShowErrorsFromClangdJBCheckBox.setSelected(this.mySettings.isClangdShowErrors());
        this.mySeeTheListOfTextPane.setBackground(this.myShowErrorsFromClangdJBCheckBox.getBackground());
        Messages.configureMessagePaneUi((JTextPane)this.mySeeTheListOfTextPane, (String)("<html><body bgcolor=" + ColorUtil.toHtmlColor((Color)this.myShowErrorsFromClangdJBCheckBox.getBackground()) + ">See the list of <a href='https://clang.llvm.org/docs/DiagnosticsReference.html'>diagnostic flags</a></body></html>"), null);
        this.mySeeTheListOfTextPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserUtil.browse((String)e.getDescription());
            }
        });
        this.myUseClangTidyViaJBCheckBox.setSelected(this.mySettings.isClangTidyViaClangd());
        this.myUseNavigationViaClangdCheckBox.setSelected(this.mySettings.isNavigationViaClangd());
        final Runnable onShowErrorsStateChanged = () -> UIUtil.setEnabled((Component)this.myClangWarningsEditor, (boolean)this.myShowErrorsFromClangdJBCheckBox.isSelected(), (boolean)true);
        this.myShowErrorsFromClangdJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                onShowErrorsStateChanged.run();
                ClangdSettings.rehighlight();
            }
        });
        final Runnable onClangdEnableStateChanged = () -> {
            boolean enableOptions = this.myClangdEnableJBCheckBox.isSelected();
            ((ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC_UI)).onClangdOnChanged(enableOptions);
            UIUtil.setEnabled((Component)this.myClangdOptionsPanel, (boolean)enableOptions, (boolean)true);
            if (enableOptions) {
                onShowErrorsStateChanged.run();
            }
        };
        onClangdEnableStateChanged.run();
        this.myClangdEnableJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                onClangdEnableStateChanged.run();
            }
        });
        this.myUILifeTimeDisposable = Disposer.newDisposable((String)"ClangSettingsUI");
        Disposer.register((Disposable)this.myProject, (Disposable)this.myUILifeTimeDisposable);
        this.myProject.getMessageBus().connect(this.myUILifeTimeDisposable).subscribe(ClangdSettingsListener.TOPIC_UI, (Object)new ClangdSettingsListener(){

            @Override
            public void onClangdOnChanged(boolean clangdOnInUI) {
                ClangdConfigurable.this.myClangdEnableJBCheckBox.setSelected(clangdOnInUI);
            }
        });
    }

    private void createUIComponents() {
        this.myClangWarningsEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        this.myEnabledCLionInspectionsHint = this.createCLionInspectionsHint();
    }

    public void disposeUIResources() {
        if (this.myUILifeTimeDisposable != null) {
            Disposer.dispose((Disposable)this.myUILifeTimeDisposable);
            this.myUILifeTimeDisposable = null;
        }
    }

    private JBLabel createCLionInspectionsHint() {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)this.myProject);
        InspectionProfileImpl profile2 = profileManager.getProfile(currentProfile);
        if (profile2 == null) {
            return new JBLabel();
        }
        List inspections = profile2.getAllEnabledInspectionTools(this.myProject).stream().map(t -> t.getTool()).filter(t -> t.getTool() instanceof OurClangTidyInspection).map(t -> (OurClangTidyInspection)t.getTool()).map(i -> i.getDisplayName()).sorted().collect(Collectors.toList());
        String inspectionsToEnable = StringUtil.join(inspections, (String)"<br/>");
        return ContextHelpLabel.create((String)("The following CLion inspections will be enabled:<br/><br/>" + inspectionsToEnable));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        JTextPane jTextPane;
        JBCheckBox jBCheckBox3;
        JPanel jPanel3;
        JPanel jPanel4;
        JBCheckBox jBCheckBox4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myRootPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myClangdEnableJBCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setMargin(new Insets(10, 10, 4, 4));
        jBCheckBox4.setText("Enable clangd server.    Important: Disabling the server disables ClangFormat.");
        jBCheckBox4.setMnemonic('E');
        jBCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myClangdOptionsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myClangErrorsAndWarningsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(14, 25), null));
        JPanel jPanel7 = this.myClangWarningsEditor;
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShowErrorsFromClangdJBCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setHorizontalTextPosition(11);
        jBCheckBox3.setMargin(new Insets(0, 10, 0, 0));
        jBCheckBox3.setSelected(false);
        jBCheckBox3.setText("Show errors and warnings from clangd.");
        jPanel8.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(230, 25), null));
        this.mySeeTheListOfTextPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/plain");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setMargin(new Insets(0, 0, 0, 0));
        jTextPane.setText("text");
        jPanel8.add((Component)jTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myClangTidyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseClangTidyViaJBCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setMargin(new Insets(4, 10, 4, 4));
        jBCheckBox2.setText("Use clang-tidy via clangd (also enables some CLion builtin inspections)");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = this.myEnabledCLionInspectionsHint;
        jBLabel.setText("");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myClangNavigationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseNavigationViaClangdCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use navigation via clangd");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel4.add((Component)spacer7, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel4.add((Component)spacer8, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

