/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="ClangdSettings", storages={@Storage(value="$WORKSPACE_FILE$"), @Storage(value="other.xml", deprecated=true)})
public class ClangdSettings
implements PersistentStateComponent<StoredState> {
    private static final List<ClangFeatures.Warning> DISABLE_FOR_UnusedInspections = Collections.singletonList(ClangFeatures.Warnings.UNUSED_WARIABLE);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_HidesUpperScope = Collections.singletonList(ClangFeatures.Warnings.SHADOW);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_FunctionImplicitDeclarationInspection = Collections.singletonList(ClangFeatures.Warnings.IMPLICIT_FUNCTION_DECLARATION);
    private static final String DEFAULT_DISABLED_WARNINGS = ClangdSettings.makeWarningsDisabled(DISABLE_FOR_UnusedInspections);
    private static final String DEFAULT_ENABLED_WARNINGS = ClangdSettings.makeWarningsEnabled(DISABLE_FOR_HidesUpperScope);
    private static final String DEFAULT_DISABLED_ERRORS = ClangdSettings.makeWarningsAsErrors(DISABLE_FOR_FunctionImplicitDeclarationInspection);
    public static final Key<List<String>> DISABLED_WARNINGS = Key.create((String)"DISABLED_WARNINGS");
    @NotNull
    private final Project myProject;
    private boolean myClangdShowErrors;
    private boolean myClangTidyViaClangd;
    private boolean myNavigationViaClangd;
    private boolean myFormatViaClangd;
    private boolean myClangdEnabled;
    private String myClangWarnings;

    public ClangdSettings(@NotNull Project project2) {
        this.myProject = project2;
        StoredState defaultState = new StoredState();
        this.myClangdShowErrors = defaultState.clangdShowErrors;
        this.myClangTidyViaClangd = defaultState.clangTidyViaClangd;
        this.myNavigationViaClangd = defaultState.navigationViaClangd;
        this.myFormatViaClangd = defaultState.formatViaClangd;
        this.myClangdEnabled = defaultState.clangdEnabled;
        this.myClangWarnings = defaultState.clangWarnings;
    }

    public static ClangdSettings getInstance(@NotNull Project project2) {
        return (ClangdSettings)ServiceManager.getService((Project)project2, ClangdSettings.class);
    }

    public synchronized boolean isClangdOn() {
        return this.myClangdEnabled && (this.myClangdShowErrors || this.myClangTidyViaClangd || this.myNavigationViaClangd || this.myFormatViaClangd);
    }

    public synchronized boolean isClangdShowErrors() {
        return this.myClangdShowErrors;
    }

    public synchronized void setClangdShowErrors(boolean clangdShowErrors) {
        this.setProperty(value -> {
            this.myClangdShowErrors = value;
        }, ClangdSettingsListener::onClangdShowErrorsChanged, this.myClangdShowErrors, clangdShowErrors);
    }

    public synchronized boolean isClangTidyViaClangd() {
        return this.myClangTidyViaClangd;
    }

    public synchronized void setClangTidyViaClangd(boolean clangTidyViaClangd) {
        this.setProperty(value -> {
            this.myClangTidyViaClangd = value;
        }, ClangdSettingsListener::onClangTidyViaClangdChanged, this.myClangTidyViaClangd, clangTidyViaClangd);
    }

    public synchronized boolean isNavigationViaClangd() {
        return this.myNavigationViaClangd;
    }

    public synchronized void setNavigationViaClangd(boolean navigationViaClangd) {
        this.setProperty(value -> {
            this.myNavigationViaClangd = value;
        }, ClangdSettingsListener::onNavigationViaClangdChanged, this.myNavigationViaClangd, navigationViaClangd);
    }

    public synchronized boolean isFormatViaClangd() {
        return this.myFormatViaClangd;
    }

    public synchronized void setFormatViaClangd(boolean formatViaClangd) {
        this.setProperty(value -> {
            this.myFormatViaClangd = value;
        }, ClangdSettingsListener::onFormatViaClangdChanged, this.myFormatViaClangd, formatViaClangd);
    }

    public synchronized boolean isClangdEnabled() {
        return this.myClangdEnabled;
    }

    public synchronized void setClangdEnabled(boolean clangdEnabled) {
        this.setProperty(value -> {
            this.myClangdEnabled = value;
        }, ClangdSettingsListener::onClangdEnabled, this.myClangdEnabled, clangdEnabled);
    }

    @NotNull
    public synchronized String getClangWarnings() {
        return StringUtil.notNullize((String)this.myClangWarnings);
    }

    public synchronized void setClangWarnings(@NotNull String clangWarnings) {
        this.myClangWarnings = clangWarnings;
    }

    @NotNull
    public synchronized StoredState getState() {
        StoredState state = new StoredState();
        state.clangdShowErrors = this.myClangdShowErrors;
        state.clangTidyViaClangd = this.myClangTidyViaClangd;
        state.navigationViaClangd = this.myNavigationViaClangd;
        state.formatViaClangd = this.myFormatViaClangd;
        state.clangdEnabled = this.myClangdEnabled;
        state.clangWarnings = this.myClangWarnings;
        return state;
    }

    public synchronized void loadState(@NotNull StoredState state) {
        this.setClangdShowErrors(state.clangdShowErrors);
        this.setClangTidyViaClangd(state.clangTidyViaClangd);
        this.setNavigationViaClangd(state.navigationViaClangd);
        this.setFormatViaClangd(state.formatViaClangd);
        this.setClangdEnabled(state.clangdEnabled);
        this.setClangWarnings(state.clangWarnings);
    }

    @NotNull
    private ClangdSettingsListener getPublisher() {
        return (ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC);
    }

    public static void rehighlight() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            PsiModificationTrackerImpl tracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project2).getModificationTracker();
            TransactionGuard.getInstance().submitTransactionAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> tracker.incCounter()));
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).restart();
        }
    }

    @NotNull
    private static String makeWarningsDisabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getDisabledOnlyThis());
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @NotNull
    private static String makeWarningsEnabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(false));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @NotNull
    private static String makeWarningsAsErrors(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(true));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    private void setProperty(@NotNull Consumer<Boolean> propertySetter, @NotNull BiConsumer<ClangdSettingsListener, Boolean> propertyListener, boolean oldValue, boolean newValue) {
        if (newValue != oldValue) {
            boolean oldClangdOn = this.isClangdOn();
            propertySetter.accept(newValue);
            propertyListener.accept(this.getPublisher(), newValue);
            boolean newClangOn = this.isClangdOn();
            if (oldClangdOn != newClangOn) {
                this.getPublisher().onClangdOnChanged(newClangOn);
            }
        }
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_DISABLED_WARNINGS;
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_DISABLED_ERRORS;
    }

    static /* synthetic */ String access$200() {
        return DEFAULT_ENABLED_WARNINGS;
    }

    static class StoredState {
        public boolean clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
        public boolean clangTidyViaClangd = true;
        public boolean navigationViaClangd = true;
        public boolean formatViaClangd = true;
        public boolean clangdEnabled = true;
        public String clangWarnings = StringUtil.join(Arrays.asList(ClangdSettings.access$000(), ClangdSettings.access$100(), ClangdSettings.access$200(), ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : ""), (String)",");

        StoredState() {
        }
    }
}

