/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCConstantAnnotatorEnabler;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ClangLanguageServiceStartupActivity
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)ClangLanguageServiceStartupActivity.class.getName());

    public void runActivity(@NotNull Project project2) {
        if (project2.isDefault() || project2.isDisposed()) {
            return;
        }
        Ref initFuture = Ref.create();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project2);
            if (provider2 == null) {
                return;
            }
            final ClangLanguageServiceProvider[] providers = new ClangLanguageServiceProvider[]{provider2};
            if (ClangUtils.isClangdOn(project2)) {
                CompletableFuture<?> future = ClangLanguageServiceStartupActivity.initLanguageServices(providers, project2);
                initFuture.set(future);
            }
            ClangLanguageServiceStartupActivity.configureDefaultAnnotators(project2);
            project2.getMessageBus().connect((Disposable)project2).subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project2, providers));
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                    for (ClangLanguageServiceProvider provider2 : providers) {
                        ClangLanguageService service;
                        if (file == null || (service = provider2.getService()) == null) continue;
                        service.notifyDocumentChanged(file, event);
                    }
                }
            }, (Disposable)project2);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getService();
                            if (service == null) continue;
                            service.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getService();
                            if (service == null) continue;
                            service.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }
            }, (Disposable)project2);
            VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event.isFromSave()) {
                        VirtualFile file = event.getFile();
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getService();
                            if (service == null) continue;
                            service.notifyDocumentSaved(file);
                        }
                    }
                }

                public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                    if ("name".equals(event.getPropertyName()) && !Objects.equals(event.getNewValue(), event.getOldValue())) {
                        String newName = (String)event.getNewValue();
                        String newUrl = event.getFile().getUrl();
                        assert (newUrl.endsWith(newName));
                        String oldName = (String)event.getOldValue();
                        String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getService();
                            if (service == null) continue;
                            service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                        }
                    }
                }

                public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                    VirtualFile file = event.getFile();
                    String oldUrl = event.getOldParent().getUrl() + "/" + file.getName();
                    String newUrl = file.getUrl();
                    for (ClangLanguageServiceProvider provider2 : providers) {
                        ClangLanguageService service = provider2.getService();
                        if (service == null) continue;
                        service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    }
                }
            }, (Disposable)project2);
        });
        if (ApplicationManager.getApplication().isUnitTestMode() && !initFuture.isNull()) {
            try {
                ((CompletableFuture)initFuture.get()).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.warn("Initialization of language services was interrupted or caused an exception", (Throwable)ex);
            }
            catch (TimeoutException ex) {
                LOG.warn("Initialization of language services takes more than 5 seconds");
            }
        }
    }

    @NotNull
    private static CompletableFuture<?> initLanguageServices(@NotNull ClangLanguageServiceProvider[] providers, @NotNull Project project2) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (ClangLanguageServiceProvider provider2 : providers) {
            CompletionStage startFuture = provider2.start().exceptionally(ex -> {
                LOG.warn(ex);
                return null;
            });
            futures.add(startFuture);
            ((CompletableFuture)startFuture).thenAccept(service -> {
                if (service != null) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
                        if (project2.isDisposed()) {
                            return;
                        }
                        if (!service.isActive()) {
                            return;
                        }
                        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                            VirtualFile vFile;
                            Project editorProject = editor.getProject();
                            if (editorProject != project2 || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
                            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
                        }
                    }));
                }
            });
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static void stopLanguageServices(@NotNull ClangLanguageServiceProvider[] providers) {
        for (ClangLanguageServiceProvider provider2 : providers) {
            provider2.stop();
        }
    }

    private static void configureDefaultAnnotators(@NotNull Project project2) {
        boolean legacy = !ClangUtils.isClangdOn(project2) || !ClangUtils.isClangdShowErrors(project2);
        project2.putUserData(OCAnnotator.CLANGD_ANNOTATOR_ENABLER, (Object)new OCConstantAnnotatorEnabler(legacy));
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider[] myProviders;

        MyClangdSettingsListener(@NotNull Project project2, @NotNull ClangLanguageServiceProvider[] providers) {
            this.myProject = project2;
            this.myProviders = providers;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            this.configureLanguageServices();
            ClangLanguageServiceStartupActivity.configureDefaultAnnotators(this.myProject);
        }

        @Override
        public void onClangdShowErrorsChanged(boolean value) {
            ClangLanguageServiceStartupActivity.configureDefaultAnnotators(this.myProject);
        }

        private void configureLanguageServices() {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(this.myProviders, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageServices(this.myProviders);
            }
        }
    }
}

