/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdASTPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelKt;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "output", "Ljavax/swing/JTextPane;", "append", "", "tp", "msg", "", "c", "Ljava/awt/Color;", "showAST", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorOffset", "", "ast", "ASTViewSynchronizer", "Companion", "intellij.c"})
public final class ClangdASTPanel
extends ClangdPanelBase {
    private final JTextPane output;
    private final Project project;
    private static final Pattern COLORED_TEXT_PATTERN;
    public static final Companion Companion;

    private final void showAST(Editor editor, int editorOffset) {
        PsiFile psiFile;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(editor.getDocument());
        VirtualFile virtualFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(this.project);
        int offset = editorOffset;
        if (virtualFile != null) {
            PsiElement element;
            for (element = psiFile.findElementAt(offset); element != null && !OCElementUtil.isElementSignificant(element); element = element.getParent()) {
            }
            if (element == null || element instanceof OCFile) {
                offset = -1;
            }
            CompletableFuture<String> astFuture = service.dumpAST(virtualFile, offset);
            try {
                String ast = astFuture.get(5000L, TimeUnit.MILLISECONDS);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, ast){
                    final /* synthetic */ ClangdASTPanel this$0;
                    final /* synthetic */ String $ast;

                    public final void run() {
                        ClangdASTPanel.access$showAST(this.this$0, this.$ast);
                    }
                    {
                        this.this$0 = clangdASTPanel;
                        this.$ast = string;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void showAST(String ast) {
        if (ast == null) {
            this.output.setText("");
            this.append(this.output, "AST is unavailable at the moment.", Color.RED);
        } else if (ast.length() >= ClangdASTPanelKt.access$getMAX_AST_LENGTH$p()) {
            this.output.setText("");
            this.append(this.output, "AST is too long...", Color.RED);
        } else {
            List textWithColors = ClangdASTPanel.Companion.processColorsInAST(ast);
            this.output.setText("");
            for (Pair coloredPart : textWithColors) {
                this.append(this.output, (String)coloredPart.getFirst(), (Color)coloredPart.getSecond());
            }
        }
    }

    private final void append(JTextPane tp, String msg, Color c) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet attrSet = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.FontFamily, "Lucida Console");
        attrSet = sc.addAttribute(attrSet, StyleConstants.Alignment, 3);
        if (c != null) {
            attrSet = sc.addAttribute(attrSet, StyleConstants.Foreground, c);
        }
        int len = tp.getDocument().getLength();
        tp.setCaretPosition(len);
        tp.setCharacterAttributes(attrSet, false);
        tp.replaceSelection(msg);
    }

    public ClangdASTPanel(@NotNull Project project2) {
        this.project = project2;
        this.output = new JTextPane(new DefaultStyledDocument());
        this.add((Component)new JBScrollPane((Component)this.output));
        this.output.setBackground(Color.DARK_GRAY);
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        ASTViewSynchronizer viewSynchronizer = new ASTViewSynchronizer(this, this.project);
        eventMulticaster.addCaretListener((CaretListener)viewSynchronizer, (Disposable)this);
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener((FocusChangeListener)viewSynchronizer, (Disposable)this);
        }
    }

    static {
        Companion = new Companion(null);
        COLORED_TEXT_PATTERN = Pattern.compile("<color name=([\\w]+)>(.*?)</color>");
    }

    public static final /* synthetic */ void access$showAST(ClangdASTPanel $this, Editor editor, int editorOffset) {
        $this.showAST(editor, editorOffset);
    }

    public static final /* synthetic */ void access$showAST(ClangdASTPanel $this, String ast) {
        $this.showAST(ast);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0015H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "panel", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;Lcom/intellij/openapi/project/Project;)V", "counter", "", "getCounter", "()J", "setCounter", "(J)V", "curClangFileVersion", "", "getCurClangFileVersion", "()I", "setCurClangFileVersion", "(I)V", "curEditor", "Lcom/intellij/openapi/editor/Editor;", "getCurEditor", "()Lcom/intellij/openapi/editor/Editor;", "setCurEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "curLine", "getCurLine", "setCurLine", "focusedEditor", "getFocusedEditor", "setFocusedEditor", "getPanel", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getUpdateQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "setUpdateQueue", "(Lcom/intellij/util/ui/update/MergingUpdateQueue;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "focusGained", "editor", "focusLost", "refreshIfNeed", "ASTViewUpdate", "intellij.c"})
    private static final class ASTViewSynchronizer
    implements CaretListener,
    FocusChangeListener {
        @NotNull
        private MergingUpdateQueue updateQueue;
        @Nullable
        private Editor curEditor;
        private int curLine;
        private int curClangFileVersion;
        private long counter;
        @Nullable
        private Editor focusedEditor;
        @NotNull
        private final ClangdASTPanel panel;
        @NotNull
        private final Project project;

        @NotNull
        public final MergingUpdateQueue getUpdateQueue() {
            return this.updateQueue;
        }

        public final void setUpdateQueue(@NotNull MergingUpdateQueue mergingUpdateQueue) {
            this.updateQueue = mergingUpdateQueue;
        }

        @Nullable
        public final Editor getCurEditor() {
            return this.curEditor;
        }

        public final void setCurEditor(@Nullable Editor editor) {
            this.curEditor = editor;
        }

        public final int getCurLine() {
            return this.curLine;
        }

        public final void setCurLine(int n) {
            this.curLine = n;
        }

        public final int getCurClangFileVersion() {
            return this.curClangFileVersion;
        }

        public final void setCurClangFileVersion(int n) {
            this.curClangFileVersion = n;
        }

        public final long getCounter() {
            return this.counter;
        }

        public final void setCounter(long l) {
            this.counter = l;
        }

        @Nullable
        public final Editor getFocusedEditor() {
            return this.focusedEditor;
        }

        public final void setFocusedEditor(@Nullable Editor editor) {
            this.focusedEditor = editor;
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            if (ClangdPanelKt.isPanelActive(this.project, "AST")) {
                this.refreshIfNeed(event.getEditor());
            }
        }

        public void focusGained(@NotNull Editor editor) {
            if (ClangdPanelKt.isPanelActive(this.project, "AST")) {
                this.refreshIfNeed(editor);
            }
        }

        public void focusLost(@NotNull Editor editor) {
        }

        private final void refreshIfNeed(Editor editor) {
            VirtualFile virtualFile;
            int offset = editor.getCaretModel().getOffset();
            int line = editor.offsetToLogicalPosition((int)offset).line;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(editor.getDocument());
            if (psiFile instanceof OCFile && (virtualFile = ((OCFile)psiFile).getVirtualFile()) != null) {
                ASTViewSynchronizer aSTViewSynchronizer = this;
                ++aSTViewSynchronizer.counter;
                long newCounter = aSTViewSynchronizer.counter;
                this.updateQueue.queue((Update)new ASTViewUpdate(virtualFile, editor, newCounter, offset, line));
            }
        }

        @NotNull
        public final ClangdASTPanel getPanel() {
            return this.panel;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ASTViewSynchronizer(@NotNull ClangdASTPanel panel, @NotNull Project project2) {
            this.panel = panel;
            this.project = project2;
            this.updateQueue = new MergingUpdateQueue("Clang AST View queue", 600, true, null, (Disposable)this.panel, null, false);
            this.curLine = -1;
            this.curClangFileVersion = -1;
            this.counter = -1L;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer$ASTViewUpdate;", "Lcom/intellij/util/ui/update/Update;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "myCounter", "", "newOffset", "", "newLine", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$ASTViewSynchronizer;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;JII)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getMyCounter", "()J", "getNewLine", "()I", "getNewOffset", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "canEat", "", "update", "run", "", "intellij.c"})
        public final class ASTViewUpdate
        extends Update {
            @NotNull
            private final VirtualFile virtualFile;
            @NotNull
            private final Editor editor;
            private final long myCounter;
            private final int newOffset;
            private final int newLine;

            public void run() {
                ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(ASTViewSynchronizer.this.getProject());
                ClangFile clangFile = service.getLastClangFile(this.virtualFile);
                if (clangFile == null) {
                    return;
                }
                if (Intrinsics.areEqual((Object)ASTViewSynchronizer.this.getCurEditor(), (Object)this.editor) && ASTViewSynchronizer.this.getCurLine() == this.newLine && ASTViewSynchronizer.this.getCurClangFileVersion() == clangFile.getVersion()) {
                    return;
                }
                ASTViewSynchronizer.this.setCurEditor(this.editor);
                ASTViewSynchronizer.this.setCurLine(this.newLine);
                ASTViewSynchronizer.this.setCurClangFileVersion(clangFile.getVersion());
                ApplicationManager.getApplication().runReadAction(new Runnable(this){
                    final /* synthetic */ ASTViewUpdate this$0;

                    public final void run() {
                        ClangdASTPanel.access$showAST(this.this$0.ASTViewSynchronizer.this.getPanel(), this.this$0.getEditor(), this.this$0.getNewOffset());
                    }
                    {
                        this.this$0 = aSTViewUpdate;
                    }
                });
            }

            public boolean canEat(@Nullable Update update) {
                return update != null && ((ASTViewUpdate)update).myCounter < this.myCounter;
            }

            @NotNull
            public final VirtualFile getVirtualFile() {
                return this.virtualFile;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final long getMyCounter() {
                return this.myCounter;
            }

            public final int getNewOffset() {
                return this.newOffset;
            }

            public final int getNewLine() {
                return this.newLine;
            }

            public ASTViewUpdate(@NotNull VirtualFile virtualFile, Editor editor, long myCounter, int newOffset, int newLine) {
                super((Object)("AST view update: " + myCounter));
                this.virtualFile = virtualFile;
                this.editor = editor;
                this.myCounter = myCounter;
                this.newOffset = newOffset;
                this.newLine = newLine;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b0\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdASTPanel$Companion;", "", "()V", "COLORED_TEXT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "processColorsInAST", "", "Lkotlin/Pair;", "", "Ljava/awt/Color;", "ast", "toColor", "name", "intellij.c"})
    public static final class Companion {
        private final List<Pair<String, Color>> processColorsInAST(String ast) {
            String string;
            ArrayList<Pair> arrayList;
            Matcher matcher = COLORED_TEXT_PATTERN.matcher(ast);
            ArrayList<Pair> result = new ArrayList<Pair>();
            int lastMatchEnd = 0;
            while (matcher.find()) {
                int curMatchStart = matcher.start();
                if (lastMatchEnd < curMatchStart) {
                    String string2 = ast;
                    arrayList = result;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(lastMatchEnd, curMatchStart), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Object var12_11 = null;
                    String string4 = string;
                    arrayList.add(new Pair((Object)string4, var12_11));
                }
                String name2 = matcher.group(1);
                String text = matcher.group(2);
                result.add(new Pair((Object)text, (Object)this.toColor(name2)));
                lastMatchEnd = matcher.end();
            }
            if (lastMatchEnd != ast.length()) {
                String string5 = ast;
                arrayList = result;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(lastMatchEnd);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string = string7;
                Object var14_13 = null;
                String string8 = string;
                arrayList.add(new Pair((Object)string8, var14_13));
            }
            return result;
        }

        private final Color toColor(String name2) {
            switch (name2) {
                case "BLACK": {
                    return Color.BLACK;
                }
                case "RED": {
                    return Color.RED;
                }
                case "GREEN": {
                    return Color.GREEN;
                }
                case "YELLOW": {
                    return Color.YELLOW;
                }
                case "BLUE": {
                    return Color.BLUE;
                }
                case "MAGENTA": {
                    return Color.MAGENTA;
                }
                case "CYAN": {
                    return Color.CYAN;
                }
                case "WHITE": {
                    return Color.WHITE;
                }
            }
            return Color.BLACK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

