/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColRange;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangDaemonFormatProvider
implements ClangFormatChangeSettingsProvider {
    private static final String ourErrorPrefix = "# Error: '";
    private static final String ourErrorSuffix = "'";
    private static final String ourClangFormatConfigureSourcePrefix = "# ClangFormatConfigureSource: ";
    private static boolean ourDebugRangesForFormat = false;
    private static final String PARSE_START = "Error reading";
    private static final String WRONG_CFG_START = "Configuration file(s) do(es) not support";
    private static final Pattern CLANG_FORMAT_CONFIGURE_SOURCE = Pattern.compile("^#\\s*ClangFormatConfigureSource:\\s*'([^']*)'\\s*\n.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String findClangFormatContent(@NotNull Project project2, @NotNull VirtualFile vfCodeFile) {
        ClangLanguageService service;
        CompletableFuture<ClangLanguageService> serviceFuture = ClangLanguageServiceProvider.getLanguageServiceFuture(project2);
        if (serviceFuture == null) {
            return "# Error: no `clangd` server future.";
        }
        while (true) {
            try {
                service = serviceFuture.get();
            }
            catch (ExecutionException ignored) {
                return "# Error: unpredictable respond from `clangd` server future.";
            }
            catch (InterruptedException ignored) {
                continue;
            }
            break;
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId("cf_" + vfCodeFile.getPath());
        try {
            service.notifyDocumentOpened(vfCodeFile, openRequestId);
            CompletableFuture<String> future = service.requestClangFormatConfiguration(vfCodeFile);
            while (true) {
                try {
                    String clangFormatContent = future.get();
                    if (clangFormatContent == null || clangFormatContent.isEmpty()) {
                        String string = "# Error: crash or error respond from context request future.";
                        return string;
                    }
                    String string = clangFormatContent;
                    return string;
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                catch (Exception e) {
                    String clangFormatFileWithErrorURL;
                    OpenFileDescriptor fileDescriptor;
                    String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(message);
                    if (!pe.getClangFormatURLs().isEmpty() && (fileDescriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project2, clangFormatFileWithErrorURL = pe.getClangFormatURLs().get(0))) != null) {
                        String string = "# ClangFormatConfigureSource: 'clang-format-file://" + fileDescriptor.getFile().getCanonicalPath() + "'\n" + ourErrorPrefix + message + ourErrorSuffix + "\n";
                        return string;
                    }
                }
                break;
            }
        }
        finally {
            service.notifyDocumentClosed(vfCodeFile, openRequestId);
        }
        return "# Error: unpredictable respond from context request future.";
    }

    @Override
    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings settings, @NotNull Map<String, Object> formattingOptionValue) {
        boolean isModified = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = ClangFormatFileUtils.getOverriddenIndentOptions(settings);
        OCCodeStyleSettings oc = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings common = settings.getCommonSettings(settings.getPsiFile().getLanguage());
        boolean customBraceStyle = true;
        oc.BLOCK_BRACE_PLACEMENT = 1;
        isModified |= oc.BLOCK_BRACE_PLACEMENT != 1;
        for (Map.Entry<String, Object> entry : formattingOptionValue.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if ("AfterClass".equals(key)) {
                    int CLASS_BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= CLASS_BRACE_STYLE != common.CLASS_BRACE_STYLE;
                    common.CLASS_BRACE_STYLE = CLASS_BRACE_STYLE;
                    continue;
                }
                if ("AfterFunction".equals(key)) {
                    int FUNCTION_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= FUNCTION_BRACE_PLACEMENT != oc.FUNCTION_BRACE_PLACEMENT;
                    oc.FUNCTION_BRACE_PLACEMENT = FUNCTION_BRACE_PLACEMENT;
                    continue;
                }
                if ("AfterControlStatement".equals(key)) {
                    int BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), ClangDaemonFormatProvider._boolean(formattingOptionValue.get("IndentBraces")));
                    isModified |= BRACE_STYLE != common.BRACE_STYLE;
                    common.BRACE_STYLE = BRACE_STYLE;
                    continue;
                }
                if ("AfterNamespace".equals(key)) {
                    int NAMESPACE_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= NAMESPACE_BRACE_PLACEMENT != oc.NAMESPACE_BRACE_PLACEMENT;
                    oc.NAMESPACE_BRACE_PLACEMENT = NAMESPACE_BRACE_PLACEMENT;
                    continue;
                }
                if ("BeforeElse".equals(key)) {
                    boolean vBeforeElse = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeElse != common.ELSE_ON_NEW_LINE;
                    common.ELSE_ON_NEW_LINE = vBeforeElse;
                    continue;
                }
                if ("BeforeCatch".equals(key)) {
                    boolean vBeforeCatch = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeCatch != common.CATCH_ON_NEW_LINE;
                    common.CATCH_ON_NEW_LINE = vBeforeCatch;
                    continue;
                }
                if ("ColumnLimit".equals(key)) {
                    int vColumnLimit = ClangDaemonFormatProvider._int(value);
                    boolean vKeepLineBreaks = false;
                    if (vColumnLimit == 0) {
                        vColumnLimit = 1000;
                        vKeepLineBreaks = true;
                    }
                    isModified |= vColumnLimit != common.RIGHT_MARGIN || vKeepLineBreaks != common.KEEP_LINE_BREAKS;
                    common.RIGHT_MARGIN = vColumnLimit;
                    common.KEEP_LINE_BREAKS = vKeepLineBreaks;
                    continue;
                }
                if ("MaxEmptyLinesToKeep".equals(key)) {
                    int vMaxEmptyLinesToKeep = ClangDaemonFormatProvider._int(value);
                    isModified |= vMaxEmptyLinesToKeep != common.KEEP_BLANK_LINES_IN_CODE;
                    common.KEEP_BLANK_LINES_IN_CODE = vMaxEmptyLinesToKeep;
                    continue;
                }
                if ("IndentWidth".equals(key)) {
                    int vIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vIndentWidth != indentOptions.INDENT_SIZE || vIndentWidth != oc.INDENT_CLASS_MEMBERS || vIndentWidth != oc.INDENT_C_STRUCT_MEMBERS || vIndentWidth != oc.INDENT_INTERFACE_MEMBERS || vIndentWidth != oc.INDENT_IMPLEMENTATION_MEMBERS || !oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
                    oc.INDENT_INTERFACE_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS = vIndentWidth;
                    oc.INDENT_C_STRUCT_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_CLASS_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    indentOptions.INDENT_SIZE = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = true;
                    continue;
                }
                if ("ObjCBlockIndentWidth".equals(key)) {
                    int vObjCBlockIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vObjCBlockIndentWidth != oc.INDENT_INSIDE_CODE_BLOCK;
                    oc.INDENT_INSIDE_CODE_BLOCK = vObjCBlockIndentWidth;
                    continue;
                }
                if ("ContinuationIndentWidth".equals(key)) {
                    int vContinuationIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vContinuationIndentWidth != indentOptions.CONTINUATION_INDENT_SIZE;
                    indentOptions.CONTINUATION_INDENT_SIZE = vContinuationIndentWidth;
                    continue;
                }
                if ("TabWidth".equals(key)) {
                    int vTabWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vTabWidth != indentOptions.TAB_SIZE;
                    indentOptions.TAB_SIZE = vTabWidth;
                    continue;
                }
                if ("UseTab".equals(key)) {
                    Boolean vUseTab = null;
                    if ("Never".equals(value)) {
                        vUseTab = Boolean.FALSE;
                    }
                    if ("Always".equals(value)) {
                        vUseTab = Boolean.TRUE;
                    }
                    if (vUseTab == null) continue;
                    isModified |= !vUseTab.equals(indentOptions.USE_TAB_CHARACTER);
                    indentOptions.USE_TAB_CHARACTER = vUseTab;
                    continue;
                }
                if ("AccessModifierOffset".equals(key)) {
                    int vAccessModifierOffset = ClangDaemonFormatProvider._int(value) + ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                    isModified |= vAccessModifierOffset != oc.INDENT_VISIBILITY_KEYWORDS;
                    oc.INDENT_VISIBILITY_KEYWORDS = vAccessModifierOffset;
                    continue;
                }
                if ("IndentCaseLabels".equals(key)) {
                    boolean vIndentCaseLabels = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vIndentCaseLabels != common.INDENT_CASE_FROM_SWITCH;
                    common.INDENT_CASE_FROM_SWITCH = vIndentCaseLabels;
                    continue;
                }
                if (!"NamespaceIndentation".equals(key)) continue;
                String vNamespaceIndentation = ClangDaemonFormatProvider._str(value);
                int INDENT_NAMESPACE_MEMBERS = oc.INDENT_NAMESPACE_MEMBERS;
                if ("None".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("Inner".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("All".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                }
                isModified |= INDENT_NAMESPACE_MEMBERS != oc.INDENT_NAMESPACE_MEMBERS;
                oc.INDENT_NAMESPACE_MEMBERS = INDENT_NAMESPACE_MEMBERS;
            }
            catch (Throwable t) {
                OCLog.LOG.warn(t);
            }
        }
        return isModified;
    }

    @Contract(pure=true)
    private static int getBraceStyle(boolean wrapAfter, boolean indentBrace) {
        return !wrapAfter ? 1 : (indentBrace ? 4 : 2);
    }

    private static String _str(@NotNull Object value) {
        return value.toString();
    }

    private static int _int(@NotNull Object value) {
        return Integer.parseInt((String)value);
    }

    private static boolean _boolean(@NotNull Object value) {
        return Boolean.parseBoolean((String)value);
    }

    @Override
    public boolean isApplicable(@NotNull Project project2, @NotNull FileType fileType) {
        return fileType instanceof OCFileType;
    }

    @Override
    public boolean isActive(@NotNull Project project2, @NotNull FileType fileType) {
        return this.isApplicable(project2, fileType) && ClangUtils.isClangdOn(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure")
    public TextRange format(@NotNull PsiFile source, @NotNull TextRange range, @Nullable String style, boolean canChangeWhiteSpacesOnly) {
        String errorParsingMessageFromStyle;
        Project project2 = source.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document2 != null);
        String origText = document2.getText();
        if (ourDebugRangesForFormat) {
            ClangDaemonFormatProvider.outDebugString("Format range: " + source.getName() + ClangDaemonFormatProvider.selectedRangeInContext(origText, range));
        }
        if ((errorParsingMessageFromStyle = ClangDaemonFormatProvider.getErrorParsingMessageFromStyle(style)) != null) {
            ClangDaemonFormatProvider.reportClangFormatError(errorParsingMessageFromStyle, project2, MessageType.ERROR);
            return range;
        }
        try {
            CompletableFuture<List<ClangLineColReplace>> future = ClangLanguageServiceProvider.getLanguageService(project2).formatRange(virtualFile, range, style);
            List<ClangLineColReplace> replaces = future.get();
            if (replaces == null || replaces.isEmpty()) {
                return source.getTextRange();
            }
            Ref start = Ref.create((Object)Integer.MAX_VALUE);
            Ref end = Ref.create((Object)Integer.MIN_VALUE);
            Ref delta = Ref.create((Object)0);
            boolean wasInBulkUpdate = false;
            if (document2 instanceof DocumentEx && !(wasInBulkUpdate = ((DocumentEx)document2).isInBulkUpdate())) {
                ((DocumentEx)document2).setInBulkUpdate(true);
            }
            try {
                replaces.stream().sorted(Comparator.comparingInt(o -> -o.getRange().getStart().getOffset(document2))).map(replace -> {
                    ClangLineColRange replaceRange = replace.getRange();
                    TextRange mappedRange = TextRange.create((int)replaceRange.getStart().getOffset(document2), (int)replaceRange.getEnd().getOffset(document2));
                    if (ourDebugRangesForFormat) {
                        ClangDaemonFormatProvider.outDebugString("map" + ClangDaemonFormatProvider.selectedRangeInContext(origText, mappedRange) + " to >>>" + replace.getReplace() + "<<<");
                    }
                    return Pair.create((Object)replace.getReplace(), (Object)mappedRange);
                }).collect(Collectors.toList()).forEach(replaceRange -> {
                    if (range.intersects((TextRange)replaceRange.second) && ((TextRange)replaceRange.second).getStartOffset() != range.getEndOffset() && (!canChangeWhiteSpacesOnly || StringUtil.isEmptyOrSpaces((String)((String)replaceRange.first)))) {
                        String replaceText = (String)replaceRange.first;
                        int startOffset = ((TextRange)replaceRange.second).getStartOffset();
                        int endOffset = ((TextRange)replaceRange.second).getEndOffset();
                        start.set((Object)Math.min((Integer)start.get(), startOffset));
                        end.set((Object)Math.max((Integer)end.get(), endOffset));
                        int oldLength = endOffset - startOffset;
                        int newLength = replaceText.length();
                        int diff2 = newLength - oldLength;
                        delta.set((Object)((Integer)delta.get() + diff2));
                        if (ourDebugRangesForFormat) {
                            ClangDaemonFormatProvider.outDebugString("Replace:" + ClangDaemonFormatProvider.selectedRangeInContext(origText, (TextRange)replaceRange.second) + "\n to >>>" + replaceText + "<<<");
                        }
                        document2.replaceString(startOffset, endOffset, (CharSequence)replaceText);
                    }
                });
            }
            finally {
                if (document2 instanceof DocumentEx && !wasInBulkUpdate) {
                    ((DocumentEx)document2).setInBulkUpdate(false);
                }
            }
            if ((Integer)start.get() != Integer.MAX_VALUE && (Integer)start.get() != Integer.MIN_VALUE) {
                return ClangDaemonFormatProvider.psiAndDocumentAreSyncronized(psiDocumentManager, document2) ? TextRange.create((int)((Integer)start.get()), (int)((Integer)end.get() + (Integer)delta.get())) : null;
            }
        }
        catch (Exception e) {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
            if (application.isInternal()) {
                OCLog.LOG.warn("Problem while ClangFormat procedure", (Throwable)e);
            }
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            ClangDaemonFormatProvider.reportClangFormatError(message, project2, MessageType.ERROR);
        }
        return range;
    }

    @Contract(value="null -> null")
    public static String getErrorParsingMessageFromStyle(@Nullable String style) {
        String lineWithError;
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLines((String)style);
        if (lines.length == 2 && lines[0].startsWith(ourClangFormatConfigureSourcePrefix) && (lineWithError = lines[1]).length() >= ourErrorPrefix.length() + ourErrorSuffix.length() && lineWithError.startsWith(ourErrorPrefix) && lineWithError.endsWith(ourErrorSuffix)) {
            return lineWithError.substring(ourErrorPrefix.length(), lineWithError.length() - ourErrorSuffix.length());
        }
        return null;
    }

    private static boolean psiAndDocumentAreSyncronized(@NotNull PsiDocumentManager psiDocumentManager, @NotNull Document document2) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            psiDocumentManager.commitDocument(document2);
            return true;
        }
        return psiDocumentManager.isCommitted(document2);
    }

    private static void outDebugString(@NotNull String message) {
        assert (ourDebugRangesForFormat);
        System.out.println("=============================== " + message);
    }

    @NotNull
    private static String selectedRangeInContext(@NotNull String text, @NotNull TextRange range) {
        return "\n'" + text.substring(0, range.getStartOffset()) + ">>>" + text.substring(range.getStartOffset(), range.getEndOffset()) + "<<<" + text.substring(range.getEndOffset()) + ourErrorSuffix;
    }

    public static void reportClangFormatError(@NotNull String message, final @NotNull Project project2, MessageType messageType) {
        ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(message);
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(pe.getFilteredMessage(), messageType, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    OpenFileDescriptor descriptor2;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (descriptor2 = ClangDaemonFormatProvider.createOpenFileDescriptor(project2, e.getDescription())) != null) {
                        new OpenFileHyperlinkInfo(descriptor2).navigate(project2);
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register((Disposable)project2, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project2);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    public RelativePoint recalculateLocation(Balloon object) {
                        Component c = this.getComponent();
                        int y = c.getHeight() - 45;
                        return new RelativePoint(c, new Point(c.getWidth() - 150, y));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project2, @Nullable String url) {
        VirtualFile vtClangFormat;
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(58);
        int col = 0;
        int line = 0;
        if (pos > 1) {
            String num1 = url.substring(pos + 1);
            if ((pos = (url = url.substring(0, pos)).lastIndexOf(58)) > 1) {
                String num2 = url.substring(pos + 1);
                url = url.substring(0, pos);
                line = ClangDaemonFormatProvider._int(num2);
                col = ClangDaemonFormatProvider._int(num1);
            } else {
                line = ClangDaemonFormatProvider._int(num1);
            }
        }
        if ((vtClangFormat = VfsUtil.findFile((Path)Paths.get(url, new String[0]), (boolean)true)) != null) {
            return new OpenFileDescriptor(project2, vtClangFormat, line - 1, col);
        }
        return null;
    }

    @NotNull
    public static ProcessedMessage processMessage(@NotNull String message) {
        int pos;
        if (message.startsWith(PARSE_START)) {
            int pos2 = message.lastIndexOf(":");
            String messageEnd = message.substring(pos2);
            String fileName2 = message.substring(PARSE_START.length(), pos2).trim();
            return ProcessedMessage.createProcessedMessage(Collections.singletonList(fileName2), "<html><body>Error reading <a href='" + fileName2 + "'>" + fileName2 + "</a>" + messageEnd + "</body></html>");
        }
        if (message.startsWith(WRONG_CFG_START) && (pos = message.indexOf(":")) > 0) {
            StringBuffer sb = new StringBuffer(message.substring(0, pos + 1));
            List paths = StringUtil.split((String)message.substring(pos + 1), (String)",");
            boolean[] first = new boolean[]{true};
            List clangFormatURLs = ContainerUtil.newSmartList();
            paths.forEach(fileName -> {
                String trim = fileName.trim();
                clangFormatURLs.add(trim);
                if (first[0]) {
                    first[0] = false;
                    sb.append(" ");
                } else {
                    sb.append(", ");
                }
                sb.append("<a href='").append(trim).append("'>").append(trim).append("</a>");
            });
            return ProcessedMessage.createProcessedMessage(clangFormatURLs, "<html><body>" + sb.toString() + "</body></html>");
        }
        return ProcessedMessage.createProcessedMessage(ContainerUtil.emptyList(), message);
    }

    private static int _int(String num2) {
        try {
            return Integer.parseInt(num2);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    @Override
    @Nullable
    public VirtualFile extractClangFormatFile(@NotNull String clangFormatExtendedContext) {
        String formatSource = ClangDaemonFormatProvider.extractClangFormatSource(clangFormatExtendedContext);
        return formatSource == null ? null : ClangFormatFileUtils.getClangFormatFile(formatSource);
    }

    @Nullable
    public static String extractClangFormatSource(@NotNull String clangFormatExtendedContext) {
        Matcher matcher = CLANG_FORMAT_CONFIGURE_SOURCE.matcher(clangFormatExtendedContext);
        return matcher.find() ? matcher.group(1) : null;
    }

    public static class ProcessedMessage {
        private final List<String> myClangFormatURLs;
        private final String myFilteredMessage;

        private ProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull String message) {
            this.myClangFormatURLs = clangFormatURLs;
            this.myFilteredMessage = message;
        }

        public List<String> getClangFormatURLs() {
            return this.myClangFormatURLs;
        }

        public String getFilteredMessage() {
            return this.myFilteredMessage;
        }

        @NotNull
        @Contract(value="_, _ -> new")
        public static ProcessedMessage createProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull String message) {
            return new ProcessedMessage(clangFormatURLs, message);
        }
    }
}

