/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangFormatChangeSettingsProvider {
    public static final ExtensionPointName<ClangFormatChangeSettingsProvider> CLANG_FORMAT_PROVIDER = ExtensionPointName.create((String)"com.intellij.clangFormatProvider");
    public static final String CFC_NO_LANGUAGE_SERVICE_FUTURE = "# Error: no `clangd` server future.";
    public static final String CFC_WRONG_SERVICE_FUTURE_RESPOND = "# Error: unpredictable respond from `clangd` server future.";
    public static final String CFC_NO_CONTEXT_FUTURE = "# Error: crash or error respond from context request future.";
    public static final String CFC_WRONG_CONTEXT_FUTURE_RESPOND = "# Error: unpredictable respond from context request future.";
    public static final String CFK_BreakBeforeBraces = "BreakBeforeBraces";
    public static final String CFK_AfterClass = "AfterClass";
    public static final String CFK_AfterControlStatement = "AfterControlStatement";
    public static final String CFK_AfterEnum = "AfterEnum";
    public static final String CFK_AfterFunction = "AfterFunction";
    public static final String CFK_AfterNamespace = "AfterNamespace";
    public static final String CFK_AfterObjCDeclaration = "AfterObjCDeclaration";
    public static final String CFK_AfterStruct = "AfterStruct";
    public static final String CFK_AfterUnion = "AfterUnion";
    public static final String CFK_AfterExternBlock = "AfterExternBlock";
    public static final String CFK_BeforeCatch = "BeforeCatch";
    public static final String CFK_BeforeElse = "BeforeElse";
    public static final String CFK_IndentBraces = "IndentBraces";
    public static final String CFK_SplitEmptyFunction = "SplitEmptyFunction";
    public static final String CFK_SplitEmptyRecord = "SplitEmptyRecord";
    public static final String CFK_SplitEmptyNamespace = "SplitEmptyNamespace";
    public static final String CFK_MaxEmptyLinesToKeep = "MaxEmptyLinesToKeep";
    public static final String CFK_KEEP_EMPTY_LINES_AT_THE_START_OF_BLOCKS = "KeepEmptyLinesAtTheStartOfBlocks";
    public static final String CFK_ColumnLimit = "ColumnLimit";
    public static final String CFK_IndentWidth = "IndentWidth";
    public static final String CFK_ObjCBlockIndentWidth = "ObjCBlockIndentWidth";
    public static final String CFK_ContinuationIndentWidth = "ContinuationIndentWidth";
    public static final String CFK_TabWidth = "TabWidth";
    public static final String CFK_UseTab = "UseTab";
    public static final String CFK_AccessModifierOffset = "AccessModifierOffset";
    public static final String CFK_IndentCaseLabels = "IndentCaseLabels";
    public static final String CFK_NamespaceIndentation = "NamespaceIndentation";
    public static final String CFV_Custom = "Custom";
    public static final String CFV_Never = "Never";
    public static final String CFV_Always = "Always";
    public static final String CFV_None = "None";
    public static final String CFV_Inner = "Inner";
    public static final String CFV_All = "All";

    @Nullable
    public static ClangFormatChangeSettingsProvider findApplicableFormatProvider(@NotNull Project project2, @NotNull FileType language) {
        for (ClangFormatChangeSettingsProvider extension : CLANG_FORMAT_PROVIDER.getExtensionList()) {
            if (!extension.isApplicable(project2, language)) continue;
            return extension;
        }
        return null;
    }

    @NotNull
    public String findClangFormatContent(Project var1, @NotNull VirtualFile var2);

    public VirtualFile extractClangFormatFile(@NotNull String var1);

    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings var1, @NotNull Map<String, Object> var2);

    public boolean isApplicable(@NotNull Project var1, @NotNull FileType var2);

    public boolean isActive(@NotNull Project var1, @NotNull FileType var2);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, @Nullable String var3, boolean var4);
}

