/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatLog;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFormatFileUtils {
    public static final String CLANG_FORMAT_ID = "ClangFormat";
    public static final String CLANG_FORMAT_FILE_PREFIX = "clang-format-file://";
    public static final String CLANG_FORMAT_SETTINGS_ID = "clangFormatSettings";
    public static final String CLANG_FORMAT1 = ".clang-format";
    public static final String CLANG_FORMAT2 = "_clang-format";

    @Contract(pure=true)
    public static boolean isFileBasedClangFormatURL(@NotNull String url) {
        return url.startsWith(CLANG_FORMAT_FILE_PREFIX);
    }

    @Nullable
    public static VirtualFile getClangFormatFile(@NotNull String clangFormatURL) {
        String path = ClangFormatFileUtils.getClangFormatPathFromURL(clangFormatURL);
        try {
            return path == null ? null : VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)true);
        }
        catch (Throwable e) {
            ClangFormatLog.LOG.warn(e);
            return null;
        }
    }

    public static CommonCodeStyleSettings.IndentOptions getOverriddenIndentOptions(@NotNull TransientCodeStyleSettings transientSettings) {
        PsiFile file = transientSettings.getPsiFile();
        ClangFormatFileUtils.saveAllClangFormatDocumentsInTransactionIfNeed(file.getProject());
        return transientSettings.getLanguageIndentOptions(file.getLanguage());
    }

    public static void saveAllClangFormatDocuments() {
        Document[] unsavedDocuments;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document2 : unsavedDocuments = fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file = fileDocumentManager.getFile(document2);
            if (file == null || !ClangFormatFileUtils.isClangFormatConfig(file)) continue;
            fileDocumentManager.saveDocument(document2);
        }
    }

    public static void saveAllClangFormatDocumentsInTransactionIfNeed(@NotNull Project project2) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            return;
        }
        if (application.isWriteAccessAllowed()) {
            ClangFormatFileUtils.saveAllClangFormatDocuments();
        } else {
            TransactionGuard.submitTransaction((Disposable)project2, () -> ClangFormatFileUtils.saveAllClangFormatDocuments());
        }
    }

    public static boolean isClangFormatConfig(@NotNull VirtualFile file) {
        return ClangFormatFileUtils.isClangFormatName(file.getName());
    }

    public static boolean isClangFormatName(String name2) {
        return CLANG_FORMAT1.equals(name2) || CLANG_FORMAT2.equals(name2);
    }

    @Nullable
    public static String getClangFormatPathFromURL(@NotNull String clangFormatURL) {
        if (!ClangFormatFileUtils.isFileBasedClangFormatURL(clangFormatURL)) {
            return null;
        }
        return clangFormatURL.substring(CLANG_FORMAT_FILE_PREFIX.length());
    }

    @NotNull
    public static String getClangFormatFileURL(@NotNull VirtualFile clangFormat) {
        return CLANG_FORMAT_FILE_PREFIX + clangFormat.getCanonicalPath();
    }
}

