/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyAnnotationApplier {
    public void applyFail(@NotNull PsiFile file, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        String message = "Unable to execute Clang-Tidy: " + reason;
        Annotation annotation = holder.createAnnotation(severity, file.getTextRange(), message);
        annotation.registerFix((IntentionAction)new OpenClangTidySettingsAction());
        annotation.setFileLevelAnnotation(true);
    }

    public void applySuccess(@NotNull PsiFile file, @NotNull Document document2, @NotNull List<ClangTidyDiagnostic> diagnostics, @NotNull AnnotationHolder holder) {
        if (!(file instanceof OCFile)) {
            return;
        }
        OCFile ocFile = (OCFile)file;
        for (ClangTidyDiagnostic diagnostic : diagnostics) {
            Annotation annotation;
            OCPragma.Mode mode;
            ClangTidyInspectionBase sourceInspection;
            ProgressManager.checkCanceled();
            PsiElement elementToAnnotate = ClangTidyAnnotationApplier.getElementToAnnotate(file, diagnostic.getFileOffset());
            if (elementToAnnotate == null || (sourceInspection = ClangTidyUtil.findInspectionFromClangTidyDiagnostic(diagnostic, file, file.getProject())) == null) continue;
            TextRange rangeToHighlight = ClangTidyAnnotationApplier.getRangeToHighlight(elementToAnnotate);
            String diagnosticMessage = sourceInspection.getMessage(diagnostic.getMessage(), holder.isBatchMode());
            List<ClangTidyReplacement> replacements = diagnostic.getReplacements();
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(((Object)((Object)sourceInspection)).getClass(), (PsiElement)file, HighlightSeverity.WARNING);
            if (highlightSeverity == null || (mode = OCPragmaSuppressionUtils.getDiagnosticMode(ocFile, rangeToHighlight.getStartOffset(), sourceInspection.getSuppressName(diagnosticName))) == OCPragma.Mode.IGNORE || (annotation = holder.createAnnotation(highlightSeverity, rangeToHighlight, diagnosticMessage)) == null) continue;
            if (sourceInspection.getForcedHighlightType() != null) {
                annotation.setHighlightType(sourceInspection.getForcedHighlightType());
            }
            Object fixToRegister = replacements.isEmpty() ? new EmptyIntentionAction(sourceInspection.getDisplayName()) : new ClangTidyIntentionAction(diagnosticMessage, diagnosticName, replacements);
            annotation.registerFix((IntentionAction)new IntentionWrapper((IntentionAction)fixToRegister, file));
            annotation.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
            if (!(holder instanceof OCAnnotator.AnnotationAndQuickFixHolder)) continue;
            ((OCAnnotator.AnnotationAndQuickFixHolder)holder).createQuickFix(annotation, (IntentionAction)fixToRegister);
        }
    }

    @NotNull
    private static ClangTidyProblemGroup createProblemGroup(@NotNull OCFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        return new ClangTidyProblemGroup(file, highlightRange, checkName, inspection.canBeDisabledByClangTidyCheckName(), inspection.getShortName());
    }

    @Nullable
    private static PsiElement getElementToAnnotate(@NotNull PsiFile file, int offset) {
        PsiElement element;
        PsiElement psiElement = element = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild();
        if (element instanceof PsiComment) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant(element)) {
            element = OCElementUtil.getPrevSignificantSibling(element);
        }
        if (element == null) {
            return null;
        }
        if (ClangTidyAnnotationApplier.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class});
        assert (!(context instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context != null ? context : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == OCTokenTypes.LBRACE || elementType == OCTokenTypes.RBRACE) {
            return true;
        }
        if (!OCTokenTypes.KEYWORDS.contains(elementType) || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.EXTERN_KEYWORD, OCTokenTypes.REGISTER_KEYWORD, OCTokenTypes.STATIC_KEYWORD, OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        List<OCDeclarator> declarators;
        PsiElement identifier;
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                return keywordElement.get().getTextRange();
            }
        }
        if (element instanceof OCStructLike && (identifier = ((OCStructLike)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros(identifier);
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && declarators.get(0).getName() != "<unnamed>") {
            element = declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            return OCElementUtil.getRangeWithMacros(identifier);
        }
        return OCElementUtil.getRangeWithMacros(element);
    }
}

