/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangTidyIntentionAction
implements IntentionAction {
    @NotNull
    private final String myMessage;
    @NotNull
    private final String myCheckName;
    @NotNull
    private final List<Replacement> myReplacements;

    public ClangTidyIntentionAction(@NotNull String message, @NotNull String checkName, @NotNull List<ClangTidyReplacement> replacements) {
        this.myMessage = message;
        this.myCheckName = checkName;
        this.myReplacements = ClangTidyIntentionAction.createReplacements(replacements);
    }

    @Nls
    @NotNull
    public String getText() {
        return this.myMessage;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.myCheckName;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        return file instanceof OCFile && !this.myReplacements.isEmpty() && this.myReplacements.stream().allMatch(replacement -> replacement != null && replacement.isValid());
    }

    public void invoke(@NotNull Project project2, Editor intentionStarterEditor, PsiFile intentionStarterFile) throws IncorrectOperationException {
        if (!this.isAvailable(project2, intentionStarterEditor, intentionStarterFile)) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Set<Document> documentsWithReplacements = this.myReplacements.stream().map(replacement -> ((Replacement)replacement).myRangeMarker.getDocument()).collect(Collectors.toSet());
        documentsWithReplacements.forEach(replaceHolderDocument -> {
            PsiFile replaceHolderFileIfOpen = documentManager.getCachedPsiFile(replaceHolderDocument);
            if (replaceHolderFileIfOpen != null) {
                OCChangeUtil.processPostponedFormatIfNeed(replaceHolderFileIfOpen);
            }
        });
        for (Replacement replacement2 : this.myReplacements) {
            RangeMarker rangeMarker = replacement2.myRangeMarker;
            rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)replacement2.myReplacementText);
        }
        documentsWithReplacements.forEach(replaceHolderDocument -> documentManager.commitDocument(replaceHolderDocument));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static List<Replacement> createReplacements(@NotNull List<ClangTidyReplacement> replacements) {
        return ContainerUtil.map(replacements, replacement -> {
            VirtualFile filePath2 = VfsUtil.findFile((Path)Paths.get(replacement.getFilePath(), new String[0]), (boolean)true);
            if (filePath2 == null) {
                return null;
            }
            Document document2 = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(filePath2));
            if (document2 == null) {
                return null;
            }
            int beginOffset = replacement.getBeginOffset();
            int endOffset = replacement.getEndOffset();
            if (!DocumentUtil.isValidOffset((int)beginOffset, (Document)document2) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document2)) {
                return null;
            }
            RangeMarker rangeMarker = document2.createRangeMarker(beginOffset, endOffset);
            String oldText = document2.getText(new TextRange(beginOffset, endOffset));
            return new Replacement(rangeMarker, oldText, replacement.getReplacementText());
        });
    }

    static class Replacement {
        @NotNull
        private final RangeMarker myRangeMarker;
        @NotNull
        private final String myOldText;
        @NotNull
        private final String myReplacementText;

        Replacement(@NotNull RangeMarker rangeMarker, @NotNull String oldText, @NotNull String replacementText) {
            this.myRangeMarker = rangeMarker;
            this.myOldText = oldText;
            this.myReplacementText = replacementText;
        }

        public boolean isValid() {
            if (!this.myRangeMarker.isValid()) {
                return false;
            }
            TextRange textRange = new TextRange(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            String actualText = this.myRangeMarker.getDocument().getText(textRange);
            return actualText.equals(this.myOldText);
        }
    }
}

