/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySuppressIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.DisableClangTidyCheckIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.DisableClangTidyGroupIntentionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyProblemGroup
implements SuppressableProblemGroup {
    @NotNull
    private final SuppressIntentionAction[] mySuppressIntentionActions;
    @NotNull
    private final String myInspectionId;

    public ClangTidyProblemGroup(@NotNull OCFile file, @NotNull TextRange highlightRange, @NotNull String checkName, boolean canDisableChecks, @NotNull String inspectionId) {
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("ide", checkName);
        this.mySuppressIntentionActions = canDisableChecks ? new SuppressIntentionAction[]{new DisableClangTidyCheckIntentionAction(checkName), new DisableClangTidyGroupIntentionAction(checkName), new ClangTidySuppressIntentionAction(checkName), new OCSuppressClangForCallable(file, highlightRange, suppressionGroup), new OCSuppressClangForFile(file, file.getTextRange(), suppressionGroup)} : new SuppressIntentionAction[]{new OCSuppressClangForCallable(file, highlightRange, suppressionGroup), new OCSuppressClangForFile(file, file.getTextRange(), suppressionGroup)};
        this.myInspectionId = inspectionId;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        return this.mySuppressIntentionActions;
    }

    @Nullable
    public String getProblemName() {
        return this.myInspectionId;
    }
}

