/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ClangTidyUtil {
    private ClangTidyUtil() {
    }

    @Nullable
    public static ClangTidyInspection getInspection(@NotNull PsiFile file, @NotNull Project project2) {
        InspectionProfileEntry tool = ClangTidyUtil.findTool("ClangTidyInspection", false, file, project2);
        return tool instanceof ClangTidyInspection ? (ClangTidyInspection)tool : null;
    }

    @NotNull
    public static OurClangTidyInspection[] getOurInspections(boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project2) {
        InspectionToolWrapper[] tools = ClangTidyUtil.findTools(onlyEnabled, file, project2);
        return (OurClangTidyInspection[])Arrays.stream(tools).filter(tool -> tool != null && tool.getTool() instanceof OurClangTidyInspection).map(tool -> (OurClangTidyInspection)tool.getTool()).toArray(OurClangTidyInspection[]::new);
    }

    @Nullable
    public static ClangTidyInspectionBase findInspectionFromClangTidyDiagnostic(@NotNull ClangTidyDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Project project2) {
        OurClangTidyInspection[] inspections;
        for (OurClangTidyInspection inspection : inspections = ClangTidyUtil.getOurInspections(false, file, project2)) {
            if (!inspection.getCheckName().equals(diagnostic.getDiagnosticName())) continue;
            return inspection;
        }
        return ClangTidyUtil.getInspection(file, project2);
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals(checkName));
        if (!ClangTidyUtil.isDisabled(options, checkName)) {
            options.add("-" + checkName);
        }
        return StringUtil.join(options, (String)",");
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (!ClangTidyUtil.isDisabled(options, groupName)) {
            options.add("-" + groupName + "-*");
        }
        return StringUtil.join(options, (String)",");
    }

    @Nullable
    public static String getGroupNameForCheck(@NotNull String checkName) {
        int index = checkName.indexOf(45);
        return index != -1 ? checkName.substring(0, index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    private static List<String> getTrimmedOptions(@NotNull String configuration) {
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        return options;
    }

    private static boolean isDisabled(@NotNull List<String> options, @NotNull String checkName) {
        boolean disabled = false;
        for (String option : options) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (ClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!ClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }

    @NotNull
    public static String getClangTidyConfig(@NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangTidyUtil.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        return rootObject.toString();
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull OverlayMapping mapping) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Map> roots = new ArrayList<Map>();
        for (File overlayFile : mapping.getOverlayFiles()) {
            File sourceFile = mapping.getSourceFile(overlayFile);
            if (sourceFile == null) continue;
            File parentDirectory = FileUtil.getParentFile((File)sourceFile);
            Map contents = ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)sourceFile.getName()), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"file"), Pair.create((Object)"external-contents", (Object)overlayFile.getAbsolutePath())});
            roots.add(ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)(parentDirectory != null ? parentDirectory.getAbsolutePath() : "")), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"directory"), Pair.create((Object)"contents", (Object)new Object[]{contents})}));
        }
        data.put("version", "0");
        data.put("roots", roots.toArray());
        Yaml yaml = new Yaml();
        return yaml.dump(data);
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        return jsonObject;
    }

    @Nullable
    private static InspectionProfileEntry findTool(@NotNull String inspectionId, boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project2) {
        InspectionToolWrapper[] tools;
        for (InspectionToolWrapper toolWrapper : tools = ClangTidyUtil.findTools(onlyEnabled, file, project2)) {
            if (toolWrapper == null || !toolWrapper.getID().equals(inspectionId)) continue;
            return toolWrapper.getTool();
        }
        return null;
    }

    @NotNull
    private static InspectionToolWrapper[] findTools(boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project2) {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project2)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project2);
        InspectionProfileImpl profile2 = profileManager.getProfile(currentProfile);
        if (profile2 == null) {
            return InspectionToolWrapper.EMPTY_ARRAY;
        }
        InspectionToolWrapper[] wrappers = profile2.getInspectionTools((PsiElement)file);
        if (onlyEnabled) {
            return (InspectionToolWrapper[])Arrays.stream(wrappers).filter(wrapper -> wrapper != null && profile2.isToolEnabled(HighlightDisplayKey.find((String)wrapper.getID()), (PsiElement)file)).toArray(InspectionToolWrapper[]::new);
        }
        return wrappers;
    }
}

