/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

public class ClangTidyYamlLoader {
    public List<ClangTidyDiagnostic> load(@NotNull String yamlContent, @NotNull String sourceFilePath, @NotNull OverlayMapping overlayMapping) {
        CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(YamlData.class, this.getClass().getClassLoader());
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        YamlData yamlData = (YamlData)yaml.loadAs(yamlContent, YamlData.class);
        if (yamlData == null || yamlData.Diagnostics == null) {
            return Collections.emptyList();
        }
        List<YamlDiagnostic> validDiagnostics = yamlData.Diagnostics.stream().filter(diagnostic -> ClangTidyYamlLoader.isValid(diagnostic) && !ClangTidyYamlLoader.isSuppressed(diagnostic)).map(diagnostic -> ClangTidyYamlLoader.mapOverlaysToSourceFiles(diagnostic, overlayMapping)).filter(diagnostic -> ClangTidyYamlLoader.appliedToSourceFile(diagnostic, sourceFilePath)).collect(Collectors.toList());
        Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangTidyYamlLoader.createByteToCharOffsetMap(validDiagnostics, overlayMapping);
        return validDiagnostics.stream().map(diagnostic -> ClangTidyYamlLoader.createClangTidyDiagnostic(diagnostic, byteToCharOffsetMap)).filter(diagnostic -> diagnostic != null).collect(Collectors.toList());
    }

    private static Map<String, Map<Integer, Integer>> createByteToCharOffsetMap(@NotNull List<YamlDiagnostic> diagnostics, @NotNull OverlayMapping overlayMapping) {
        Set<String> unsavedFilePaths = overlayMapping.getSourceFiles().stream().map(file -> file.getPath()).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        return builder.createForYaml(diagnostics, unsavedFilePaths);
    }

    private static boolean appliedToSourceFile(@NotNull YamlDiagnostic diagnostic, @NotNull String sourceFilePath) {
        return FileUtil.pathsEqual((String)diagnostic.FilePath, (String)sourceFilePath);
    }

    @NotNull
    private static YamlDiagnostic mapOverlaysToSourceFiles(@NotNull YamlDiagnostic diagnostic, @NotNull OverlayMapping overlayMapping) {
        File diagnosticFile = new File(diagnostic.FilePath);
        if (overlayMapping.hasSourceFile(diagnosticFile)) {
            diagnostic.FilePath = overlayMapping.getSourceFile(diagnosticFile).getPath();
        }
        if (diagnostic.Replacements != null) {
            for (YamlReplacement replacement : diagnostic.Replacements) {
                File replacementFile = new File(replacement.FilePath);
                if (!overlayMapping.hasSourceFile(replacementFile)) continue;
                replacement.FilePath = overlayMapping.getSourceFile(replacementFile).getPath();
            }
        }
        return diagnostic;
    }

    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull YamlDiagnostic diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        Integer offset;
        List replacements = Collections.emptyList();
        if (diagnostic.Replacements != null) {
            replacements = ContainerUtil.map(diagnostic.Replacements, replacement -> ClangTidyYamlLoader.createClangTidyReplacement(replacement, byteToCharOffsetMap));
        }
        return (offset = ClangTidyYamlLoader.getCharOffset(diagnostic.FilePath, diagnostic.FileOffset, byteToCharOffsetMap)) != null && replacements.stream().allMatch(replacement -> replacement != null) ? new ClangTidyDiagnostic(diagnostic.Message, diagnostic.DiagnosticName, diagnostic.FilePath, offset, replacements) : null;
    }

    @Nullable
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull YamlReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        Integer beginOffset = ClangTidyYamlLoader.getCharOffset(replacement.FilePath, replacement.Offset, byteToCharOffsetMap);
        Integer endOffset = ClangTidyYamlLoader.getCharOffset(replacement.FilePath, replacement.Offset + replacement.Length, byteToCharOffsetMap);
        return beginOffset != null && endOffset != null ? new ClangTidyReplacement(replacement.FilePath, replacement.ReplacementText, beginOffset, endOffset) : null;
    }

    private static Integer getCharOffset(@NotNull String filePath2, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        return byteToCharOffsetMap.getOrDefault(filePath2, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    private static boolean isValid(@Nullable YamlDiagnostic diagnostic) {
        return diagnostic != null && StringUtil.isNotEmpty((String)diagnostic.DiagnosticName) && StringUtil.isNotEmpty((String)diagnostic.FilePath) && StringUtil.isNotEmpty((String)diagnostic.Message) && diagnostic.FileOffset >= 0 && (diagnostic.Replacements == null || diagnostic.Replacements.stream().allMatch(replacement -> ClangTidyYamlLoader.isValid(replacement)));
    }

    private static boolean isValid(@Nullable YamlReplacement replacement) {
        return replacement != null && StringUtil.isNotEmpty((String)replacement.FilePath) && replacement.ReplacementText != null && replacement.Length >= 0 && replacement.Offset >= 0;
    }

    private static boolean isSuppressed(@NotNull YamlDiagnostic diagnostic) {
        return StringUtil.startsWith((CharSequence)diagnostic.DiagnosticName, (CharSequence)"clang-diagnostic");
    }

    static class YamlReplacement {
        public String FilePath;
        public String ReplacementText;
        public int Offset;
        public int Length;

        YamlReplacement() {
        }
    }

    public static class YamlDiagnostic {
        public String Message;
        public String DiagnosticName;
        public String FilePath;
        public int FileOffset;
        public List<YamlReplacement> Replacements;
        public List<Note> Notes;
    }

    static class Note {
        public String Message;
        public String FilePath;
        public int FileOffset;

        Note() {
        }
    }

    static class YamlData {
        public String MainSourceFile;
        public List<YamlDiagnostic> Diagnostics;

        YamlData() {
        }
    }
}

