/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.DisableClangTidyIntentionAction;
import org.jetbrains.annotations.NotNull;

public class DisableClangTidyGroupIntentionAction
extends DisableClangTidyIntentionAction {
    @NotNull
    private final String myGroupName;

    public DisableClangTidyGroupIntentionAction(@NotNull String checkName) {
        String groupName = ClangTidyUtil.getGroupNameForCheck(checkName);
        this.myGroupName = groupName != null ? groupName : "";
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        return super.isAvailable(project2, editor, element) && StringUtil.isNotEmpty((String)this.myGroupName);
    }

    @Override
    @NotNull
    protected String modifyConfiguration(@NotNull String configuration) {
        return ClangTidyUtil.disableGroup(configuration, this.myGroupName);
    }

    @Override
    @NotNull
    public String getText() {
        return "Disable all " + StringUtil.wrapWithDoubleQuote((String)(this.myGroupName + "-*")) + " checks";
    }
}

