/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OpenClangTidySettingsAction
implements IntentionAction {
    @Nls
    @NotNull
    public String getText() {
        return "Open settings";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Open Clang-Tidy Settings";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project2);
        ProjectInspectionToolsConfigurable configurable = new ProjectInspectionToolsConfigurable(profileManager){

            protected boolean acceptTool(InspectionToolWrapper entry) {
                return super.acceptTool(entry) && entry.getTool() instanceof ClangTidyInspection;
            }
        };
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

