/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

class OCEndlessLoopFinder
extends OCDataFlowAlgorithm {
    private Stack<OCNode> myTopologicalOrder = new Stack();
    private List<OCNode> myComponent = new ArrayList<OCNode>();
    private List<OCNode> myEndlessLoops = new ArrayList<OCNode>();
    private List<OCNode> myUnreachedNodes = new ArrayList<OCNode>();
    private boolean myForwardMode;

    OCEndlessLoopFinder(@NotNull OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myEndlessLoops.clear();
        this.myTopologicalOrder.clear();
        this.myUnreachedNodes.clear();
        this.clearProcessedNodes();
        this.myForwardMode = true;
        this.traverse(this.myCfg.getStartNode(), null, null, true);
        for (OCNode node : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node, null)) continue;
            this.myUnreachedNodes.add(node);
        }
        this.myForwardMode = false;
        this.clearProcessedNodes();
        while (!this.myTopologicalOrder.isEmpty()) {
            OCNode node = this.myTopologicalOrder.pop();
            if (this.isNodeProcessed(node, null)) continue;
            this.myComponent.clear();
            this.traverse(node, null, null, false);
            if (!this.isEndlessLoop(this.myComponent)) continue;
            this.myEndlessLoops.addAll(this.myComponent);
        }
    }

    private boolean isEndlessLoop(@NotNull List<OCNode> component) {
        boolean wasJump = false;
        for (OCNode node : component) {
            if (this.myUnreachedNodes.contains(node) || node.getJumpTargets() == null) continue;
            wasJump = true;
            for (OCNode target : node.getJumpTargets()) {
                if (this.myUnreachedNodes.contains(target) || this.isNodeProcessed(target, null)) continue;
                return false;
            }
        }
        return wasJump;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node) {
        if (this.myForwardMode) {
            this.myTopologicalOrder.push(node);
        } else {
            this.myComponent.add(node);
        }
    }

    @NotNull
    public List<OCElementsRange> getEndlessLoops() {
        return OCEndlessLoopFinder.getRanges(this.myEndlessLoops, true);
    }
}

