/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCMultiSymbolAlgorithm;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCEscapedValuesChecker
extends OCMultiSymbolAlgorithm {
    OCEscapedValuesChecker(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    protected boolean processClosureSymbols() {
        return false;
    }

    @NotNull
    public Collection<PsiElement> getEscapedVariables() {
        HashSet result = new HashSet();
        for (Pair<OCSymbol, PsiElement> pair2 : this.getReachableElements()) {
            result.add(pair2.getSecond());
        }
        return result;
    }

    @Override
    protected boolean isGoodWrite(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpr = (OCUnaryExpression)element;
            return unaryExpr.isGetAddress() && !OCCodeInsightUtil.isOverloadedOperatorUsage(unaryExpr) && OCEscapedValuesChecker.isLocalVar(unaryExpr.getOperand()) && !(unaryExpr.getOperand().getResolvedType() instanceof OCMagicType);
        }
        if (element instanceof OCReferenceExpression) {
            if (!OCEscapedValuesChecker.isLocalVar((OCExpression)element)) {
                return false;
            }
            OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class);
            if (declarator != null) {
                return declarator.getResolvedType() instanceof OCCppReferenceType && !(((OCReferenceExpression)element).getResolvedType() instanceof OCMagicType);
            }
            return false;
        }
        if (element instanceof OCBlockExpression) {
            return !OCCompilerFeatures.isArcEnabled(element.getContainingFile());
        }
        return false;
    }

    @Override
    protected boolean isGoodRead(@NotNull OCInstruction instruction) {
        OCSymbol symbol = instruction.getSymbol();
        PsiElement rValue = instruction.getRValue();
        if (rValue != null && symbol.getType().resolve((PsiElement)rValue.getContainingFile()) instanceof OCCppReferenceType) {
            return this.isGoodWrite(rValue);
        }
        return super.isGoodRead(instruction);
    }

    private static boolean isLocalVar(OCExpression operand) {
        if (operand != null) {
            while (operand instanceof OCQualifiedExpression && ((OCQualifiedExpression)operand).getQualifyingTokenKind() == OCTokenTypes.DOT) {
                operand = ((OCQualifiedExpression)operand).getQualifier();
            }
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(OCResolveContext.forPsi(operand));
            operand.accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (!(symbol == null || visitor.getNumOfDereferences() != 0 || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic())) {
                if (symbol.getType().resolve((PsiElement)operand.getContainingFile()) instanceof OCCppReferenceType) {
                    PsiElement declarator = symbol.locateDefinition(operand.getProject());
                    return OCEscapedValuesChecker.isLocalVar(declarator instanceof OCDeclarator ? ((OCDeclarator)declarator).getInitializer() : null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean treatReferencesAsStartInstructions() {
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        PsiElement rValue = instruction.getRValue();
        return super.isEndInstruction(instruction) && rValue != null && OCEscapedValuesChecker.isEscaped(rValue, null);
    }

    @NotNull
    public List<PsiElement> getEscapedObjects() {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final PsiElement codeFragment = this.myCfg.getCodeFragment();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                PsiElement blockScope;
                if (blockExpression != codeFragment && OCEscapedValuesChecker.this.isGoodWrite(blockExpression) && (blockScope = (PsiElement)ContainerUtil.getFirstItem((List)((List)OCCodeInsightUtil.getScopeAndKind(blockExpression).getFirst()))) != null && OCEscapedValuesChecker.isEscaped(blockExpression, OCSymbolOffsetUtil.getComplexRange(blockScope))) {
                    result.add(blockExpression);
                }
            }

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                if (!OCEscapedValuesChecker.isLocalVar(expression)) {
                    return;
                }
                OCType type = expression.getResolvedType();
                if (OCEscapedValuesChecker.isEscaped(expression, null) && (type instanceof OCArrayType || !(type instanceof OCCppReferenceType) && !(type instanceof OCPointerType) && !(type instanceof OCMagicType))) {
                    result.add(expression);
                }
            }

            @Override
            public void visitUnaryExpression(OCUnaryExpression expression) {
                super.visitUnaryExpression(expression);
                if (OCEscapedValuesChecker.this.isGoodWrite(expression) && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }
        });
        result.removeAll(this.getEscapedVariables());
        return result;
    }

    private static boolean canBubble(@NotNull PsiElement element, @NotNull PsiElement parent) {
        if (parent instanceof OCExpression) {
            if (parent instanceof OCConditionalExpression) {
                OCConditionalExpression conditionalExpression = (OCConditionalExpression)parent;
                return PsiTreeUtil.isAncestor((PsiElement)conditionalExpression.getPositiveExpression(true), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)conditionalExpression.getNegativeExpression(), (PsiElement)element, (boolean)false);
            }
            if (parent instanceof OCParenthesizedExpression) {
                return true;
            }
            if (parent instanceof OCCommaExpression) {
                return PsiTreeUtil.isAncestor((PsiElement)((OCCommaExpression)parent).getTailExpression(), (PsiElement)element, (boolean)false);
            }
            if (parent instanceof OCPrefixExpression) {
                OCPrefixExpression prefixExpression = (OCPrefixExpression)parent;
                return !OCCodeInsightUtil.isOverloadedOperatorUsage(prefixExpression) && (prefixExpression.getOperationSign() == OCTokenTypes.MINUSMINUS || prefixExpression.getOperationSign() == OCTokenTypes.PLUSPLUS);
            }
        }
        return false;
    }

    private static boolean isEscaped(@NotNull PsiElement element, @Nullable ComplexTextRange scope) {
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (OCEscapedValuesChecker.isAssignmentExpression(parent)) {
                OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(OCResolveContext.forPsi(element));
                OCExpression receiverExpression = ((OCAssignmentExpression)parent).getReceiverExpression();
                receiverExpression.accept(visitor);
                OCSymbol symbol = visitor.getSymbol();
                if (symbol != null) {
                    OCType type = OCTypeUtils.getCppReferencedType(receiverExpression.getResolvedType());
                    if (symbol instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                        return false;
                    }
                    if (!(type instanceof OCPointerType)) {
                        return false;
                    }
                    if (scope != null && !scope.equals(symbol.getScope())) {
                        return true;
                    }
                    if (scope == null && !symbol.getKind().isLocal()) {
                        return true;
                    }
                }
                return false;
            }
            if (parent instanceof OCReturnStatement) {
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)parent, OCCallable.class);
                if (callable == null) continue;
                OCType returnType = callable.getReturnType().resolve((PsiElement)parent.getContainingFile());
                return returnType instanceof OCCppReferenceType || returnType instanceof OCPointerType;
            }
            if (!OCEscapedValuesChecker.canBubble(element, parent)) break;
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean isAssignmentExpression(@NotNull PsiElement expression) {
        return expression instanceof OCAssignmentExpression && ((OCAssignmentExpression)expression).getOperationSign() == OCTokenTypes.EQ;
    }
}

