/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotUsedValueChecker
extends OCSingleSymbolAlgorithm {
    private boolean[] myReachableNodesFromReference;
    private boolean mySymbolUsed;
    private boolean mySymbolAssigned;
    private boolean myIgnoreKills;

    public OCNotUsedValueChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        super(cfg, false, symbol);
        this.myReachableNodesFromReference = new boolean[cfg.getNumOfNodes()];
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        this.myIgnoreKills = true;
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return;
        }
        if (!instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            this.mySymbolUsed = true;
            return;
        }
        for (OCInstruction instruction : instructions.get((Object)OCInstruction.InstructionKind.REFERENCE)) {
            this.traverse(instruction.getNode(), this.mySymbol, null, true);
        }
        this.myIgnoreKills = false;
        System.arraycopy(this.myProcessedNodes, 0, this.myReachableNodesFromReference, 0, this.myCfg.getNumOfNodes());
        super.process();
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (this.myIgnoreKills) {
            return true;
        }
        return instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        switch (instruction.getKind()) {
            case READ: 
            case READ_IN_BLOCK: 
            case REFERENCE: {
                this.mySymbolUsed = true;
                return true;
            }
            case WRITE: 
            case WRITE_IN_BLOCK: {
                this.mySymbolAssigned = true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        return instruction.getKind() == OCInstruction.InstructionKind.WRITE && (!(this.mySymbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)this.mySymbol).isFriendOrStatic());
    }

    @Override
    protected boolean isProcessed(@NotNull OCInstruction instruction, boolean isForward) {
        return this.myReachableNodesFromReference[instruction.getNode().getIndex()] || super.isProcessed(instruction, isForward);
    }

    @NotNull
    public List<PsiElement> getNotUsedWrites() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            return Collections.emptyList();
        }
        return this.getNonReachableElements();
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        return instruction.getLValue();
    }

    public boolean isSymbolUsed() {
        return this.mySymbolUsed;
    }

    public boolean isSymbolAssigned() {
        return this.mySymbolAssigned;
    }
}

