/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.relations.RelationSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCConditionsList {
    private List<Conditions> myList;

    OCConditionsList(@NotNull List<Conditions> list) {
        this.myList = list;
    }

    @NotNull
    List<Conditions> getConditions() {
        return this.myList;
    }

    public boolean isUnconditional() {
        for (Conditions conditions : this.myList) {
            if (!conditions.myUnconditionalBranch) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OCConditionsList merge(@NotNull OCConditionsList conds) {
        if (this.isUnconditional() && conds.isUnconditional()) {
            return this;
        }
        return new OCConditionsList(ContainerUtil.concat(this.myList, conds.myList));
    }

    @NotNull
    public OCConditionsList skipEvaluation(@NotNull BranchInfo branch) {
        return new OCConditionsList(ContainerUtil.map(this.myList, conditions -> new Conditions((Conditions)conditions, true, branch)));
    }

    @NotNull
    public OCConditionsList combine(@NotNull OCConditionsList conds, @NotNull BranchInfo branch) {
        ArrayList<Conditions> result = new ArrayList<Conditions>();
        for (Conditions cond1 : this.myList) {
            for (Conditions cond2 : conds.myList) {
                if (cond1.myUnconditionalBranch) {
                    result.add(cond2);
                    continue;
                }
                if (cond2.myUnconditionalBranch) {
                    result.add(cond1);
                    continue;
                }
                result.add(new Conditions(cond1, cond2));
                Condition lastCondition = (Condition)ContainerUtil.getLastItem(cond2.getConditions());
                if (lastCondition == null) continue;
                lastCondition.myBranches.add(branch);
            }
        }
        return new OCConditionsList(result);
    }

    public void clearBranches() {
        for (Conditions conditions : this.myList) {
            for (Condition condition : conditions.getConditions()) {
                condition.myBranches.clear();
            }
        }
    }

    @NotNull
    public static OCConditionsList singleton(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, Attribute ... attributes) {
        return new OCConditionsList(Collections.singletonList(new Conditions(branch, fakeNode, relation, attributes)));
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static Set<Integer> shiftIndices(@Nullable Set<Integer> indices, int shift) {
        if (indices == null) {
            return null;
        }
        return ContainerUtil.map2Set(indices, index -> index + shift);
    }

    static class Conditions {
        private List<Condition> myConditions;
        private Set<Integer> mySkipEvaluationIndices;
        private boolean myUnconditionalBranch;

        Conditions(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, Attribute ... attributes) {
            this.myConditions = Collections.singletonList(new Condition(branch, fakeNode, relation, attributes));
            this.myUnconditionalBranch = attributes.length == 0;
        }

        Conditions(@NotNull Conditions conds1, @NotNull Conditions conds2) {
            this.myConditions = ContainerUtil.concat(conds1.myConditions, conds2.myConditions);
            if (conds1.mySkipEvaluationIndices == null) {
                this.mySkipEvaluationIndices = OCConditionsList.shiftIndices(conds2.mySkipEvaluationIndices, conds1.getConditions().size());
            } else if (conds2.mySkipEvaluationIndices == null) {
                this.mySkipEvaluationIndices = conds1.mySkipEvaluationIndices;
            } else {
                this.mySkipEvaluationIndices = new HashSet<Integer>();
                this.mySkipEvaluationIndices.addAll(conds1.mySkipEvaluationIndices);
                this.mySkipEvaluationIndices.addAll(OCConditionsList.shiftIndices(conds2.mySkipEvaluationIndices, conds1.getConditions().size()));
            }
        }

        Conditions(@NotNull Conditions conds, boolean skipEvaluation, @NotNull BranchInfo branch) {
            this.myConditions = conds.myConditions;
            this.myUnconditionalBranch = conds.myUnconditionalBranch;
            this.mySkipEvaluationIndices = skipEvaluation ? new HashSet<Integer>(Collections.singleton(this.myConditions.size())) : null;
            Condition lastCondition = (Condition)ContainerUtil.getLastItem(this.myConditions);
            if (lastCondition != null) {
                lastCondition.myBranches.add(branch);
            }
        }

        @NotNull
        List<Condition> getConditions() {
            return this.myConditions;
        }

        public Set<Integer> getSkipEvaluationIndices() {
            return this.mySkipEvaluationIndices;
        }
    }

    static class Condition {
        List<BranchInfo> myBranches = new ArrayList<BranchInfo>();
        RelationSignature myRelation;
        Attribute[] myAttributes;
        OCNode myFakeNode;

        Condition(@Nullable BranchInfo branch, @Nullable OCNode fakeNode, @NotNull RelationSignature relation, @NotNull Attribute[] attributes) {
            if (branch != null) {
                this.myBranches.add(branch);
            }
            this.myRelation = relation;
            this.myAttributes = attributes;
            this.myFakeNode = fakeNode;
        }

        @NotNull
        List<BranchInfo> getBranches() {
            return this.myBranches;
        }

        @NotNull
        RelationSignature getRelation() {
            return this.myRelation;
        }

        @NotNull
        Attribute[] getAttributes() {
            return this.myAttributes;
        }

        @Nullable
        OCNode getFakeNode() {
            return this.myFakeNode;
        }
    }

    static class BranchInfo {
        PsiElement myCondition;
        boolean myBranch;
        boolean myCanBeShortCutted;

        BranchInfo(@Nullable PsiElement condition, boolean branch, boolean canBeShortCutted) {
            this.myCondition = condition;
            this.myBranch = branch;
            this.myCanBeShortCutted = canBeShortCutted;
        }

        @Nullable
        PsiElement getCondition() {
            return this.myCondition;
        }

        boolean isTrueBranch() {
            return this.myBranch;
        }

        boolean isCanBeShortCutted() {
            return this.myCanBeShortCutted;
        }
    }
}

