/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.documentation.DoxygenRender;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    @Nullable
    final ExternalProvider myExternalProvider;
    private final Map<String, CodeStyleSettings> mySettings = new HashMap();

    public CidrDocumentationProvider() {
        this(null);
    }

    public CidrDocumentationProvider(@Nullable ExternalProvider provider2) {
        this.myExternalProvider = provider2;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        String content = this.quickDocContent(element, originalElement, false);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result;
        if (element == null) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression && (result = CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element)) != null) {
            return result;
        }
        String doc = this.generateDocInnerHtml(element, originalElement, false);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (object instanceof OCSymbol && psiManager != null) {
            return ((OCSymbol)object).locateDefinition(psiManager.getProject());
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if (link.startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts.size() == 3) {
                PsiElement elementAt;
                PsiFile file;
                String path = (String)parts.get(1);
                String offset = (String)parts.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid() && (elementAt = file.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(',').append(file.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        PsiReference reference = sme.getReference();
        if (reference instanceof OCPolyVariantReference) {
            List list = ((OCPolyVariantReference)reference).resolveToSymbols();
            StringBuilder builder = new StringBuilder();
            for (Object o : list) {
                if (!(o instanceof OCMethodSymbol)) continue;
                OCMethodSymbol symbol = (OCMethodSymbol)o;
                OCClassSymbol parent = symbol.getParent();
                String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
                if (link == null) continue;
                builder.append("<a href=\"").append(link).append("\">").append(symbol.getSignature(sme.getProject())).append(" (").append(parent.getPresentableName()).append(")</a><br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(OCResolveContext.forPsi(sme)), builder.toString()});
        }
        return null;
    }

    @Nullable
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        Project project2 = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(element);
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppNamespace)element).getSymbol();
            if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                if (namespaceSymbol.isInlineNamespace()) {
                    answer.append(OCTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                answer.append(symbol.getKindLowercase(context)).append(" ");
                String namespace = OCDocUtil.getNamespace(namespaceSymbol, context);
                if (!namespace.isEmpty()) {
                    answer.append(namespace).append("::");
                }
                return answer.append("<b>").append(symbol.getName()).append("</b>").toString();
            }
            return null;
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file;
            OCInterfaceSymbol anInterface;
            StringBuilder answer = new StringBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file = anInterface.getContainingOCFile(project2)) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            StringBuilder answer = new StringBuilder();
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append(" <b>");
            answer.append(((OCMethodSelectorPart)element).getName());
            answer.append("</b>");
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            return this.getSymbolDoc(element, symbol);
        }
        if (element instanceof OCSymbolHolderVirtualPsiElement) {
            List<OCFunctionSymbol> overloads;
            Object symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCFunctionGroupSymbol && (overloads = ((OCFunctionGroupSymbol)symbol).getOverloads()).size() == 1) {
                symbol = overloads.get(0);
            }
            return this.getSymbolDoc(element, (OCSymbol)symbol);
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file = element.getContainingFile();
            StringBuilder answer = new StringBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define <b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            if (symbol.hasParameterList()) {
                answer.append('(');
                answer.append(StringUtil.join(symbol.getParameterNames(), name2 -> CidrDocumentationProvider.escapeHTML(name2), (String)", "));
                answer.append(')');
            }
            answer.append(" ").append(CidrDocumentationProvider.escapeHTML(symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using <b>");
                answer.append(symbol.getName());
                answer.append("</b> = ");
                answer.append(CidrDocumentationProvider.effectiveTypeString(symbol, project2));
            }
            return answer.toString();
        }
        if (element instanceof OCCppNamespaceAlias) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
            OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
            if (OCLog.LOG.assertTrue(symbol != null)) {
                OCSymbolKind kind = symbol.getKind();
                OCSymbolReference ref = symbol.getNamespaceReference();
                answer.append(kind.getNameLowercase()).append(" ");
                answer.append("<b>").append(symbol.getName()).append("</b> = ");
                answer.append(ref.getQualifiedName().getFullName(OCResolveContext.forPsi(element)));
            }
            return answer.toString();
        }
        if (element instanceof OCStructLike) {
            OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            if (symbol == null) {
                return answer.toString();
            }
            CidrDocumentationProvider.addNamespace(symbol, answer, context);
            CidrDocumentationProvider.addVisibility(symbol, answer);
            String canonicalNamePrefix = CidrDocumentationProvider.getCanonicalNamePrefix(symbol, project2);
            String templateParamList = CidrDocumentationProvider.getTemplateParameters(symbol, project2);
            if (symbol.isPredeclaration()) {
                OCDocUtil.extractModifiers(symbol, answer);
            } else {
                answer.append(templateParamList);
            }
            answer.append(symbol.getKindLowercase(context)).append(" ");
            if (symbol.isEnumClass()) {
                answer.append("class ");
            }
            answer.append(canonicalNamePrefix).append("<b>").append(symbol.getName()).append("</b>");
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, project2);
            if (symbol.isFinal()) {
                answer.append(" ").append(OCTokenTypes.FINAL_CPP_KEYWORD.getName());
            }
            answer.append(CidrDocumentationProvider.getBaseClasses(symbol, element));
            return answer.toString().replaceAll("\\s+", " ");
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            return CidrDocumentationProvider.declaredInHint(element.getContainingFile()) + common.getType(element) + "  <b>" + common.getDescriptiveName(element) + "</b>";
        }
        return null;
    }

    @NotNull
    private String getSymbolDoc(@NotNull PsiElement element, OCSymbol symbol) {
        String type;
        OCClassDeclaration container;
        PsiElement pp;
        StringBuilder answer = new StringBuilder();
        Project project2 = element.getProject();
        OCFile containingFile = symbol == null ? null : symbol.getContainingOCFile(project2);
        OCDeclarator declarator = (OCDeclarator)ObjectUtils.tryCast((Object)element, OCDeclarator.class);
        if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
        }
        if (symbol != null) {
            CidrDocumentationProvider.addNamespace(symbol, answer, OCResolveContext.forPsi(element));
            CidrDocumentationProvider.addVisibility(symbol, answer);
        }
        if ((pp = element.getParent().getParent()) instanceof OCProperty) {
            OCProperty property = (OCProperty)pp;
            String iVarDoc = this.propertyIVarDoc(property);
            if (iVarDoc != null) {
                return iVarDoc;
            }
            OCClassDeclaration container2 = property.getContainingClass();
            if (container2 != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container2)).append("<br>");
            }
            answer.append("@property ");
            OCPropertyAttributesList attrs = property.getPropertyAttributesList();
            if (attrs != null) {
                String attrsStr = StringUtil.join(attrs.getAttributes(), attribute -> attribute.getText(), (String)", ");
                answer.append("(").append(attrsStr).append(") ");
            }
        } else if (pp instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        if (symbol != null) {
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                answer.append("ivar ");
            } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                answer.append("typedef ");
            }
        }
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol definition;
            OCFunctionSymbol func = (OCFunctionSymbol)symbol;
            if (func.isFriend() && (definition = (OCFunctionSymbol)func.getDefinitionSymbol(project2)) != null) {
                func = definition;
            }
            answer.append(CidrDocumentationProvider.getTemplateParameters(func, project2));
            OCDocUtil.extractModifiers(func, answer);
            if (!func.isCppConstructor() && !func.isCppDestructor()) {
                type = CidrDocumentationProvider.effectiveTypeString(func, project2);
                answer.append(type).append(OCDocUtil.delimiter(type));
            }
            answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(func, project2));
            answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(func.getName())).append("</b>");
            this.extractFunctionSignature(declarator, func, answer, project2);
        } else if (symbol instanceof OCDeclaratorSymbol) {
            answer.append(CidrDocumentationProvider.getTemplateParameters(symbol, project2));
            OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, answer);
            boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
            type = CidrDocumentationProvider.effectiveTypeString(symbol, project2);
            answer.append(type).append(OCDocUtil.delimiter(type, isEnumConst ? "::" : " "));
            if (!isEnumConst) {
                answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(symbol, project2));
            }
            answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
        } else if (declarator != null) {
            CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
            answer.append(" <b>");
            answer.append(declarator.getName());
            answer.append("</b>");
        }
        if (declarator != null) {
            this.processInitializer(declarator, answer);
        }
        return answer.toString();
    }

    @NotNull
    private static String getBaseClasses(@NotNull OCStructSymbol symbol, @NotNull PsiElement element) {
        Project project2 = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(element);
        Collection<Pair<OCType, OCVisibility>> baseClasses = symbol.getBaseCppClassesWithVisibility(context);
        if (!baseClasses.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            OCFile containingFile = symbol.getContainingOCFile(project2);
            String baseClassesStr = StringUtil.join(baseClasses, pair2 -> {
                OCVisibility visibility = (OCVisibility)((Object)((Object)pair2.getSecond()));
                String visibilityStr = "";
                if (visibility != null) {
                    visibilityStr = (Object)((Object)visibility) + " ";
                }
                OCType type = (OCType)pair2.getFirst();
                return visibilityStr + OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2);
            }, (String)", ");
            return " : " + baseClassesStr;
        }
        return "";
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull StringBuilder answer) {
        OCExpression initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer();
        if (initializer != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull StringBuilder answer) {
        String text = initializer.getTextWithMacros();
        int idx = text.indexOf(10);
        if (idx != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(CidrDocumentationProvider.escapeHTML(part)).append("...");
        } else {
            answer.append(CidrDocumentationProvider.escapeHTML(text));
        }
    }

    private void extractFunctionSignature(@Nullable OCDeclarator declarator, OCFunctionSymbol symbol, StringBuilder answer, Project project2) {
        Collection<OCTypeArgument> substitutionTypes;
        if (declarator != null) {
            declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        }
        if ((substitutionTypes = symbol.getSubstitution().getSubstitutedTypes()) != null && !substitutionTypes.isEmpty()) {
            answer.append(OCDocUtil.getParametersSignature(symbol, false, project2));
        } else {
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, project2);
            answer.append(OCDocUtil.getParametersSignature(symbol, true, project2));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    private static String getTemplateParameters(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol instanceof OCTemplateSymbol && symbol instanceof OCSymbolWithQualifiedName) {
            StringBuilder sb = new StringBuilder();
            OCTemplateSymbol templateSymbol = (OCTemplateSymbol)symbol;
            if (templateSymbol.isTemplateSymbol()) {
                List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), OCResolveContext.forSymbol(symbol, project2));
                OCFile containingFile = symbol.getContainingOCFile(project2);
                List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
                OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, containingFile, sb, project2);
                return sb.append("<br>").toString();
            }
        }
        return "";
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> ignore) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result;
        PsiElement copy = element.copy();
        final ArrayList comments = new ArrayList();
        copy.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(PsiComment comment) {
                comments.add(comment);
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)copy) && (result = SourceTreeToPsiMap.treeElementToPsi((ASTNode)(formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree((PsiElement)copy)))) != null) {
            return (T)result;
        }
        return (T)copy;
    }

    private CodeStyleSettings getSettings(@NotNull Language lang) {
        String langID = lang.getID();
        if (!this.mySettings.containsKey(langID)) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@NotNull OCSymbolWithQualifiedName symbol, @NotNull StringBuilder sb, @NotNull Project project2) {
        List<OCTypeArgument> specialization;
        if (symbol instanceof OCTemplateSymbol && (specialization = ((OCTemplateSymbol)((Object)symbol)).getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCResolveContext.forSymbol(symbol, project2));
            OCFile containingFile = symbol.getContainingOCFile(project2);
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, containingFile, sb, project2);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull StringBuilder answer, @NotNull OCResolveContext context) {
        String namespace;
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && (namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol, context)).length() > 0) {
            answer.append("namespace ").append(namespace).append("<br><br>");
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        OCVisibility visibility;
        if (symbol instanceof OCSymbolWithQualifiedName && (visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC) {
            answer.append(visibility.toString()).append(":<br>");
        }
    }

    @NotNull
    private static String getCanonicalNamePrefix(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefix((OCSymbolWithQualifiedName)symbol, project2);
            return prefix.isEmpty() ? "" : prefix + "::";
        }
        return "";
    }

    @NotNull
    private static String effectiveTypeString(@NotNull OCSymbol symbol, @NotNull Project project2) {
        OCFile containingFile = symbol.getContainingOCFile(project2);
        OCType effectiveType = symbol.getEffectiveType(project2);
        OCType type = effectiveType.accept(new OCTypeParameterResolveVisitor(containingFile));
        if (type instanceof OCMagicType) {
            type = effectiveType;
        }
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, context);
            return OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2));
        }
        return OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type.getBestNameInContext(context)));
    }

    @Nullable
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar = CidrDocumentationProvider.getPropertyIVar(p);
        if (iVar != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        Project project2 = p.getProject();
        if (ps != null) {
            iVar = ps.getAssociatedIvar(project2);
        }
        return iVar == null ? null : iVar.locateDefinition(project2);
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd = p.getDeclaration();
        if (pd == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    private static String declaredInHint(@NotNull PsiFile file) {
        return CidrDocumentationProvider.declaredInHint(file.getName());
    }

    @NotNull
    public static String declaredInHint(@NotNull String fileName) {
        return "<b>Declared In:</b> " + fileName + "<br><br>";
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        Project project2 = element.getProject();
        if (element instanceof OCReferenceElement) {
            OCSymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty(project2);
                if (property2 != null) {
                    return property2.locateDefinition(project2);
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getOriginalSymbol()) != null) {
                return property.locateDefinition(project2);
            }
        }
        return element;
    }

    @Nullable
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        return type.getText();
    }

    @NotNull
    private static String classHintDoc(@NotNull OCClassDeclaration classDeclaration) {
        return (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
    }

    @NotNull
    private static String methodHintDoc(@NotNull OCMethod method) {
        StringBuilder answer = new StringBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        answer.append(method.isInstanceMethod() ? (char)'-' : '+').append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append("<b>");
            answer.append(part.getSelectorPart());
            answer.append("</b>");
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        return answer.toString();
    }

    private static void appendType(@NotNull StringBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getName();
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(CidrDocumentationProvider.escapeHTML(typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        boolean isExternalDocProvided;
        StringBuilder answer = new StringBuilder();
        if (this.myExternalProvider != null) {
            this.myExternalProvider.addExternalDoc(element, originalElement, answer);
        }
        boolean bl = isExternalDocProvided = answer.length() > 0;
        if (element instanceof PsiFile && !isExternalDocProvided) {
            return null;
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (!skipQuickDoc && answer.length() == 0) {
            this.addQuickDoc(element, originalElement, answer);
        }
        if (!isExternalDocProvided) {
            this.addCommentDoc(element, answer);
        }
        if (!isExternalDocProvided && element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(answer, (PsiNamedElement)element);
        }
        return answer.length() == 0 ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull StringBuilder answer) {
        String quickDoc = this.quickDocContent(element, originalElement, true);
        if (quickDoc != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append("<code>").append(quickDoc).append("</code>");
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        VirtualFile vFile;
        PsiFile psiFile = namedElement.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name2 = namedElement.getName();
        if (name2 == null) {
            return;
        }
        String man = CidrDocumentationProvider.getManPage(name2);
        if (man != null && man.length() > 0) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            if (answer.length() > 0) {
                answer.append("<br>");
            }
            answer.append(CidrDocumentationProvider.man2html(man));
        }
    }

    private void addMacroDoc(@Nullable PsiElement originalElement, @NotNull StringBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file;
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.length() == 0 && (file = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file));
        }
        answer.append("<b>Definition:</b><br><br><tt>");
        answer.append(HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros()).replaceAll("[ ]+\n", "\n"));
        answer.append("</tt><br>");
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)originalElement, (Class[])new Class[]{OCMacroCall.class});
        if (macroCall != null) {
            answer.append("<b>Replacement:</b><br><br><tt>");
            answer.append(HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)define, (String)CidrDocumentationProvider.getFormattedText(macroCall, macroCall.getReplacementText())));
            answer.append("</tt>");
        }
    }

    @NotNull
    private static String getFormattedText(@NotNull PsiElement context, @NotNull String replacement) {
        OCCodeFragment fragment = OCElementFactory.codeFragment(replacement, context.getProject(), context, PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCExpression.class, OCStatement.class}) != null ? OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT : OCTokenTypes.OC_FILE, false, true);
        Document document2 = FileDocumentManager.getInstance().getDocument(fragment.getViewProvider().getVirtualFile());
        String formattedText = document2 == null || PsiDocumentManager.getInstance((Project)fragment.getProject()).isCommitted(document2) ? fragment.getText() : document2.getText();
        return formattedText.replaceAll("(\n[ \t\r]*)+\n", "\n");
    }

    @Contract(pure=true)
    @NotNull
    protected static String escapeHTML(@NotNull String text) {
        return StringUtil.escapeXmlEntities((String)text);
    }

    private static void addBreakIfRequired(@NotNull StringBuilder answer) {
        if (answer.length() > 0) {
            answer.append("<br>");
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name2) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("man");
        cl.addParameter("-S");
        cl.addParameter("2:3");
        cl.addParameter(name2);
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(cl);
            ProcessOutput result = handler.runProcess(1000);
            if (result.isTimeout()) {
                return null;
            }
            return result.getStdout().trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static String man2html(@NotNull String man) {
        StringBuilder a = new StringBuilder();
        a.append("<pre>");
        boolean wasBold = false;
        boolean wasUnderscored = false;
        for (int i = 0; i < man.length(); ++i) {
            boolean bold;
            char c = man.charAt(i);
            char next = i + 1 < man.length() ? man.charAt(i + 1) : (char)'\u0000';
            boolean underscored = c == '_' && next == '\b';
            boolean bl = bold = c != '_' && next == '\b';
            if (!bold && wasBold) {
                wasBold = false;
                a.append("</b>");
            }
            if (!underscored && wasUnderscored) {
                wasUnderscored = false;
                a.append("</u>");
            }
            if (!bold && !underscored) {
                CidrDocumentationProvider.appendSymbol(a, c);
                continue;
            }
            if (bold && !wasBold) {
                a.append("<b>");
                wasBold = true;
            }
            if (underscored && !wasUnderscored) {
                a.append("<u>");
                wasUnderscored = true;
            }
            CidrDocumentationProvider.appendSymbol(a, man.charAt(i + 2));
            i += 2;
        }
        a.append("</pre>");
        return a.toString();
    }

    private static void appendSymbol(@NotNull StringBuilder a, char c) {
        switch (c) {
            case ' ': {
                a.append("&nbsp;");
                break;
            }
            case '\t': {
                a.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                break;
            }
            case '<': {
                a.append("&lt;");
                break;
            }
            case '>': {
                a.append("&gt;");
                break;
            }
            case '\"': {
                a.append("&quot;");
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @NotNull
    public static String wrapDocInHtml(@NotNull String doc) {
        return "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
    }

    private void addCommentDoc(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        boolean added = this.addCommentDocForElement(element, answer);
        if (!added) {
            List<OCSymbolWithParent> elements = OCDocUtil.getSuperSymbols(element);
            for (OCSymbolWithParent s : elements) {
                int pos = answer.length();
                PsiElement psiElement = s.locateDefinition(element.getProject());
                if (psiElement == null) continue;
                if (psiElement instanceof OCDeclarator) {
                    psiElement = psiElement.getParent();
                }
                if (!this.addCommentDocForElement(psiElement, answer)) continue;
                answer.insert(pos, "<br><br><b>Description copied from: </b>" + OCDocUtil.getLink(s));
                break;
            }
        }
    }

    private boolean addCommentDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        int length = answer.length();
        DoxygenRender dxRender = new DoxygenRender(element);
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(answer);
        } else {
            this.addDocForElement(element, answer);
        }
        return answer.length() > length;
    }

    protected void addDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        String data;
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiComment comment : this.findCommentsFor(element)) {
            IElementType type = comment.getTokenType();
            comments.add(comment);
            if (type == OCTokenTypes.EOL_COMMENT) continue;
            content.add(this.processComments(comments));
            comments.clear();
        }
        if (!comments.isEmpty()) {
            content.add(this.processComments(comments));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(data = StringUtil.join(content, (String)"\n")))) {
            answer.append("<pre>").append(data).append("</pre>");
        }
    }

    @NotNull
    private String processComments(@NotNull List<PsiComment> comments) {
        int commonPaddingIdx = 0x3FFFFFFF;
        ArrayList content = new ArrayList();
        for (PsiComment comment : comments) {
            String text = CidrDocumentationProvider.escapeHTML(this.stripCommentBegin(comment.getText()));
            List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
            assert (lines.size() > 0);
            String fistLine = (String)lines.get(0);
            if (!fistLine.isEmpty()) {
                lines.set(0, "  " + fistLine);
            }
            for (String line : lines) {
                int padding = CidrDocumentationProvider.indent(line, comment.getTokenType() != OCTokenTypes.EOL_COMMENT);
                if (padding >= commonPaddingIdx) continue;
                commonPaddingIdx = padding;
            }
            content.addAll(lines);
        }
        int padding = commonPaddingIdx;
        List result = content.stream().map(s -> s.substring(Math.min(s.length(), padding))).collect(Collectors.toList());
        return StringUtil.join(result, (String)"\n");
    }

    private static int indent(@NotNull String line, boolean processAsterisk) {
        int i;
        if (line.isEmpty()) {
            return 0x3FFFFFFF;
        }
        for (i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (!processAsterisk || ch != '*') break;
            processAsterisk = false;
        }
        return i < line.length() ? i : 0x3FFFFFFF;
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        text = StringUtil.trimTrailing((String)text, (char)' ');
        return text;
    }

    @NotNull
    protected List<PsiComment> findCommentsFor(@Nullable PsiElement element) {
        List<PsiComment> comments = this.findOCCommentFor(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            PsiElement associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project2);
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition(project2)) != null) {
                comments = this.findOCCommentFor(associatedElement);
            }
        }
        return comments;
    }

    protected boolean acceptDocComment(@NotNull PsiComment comment) {
        return !DoxygenFacade.isDoxygenSupported() || !DoxygenFacade.isDoxygenComment(comment);
    }

    @NotNull
    private List<PsiComment> findOCCommentFor(@Nullable PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            return Collections.emptyList();
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return Collections.emptyList();
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        this.findPrevComments(elt, comments);
        this.findInnerComments(elt, comments);
        this.findPostComments(elt, comments);
        return comments;
    }

    protected void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            PsiComment c;
            PsiElement prevSibling;
            if (element instanceof OCMacroCall || element instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)element.getText()) <= 1) continue;
            if (!(element instanceof PsiComment) || (prevSibling = element.getPrevSibling()) != null && (!(prevSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)prevSibling.getText()) <= 0) || !this.acceptDocComment(c = (PsiComment)element)) break;
            comments.add(0, c);
        }
    }

    protected void findInnerComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        Iterator iterator2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class).iterator();
        while (iterator2.hasNext() && this.acceptDocComment(c = (PsiComment)iterator2.next())) {
            comments.add(c);
        }
    }

    protected void findPostComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        PsiElement next;
        for (next = elt.getNextSibling(); next != null && (next instanceof PsiWhiteSpace && !next.getText().contains("\n") || next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.SEMICOLON); next = next.getNextSibling()) {
        }
        if (next instanceof PsiComment && this.acceptDocComment(c = (PsiComment)next)) {
            comments.add(c);
        }
    }

    public static interface ExternalProvider {
        public void addExternalDoc(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull StringBuilder var3);
    }
}

