/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import org.jetbrains.annotations.NotNull;

public class HtmlHelper {
    public static String bold(@NotNull String arg) {
        return HtmlHelper.wrapWithTag("b", arg);
    }

    public static String code(@NotNull String arg) {
        return HtmlHelper.wrapWithTag("code", arg);
    }

    public static String pre(@NotNull String arg) {
        return HtmlHelper.wrapWithTag("pre", arg);
    }

    public static String paragraph(@NotNull String arg) {
        return HtmlHelper.wrapWithTag("p", arg);
    }

    public static String newLine(@NotNull String arg) {
        return "<br>" + arg;
    }

    private static String wrapWithTag(@NotNull String tag, @NotNull String arg) {
        StringBuilder sb = new StringBuilder();
        HtmlHelper.wrapWithTag(sb, tag, arg);
        return sb.toString();
    }

    private static void wrapWithTag(@NotNull StringBuilder sb, @NotNull String tag, @NotNull String arg) {
        sb.append("<").append(tag).append(">").append(arg).append("</").append(tag).append(">");
    }

    public static class TableRow
    extends HtmlItem {
        public static TableRow withData(@NotNull String arg) {
            TableRow raw = new TableRow();
            raw.addData(arg);
            return raw;
        }

        public void addData(@NotNull String arg) {
            HtmlHelper.wrapWithTag(this.sb, "td", arg);
        }

        public String toString() {
            return "<tr valign=\"top\">" + this.sb.toString() + "</tr>";
        }
    }

    public static class Table
    extends HtmlItem {
        public void addRow(@NotNull TableRow element) {
            this.sb.append(element.toString());
        }

        public String toString() {
            return HtmlHelper.wrapWithTag("table", this.sb.toString());
        }
    }

    public static class DL
    extends HtmlItem {
        public void defineTerm(@NotNull String arg) {
            HtmlHelper.wrapWithTag(this.sb, "dt", arg);
        }

        public void detailedDescription(@NotNull HtmlItem arg) {
            this.detailedDescription(arg.toString());
        }

        public void detailedDescription(@NotNull String arg) {
            HtmlHelper.wrapWithTag(this.sb, "dd", arg);
        }

        public String toString() {
            return HtmlHelper.wrapWithTag("dl", this.sb.toString());
        }
    }

    public static class HtmlDoc
    extends HtmlItem {
        public void addText(@NotNull String arg) {
            this.sb.append(arg);
        }

        public void addItem(@NotNull HtmlItem arg) {
            this.sb.append(arg.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class HtmlItem {
        protected final StringBuilder sb = new StringBuilder();
    }
}

