/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesFinalHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;

public class OCEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCEnterAfterUnmatchedBraceHandler");
    private static final EnterBetweenBracesFinalHandler ENTER_BETWEEN_BRACES_HANDLER = new EnterBetweenBracesFinalHandler();

    public boolean isApplicable(@NotNull PsiFile file, int caretOffset) {
        return file instanceof OCFile;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!(language instanceof OCLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return OCEnterAfterUnmatchedBraceHandler.isBlockWithSemicolonAtEnd(editor, caretOffsetRef) ? OCEnterAfterUnmatchedBraceHandler.preprocessEnterInsideBraces(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler) : super.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
    }

    private static EnterHandlerDelegate.Result preprocessEnterInsideBraces(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterHandlerDelegate.Result result = ENTER_BETWEEN_BRACES_HANDLER.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
        return result == EnterHandlerDelegate.Result.Continue ? EnterHandlerDelegate.Result.DefaultForceIndent : result;
    }

    private static boolean isBlockWithSemicolonAtEnd(@NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef) {
        int caretOffset = (Integer)caretOffsetRef.get();
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        it.retreat();
        if (!OCTypedHandlerDelegate.needSemicolonAtContextEnd(it)) {
            return false;
        }
        it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        while (!it.atEnd()) {
            if (it.getTokenType() == OCTokenTypes.RBRACE) {
                it.advance();
                while (!it.atEnd() && OCTokenTypes.WHITESPACES.contains(it.getTokenType())) {
                    it.advance();
                }
                return !it.atEnd() && it.getTokenType() == OCTokenTypes.SEMICOLON;
            }
            it.advance();
        }
        return false;
    }

    @NotNull
    protected String generateStringToInsert(@NotNull Editor editor, int caretOffset, int maxRBraceCount) {
        assert (maxRBraceCount > 0);
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        StringBuilder generatedRBraces = new StringBuilder(maxRBraceCount);
        while (((LexerEditorHighlighter.HighlighterIteratorImpl)it).currentIndex() >= 0) {
            IElementType currType = it.getTokenType();
            if (currType == OCTokenTypes.LBRACE) {
                it.retreat();
                generatedRBraces.append('}');
                if (!OCTypedHandlerDelegate.needSemicolonAtContextEnd(it)) break;
                generatedRBraces.append(';');
                break;
            }
            if (StringUtil.contains((CharSequence)it.getDocument().getCharsSequence(), (int)it.getStart(), (int)it.getEnd(), (char)'\n') || currType == OCTokenTypes.RBRACE) break;
            it.retreat();
        }
        return generatedRBraces.length() == 0 ? "}" : generatedRBraces.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file, @NotNull Document document2, @NotNull Editor editor, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        try {
            int firstLine = document2.getLineNumber(caretOffset + 1);
            int lastLine = document2.getLineNumber(rBracesInsertOffset + 2);
            for (int line = firstLine; line <= lastLine; ++line) {
                EnterHandler.adjustLineIndentNoCommit((Language)file.getLanguage(), (Document)document2, (Editor)editor, (int)Math.max(DocumentUtil.getFirstNonSpaceCharOffset((Document)document2, (int)line), 0));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            document2.deleteString(caretOffset, caretOffset + 1);
        }
    }

    protected int getRBraceOffset(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset) {
        int fileLength;
        CharSequence text = editor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        if (offset < (fileLength = text.length()) && ")];,%<?".indexOf(text.charAt(offset)) < 0) {
            offset = OCEnterAfterUnmatchedBraceHandler.calculateOffsetToInsertClosingBraceWithLexer(file, editor, text, offset);
        }
        return Math.min(offset, fileLength);
    }

    private static int calculateOffsetToInsertClosingBraceWithLexer(@NotNull PsiFile file, @NotNull Editor editor, @NotNull CharSequence text, int offset) {
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset);
        while (!it.atEnd() && !OCLineIndentProvider.hasNewLine(text, it)) {
            IElementType type = it.getTokenType();
            if (OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS.contains(type) || type == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                return offset;
            }
            if (type == OCTokenTypes.RBRACE || type == OCTokenTypes.LBRACE) break;
            it.advance();
        }
        if (it.atEnd()) {
            return offset;
        }
        if (OCLineIndentProvider.hasNewLine(text, it)) {
            return OCTokenTypes.WHITESPACES.contains(it.getTokenType()) ? CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)it.getStart(), (String)"\n") : offset;
        }
        if (it.getTokenType() == OCTokenTypes.RBRACE) {
            return OCEnterAfterUnmatchedBraceHandler.checkSemicolonAfterRBrace(it, text);
        }
        if (it.getTokenType() == OCTokenTypes.LBRACE) {
            offset = it.getStart();
            return BraceMatchingUtil.matchBrace((CharSequence)text, (FileType)file.getFileType(), (HighlighterIterator)it, (boolean)true) ? OCEnterAfterUnmatchedBraceHandler.checkSemicolonAfterRBrace(it, text) : offset;
        }
        return it.getStart();
    }

    private static int checkSemicolonAfterRBrace(@NotNull HighlighterIterator it, @NotNull CharSequence text) {
        int start = it.getStart();
        int end = it.getEnd();
        it.advance();
        OCLineIndentProvider.skipWhiteSpacesInLine(it, text, true);
        return it.atEnd() || it.getTokenType() == OCTokenTypes.SEMICOLON ? start : end;
    }
}

