/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCEnterInTemplateHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        IElementType[] templListOwners;
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!(language instanceof OCLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (caretOffset == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int lexerPos = caretOffset - 1;
        HighlighterIterator caretIt = OCEnterInTemplateHandler.getIteratorAtPosition((EditorEx)editor, caretOffset);
        CharSequence sequence = editor.getDocument().getCharsSequence();
        for (IElementType owner2 : templListOwners = new IElementType[]{OCTokenTypes.IDENTIFIER, OCTokenTypes.TEMPLATE_CPP_KEYWORD}) {
            boolean foundGT;
            HighlighterIterator prevTemplateIt = OCEnterInTemplateHandler.getIteratorAtPosition((EditorEx)editor, lexerPos);
            if (OCLineIndentProvider.containsNewLine(sequence, prevTemplateIt.getStart(), caretOffset)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (!OCEnterInTemplateHandler.findTemplateTokens(false, prevTemplateIt, sequence, owner2)) continue;
            HighlighterIterator nextLTit = OCEnterInTemplateHandler.getIteratorAtPosition((EditorEx)editor, prevTemplateIt.getEnd());
            OCLineIndentProvider.skipWhiteSpacesInLine(nextLTit, sequence, true);
            if (nextLTit.atEnd() || nextLTit.getTokenType() == OCTokenTypes.LT && caretOffset <= nextLTit.getStart()) {
                OCEnterInTemplateHandler.insertIndent(file, editor, dataContext, originalHandler, caretIt, Indent.Type.CONTINUATION, caretOffset);
                return EnterHandlerDelegate.Result.Stop;
            }
            if (nextLTit.getTokenType() != OCTokenTypes.LT) continue;
            HighlighterIterator nextPairGT = OCEnterInTemplateHandler.getIteratorAtPosition((EditorEx)editor, nextLTit.getEnd());
            boolean bl = foundGT = OCEnterInTemplateHandler.findTemplateTokens(true, nextPairGT, sequence, OCTokenTypes.TEMPLATE_CPP_KEYWORD, OCTokenTypes.GT, OCTokenTypes.GTGT) && (nextPairGT.getTokenType() == OCTokenTypes.GT || nextPairGT.getTokenType() == OCTokenTypes.GTGT);
            if (caretOffset <= nextLTit.getEnd() || foundGT && caretOffset < nextPairGT.getEnd()) {
                OCEnterInTemplateHandler.insertIndent(file, editor, dataContext, originalHandler, caretIt, Indent.Type.CONTINUATION, caretOffset);
                return EnterHandlerDelegate.Result.Stop;
            }
            if (foundGT && owner2 == OCTokenTypes.IDENTIFIER) {
                OCEnterInTemplateHandler.insertIndent(file, editor, dataContext, originalHandler, caretIt, Indent.Type.CONTINUATION, caretOffset);
                return EnterHandlerDelegate.Result.Stop;
            }
            if (!foundGT || owner2 != OCTokenTypes.TEMPLATE_CPP_KEYWORD) continue;
            nextPairGT.advance();
            OCLineIndentProvider.skipWhiteSpacesInLine(nextPairGT, sequence, true);
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class);
            boolean needIndentAfterTemplate = false;
            if (!nextPairGT.atEnd() && OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS.contains(nextPairGT.getTokenType())) {
                needIndentAfterTemplate = settings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT;
            } else if (!nextPairGT.atEnd() && (OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(nextPairGT.getTokenType()) || nextPairGT.getTokenType() == OCTokenTypes.IDENTIFIER)) {
                needIndentAfterTemplate = settings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT;
            } else if (nextPairGT.atEnd() || nextPairGT.getTokenType() != OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                needIndentAfterTemplate = settings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && settings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT;
            }
            OCEnterInTemplateHandler.insertIndent(file, editor, dataContext, originalHandler, caretIt, needIndentAfterTemplate ? Indent.Type.NORMAL : Indent.Type.NONE, caretOffset);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    static void insertIndent(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull EditorActionHandler originalHandler, @NotNull HighlighterIterator caretIt, @NotNull Indent.Type indent, int caretOffset) {
        Document document2 = editor.getDocument();
        CharSequence documentChars = document2.getCharsSequence();
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER && caretIt.getTokenType() == TokenType.WHITE_SPACE) {
            int deleteTo;
            CharSequence sequence = documentChars.subSequence(caretIt.getStart(), caretIt.getEnd());
            int wsLength = sequence.length();
            for (deleteTo = caretOffset - caretIt.getStart(); deleteTo < wsLength && "\t ".indexOf(sequence.charAt(deleteTo)) >= 0; ++deleteTo) {
            }
            document2.deleteString(caretOffset, caretIt.getStart() + deleteTo);
        }
        CaretModel caretModel = editor.getCaretModel();
        originalHandler.execute(editor, caretModel.getCurrentCaret(), dataContext);
        if (indent != Indent.Type.NONE) {
            CommonCodeStyleSettings.IndentOptions indentOptionsByFile = CodeStyle.getSettings((PsiFile)file).getIndentOptionsByFile(file);
            int indentSize = indent == Indent.Type.CONTINUATION ? indentOptionsByFile.CONTINUATION_INDENT_SIZE : indentOptionsByFile.INDENT_SIZE;
            document2.insertString(caretModel.getOffset(), (CharSequence)StringUtil.repeatSymbol((char)' ', (int)indentSize));
        }
    }

    static boolean findTemplateTokens(boolean forward, @NotNull HighlighterIterator it, @NotNull CharSequence text, IElementType ... stopTypes) {
        List<IElementType> types = Arrays.asList(stopTypes);
        int inTemplateBrackets = 0;
        int inParens = 0;
        int inSquareBracket = 0;
        if (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE) {
            if (forward) {
                it.advance();
            } else {
                it.retreat();
            }
        }
        while (!it.atEnd() && !OCLineIndentProvider.hasNewLine(text, it)) {
            IElementType currType = it.getTokenType();
            if (OCTypedHandlerDelegate.STOPSET.contains(currType)) {
                return false;
            }
            if (inParens == 0 && inSquareBracket == 0) {
                if (inTemplateBrackets == 0) {
                    if (types.contains(currType)) {
                        return true;
                    }
                    if (forward && (currType == OCTokenTypes.RPAR || currType == OCTokenTypes.RBRACKET)) {
                        return false;
                    }
                    if (!(forward || currType != OCTokenTypes.LPAR && currType != OCTokenTypes.LBRACKET)) {
                        return false;
                    }
                }
                if (!(currType != OCTokenTypes.GT || inTemplateBrackets == 0 && forward)) {
                    ++inTemplateBrackets;
                } else if (!(currType != OCTokenTypes.GTGT || inTemplateBrackets == 0 && forward)) {
                    inTemplateBrackets += 2;
                } else if (currType == OCTokenTypes.LT && (inTemplateBrackets != 0 || forward)) {
                    --inTemplateBrackets;
                } else if (currType == OCTokenTypes.LTLT && (inTemplateBrackets != 0 || forward)) {
                    inTemplateBrackets -= 2;
                }
            }
            if (currType == OCTokenTypes.RBRACKET) {
                ++inSquareBracket;
            } else if (currType == OCTokenTypes.LBRACKET) {
                --inSquareBracket;
            } else if (currType == OCTokenTypes.RPAR) {
                ++inParens;
            } else if (currType == OCTokenTypes.LPAR) {
                --inParens;
            }
            if (forward) {
                it.advance();
                continue;
            }
            it.retreat();
        }
        return false;
    }

    @NotNull
    static HighlighterIterator getIteratorAtPosition(@NotNull EditorEx editor, int offset) {
        return editor.getHighlighter().createIterator(offset);
    }
}

