/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCAsyncParamInfoModel;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCSyncParameterInfoHandler;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.SignatureInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.impl.OCAsyncParamInfoResult;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements OCSyncParameterInfoHandler {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCFunctionParameterInfoHandler");
    private SmartPsiElementPointer<PsiElement> myElement = null;
    private List<OCFunctionParameterInfo> myOverloads = null;
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    @Override
    public boolean init(Project project2, PsiFile file, int offset) {
        OCFunctionCallPlace callPlace = OCFunctionParameterInfoHandler.findCallPlace(file, offset);
        if (callPlace == null) {
            return false;
        }
        ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
        callPlace.collectCallOptions(callOptions);
        Collections.sort(callOptions, (o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
        this.myOverloads = new ArrayList<OCFunctionParameterInfo>();
        OCResolveContext resolveContext = OCResolveContext.forNullablePsi((PsiElement)file, project2);
        block0: for (OCFunctionCallOption option : callOptions) {
            OCFunctionParameterInfo info = option.getParameterInfo();
            OCFunctionType funcType = info.getType();
            for (int i = 0; i < this.myOverloads.size(); ++i) {
                OCFunctionParameterInfo other = this.myOverloads.get(i);
                OCFunctionType otherType = other.getType();
                if (!otherType.equalsAfterResolving(funcType, resolveContext)) continue;
                if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                this.myOverloads.set(i, info);
                continue block0;
            }
            this.myOverloads.add(info);
        }
        this.myElement = SmartPointerManager.createPointer(callPlace.getElement());
        return true;
    }

    @Override
    @Nullable
    public OCAsyncParamInfoModel.Result calculate(int offset) {
        LOG.assertTrue(this.myElement != null && this.myOverloads != null);
        OCFunctionCallPlace<? extends PsiElement> callPlace = OCFunctionParameterInfoHandler.callPlace(this.myElement.getElement());
        if (callPlace == null) {
            return null;
        }
        PsiElement element = callPlace.getElement();
        if (!element.getTextRange().contains(offset)) {
            return null;
        }
        int currentParameterIndex = OCFunctionParameterInfoHandler.getCurrentParameterIndex(offset, element);
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        List<SignatureInfo> signatures = this.myOverloads.stream().map(it -> OCFunctionParameterInfoHandler.updateFunctionUI(it, currentParameterIndex, OCFunctionParameterInfoHandler.isApplicableBeforeIndex(it.getType(), argExpressions, currentParameterIndex))).collect(Collectors.toList());
        return new OCAsyncParamInfoResult(offset, signatures);
    }

    private static int getCurrentParameterIndex(int offset, PsiElement element) {
        int currentParameterIndex = 0;
        for (ASTNode child = element.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++currentParameterIndex;
        }
        return currentParameterIndex;
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names = funcType.getParameterNames();
        if (names == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace findCallPlace(PsiFile file, int offset) {
        if (file == null) {
            return null;
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@Nullable PsiElement element) {
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCExpression arg;
            OCType argType;
            OCType paramType = params.get(j);
            if (!paramType.checkCompatible(argType = (arg = args.get(j)).getResolvedType(), arg, arg, OCResolveContext.forPsi(arg)).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public static SignatureInfo updateFunctionUI(@NotNull OCFunctionParameterInfo info, int currentParameter, boolean isEnabled) {
        StringBuilder buffer = new StringBuilder();
        OCFunctionType type = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type.getParameterTypes();
        List<String> paramNames = type.getParameterNames();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i = 0; i < numParams; ++i) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i).getName();
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i);
                String defValue = defParamValues == null ? null : defParamValues.get(i);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i < numParams - 1) {
                    buffer.append(", ");
                }
                if (!isEnabled || i != currentParameter && (i != numParams - 1 || !type.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new SignatureInfo(buffer.toString(), highlightStartOffset, highlightEndOffset, !isEnabled, false, false, null);
    }
}

