/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandler;
import com.jetbrains.cidr.lang.editor.OCInjectedFileChangesHandlerProviderKt;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionManipulatorKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\b\u0002\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u001c\u0010\u001a\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/editor/OCInjectedFileChangesHandler;", "Lcom/intellij/psi/impl/source/tree/injected/changesHandler/CommonInjectedFileChangesHandler;", "shreds", "", "Lcom/intellij/psi/PsiLanguageInjectionHost$Shred;", "editor", "Lcom/intellij/openapi/editor/Editor;", "newDocument", "Lcom/intellij/openapi/editor/Document;", "injectedFile", "Lcom/intellij/psi/PsiFile;", "(Ljava/util/List;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiFile;)V", "myOrigCreationStamp", "", "commitToOriginal", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "failAndReport", "", "message", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "rebuildLocalMarkersFromShreds", "substringVerbose", "start", "", "cursor", "intellij.c"})
final class OCInjectedFileChangesHandler
extends CommonInjectedFileChangesHandler {
    private final long myOrigCreationStamp;

    private final void rebuildLocalMarkersFromShreds() {
        Place shreds = InjectedLanguageUtil.getShreds((PsiFile)this.myInjectedFile);
        if (this.getMarkers().size() != shreds.size()) {
            Void void_ = OCInjectedFileChangesHandler.failAndReport$default(this, "markers and shreds doesn't match", null, null, 6, null);
            throw null;
        }
        ArrayList<Trinity> newMarkers = new ArrayList<Trinity>(this.getMarkers().size());
        for (Pair pair2 : CollectionsKt.zip((Iterable)this.getMarkers(), (Iterable)((Iterable)shreds))) {
            RangeMarker rangeMarker;
            TextRange shredRange;
            TextRange textRange;
            PsiLanguageInjectionHost.Shred shred;
            Trinity marker = (Trinity)pair2.component1();
            PsiLanguageInjectionHost.Shred $receiver = shred = (PsiLanguageInjectionHost.Shred)pair2.component2();
            boolean bl = false;
            if ($receiver.getHost() != null) {
                PsiLanguageInjectionHost psiLanguageInjectionHost;
                PsiLanguageInjectionHost it = psiLanguageInjectionHost;
                boolean bl2 = false;
                textRange = $receiver.getRangeInsideHost().shiftRight(it.getTextRange().getStartOffset());
            } else {
                textRange = shredRange = null;
            }
            if (Intrinsics.areEqual(shredRange, (Object)OCInjectedFileChangesHandlerProviderKt.access$getRange$p((Segment)OCInjectedFileChangesHandlerProviderKt.access$getOrigin$p(marker))) ^ true) {
                Void void_ = OCInjectedFileChangesHandler.failAndReport$default(this, "shred and marker doesn't match " + shredRange + " != " + OCInjectedFileChangesHandlerProviderKt.access$getRange$p((Segment)OCInjectedFileChangesHandlerProviderKt.access$getOrigin$p(marker)), null, null, 6, null);
                throw null;
            }
            RangeMarker $receiver2 = rangeMarker = this.localRangeMarkerFromShred(shred);
            boolean bl3 = false;
            $receiver2.setGreedyToLeft(OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).isGreedyToLeft());
            $receiver2.setGreedyToRight(OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).isGreedyToRight());
            RangeMarker newLocalMarker = rangeMarker;
            OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).dispose();
            newMarkers.add(new Trinity((Object)OCInjectedFileChangesHandlerProviderKt.access$getOrigin$p(marker), (Object)newLocalMarker, marker.third));
        }
        this.getMarkers().clear();
        this.getMarkers().addAll((Collection)newMarkers);
    }

    /*
     * WARNING - void declaration
     */
    public void commitToOriginal(@NotNull DocumentEvent e) {
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        if (!this.myInjectedFile.isValid()) {
            return;
        }
        int n = e.getNewLength();
        int n2 = e.getOldLength();
        int n3 = e.getOffset();
        int n4 = Math.max(n, n2);
        TextRange affectedRange = TextRange.from((int)n3, (int)n4);
        Iterable iterable = $receiver$iv = (Iterable)this.getMarkers();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            Trinity it = (Trinity)element$iv$iv;
            boolean bl = false;
            if (!affectedRange.intersects((Segment)OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List affectedMarkers = (List)destination$iv$iv;
        if (affectedMarkers.isEmpty()) {
            Void void_ = OCInjectedFileChangesHandler.failAndReport$default(this, "no markers affected", e, null, 4, null);
            throw null;
        }
        int cursor = 0;
        int $receiver$iv$iv2 = 0;
        int n5 = ((Collection)affectedMarkers).size();
        while ($receiver$iv$iv2 < n5) {
            OCLiteralExpression host;
            String string;
            void i;
            Trinity marker = (Trinity)affectedMarkers.get((int)i);
            RangeMarker localMarker = OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker);
            PsiLanguageInjectionHost psiLanguageInjectionHost = OCInjectedFileChangesHandlerProviderKt.access$getHost$p(marker);
            if (!(psiLanguageInjectionHost instanceof OCLiteralExpression)) {
                psiLanguageInjectionHost = null;
            }
            if ((OCLiteralExpression)psiLanguageInjectionHost == null) {
                Void void_ = OCInjectedFileChangesHandler.failAndReport$default(this, "can't get markers host", e, null, 4, null);
                throw null;
            }
            if (localMarker.isValid()) {
                int n6;
                int $i$f$filter = localMarker.getStartOffset();
                int start = Math.max(cursor, $i$f$filter);
                String text = localMarker.getDocument().getText();
                if (OCInjectedFileChangesHandlerProviderKt.access$affectedLength(marker, affectedRange) == 0 && OCInjectedFileChangesHandlerProviderKt.access$affectedLength((Trinity)CollectionsKt.getOrNull((List)affectedMarkers, (int)(i + true)), affectedRange) > 1) {
                    Object object = CollectionsKt.getOrNull((List)affectedMarkers, (int)(i + true));
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    n6 = OCInjectedFileChangesHandlerProviderKt.access$getLocal$p((Trinity)object).getStartOffset();
                } else {
                    int n7 = text.length();
                    int n8 = localMarker.getEndOffset();
                    int n9 = e.getOffset() + e.getNewLength();
                    n8 = Math.max(n8, n9);
                    n6 = Math.min(n7, n8);
                }
                cursor = n6;
                string = this.substringVerbose(text, start, cursor);
            } else {
                string = "";
            }
            String markerFragment = string;
            try {
                OCLiteralExpressionManipulatorKt.changeContentAtSegment$default(host, (Segment)OCInjectedFileChangesHandlerProviderKt.access$getOrigin$p(marker), markerFragment, false, 4, null);
            }
            catch (IllegalStateException ex) {
                Void void_ = this.failAndReport("astNode for " + OCInjectedFileChangesHandlerProviderKt.access$getOrigin$p(marker) + " not found in " + host, e, ex);
                throw null;
            }
            ++i;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myOrigDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final Void failAndReport(String message, DocumentEvent e, Exception exception) {
        void $receiver$iv;
        Attachment attachment;
        String string;
        Object[] objectArray;
        Object object;
        String string2 = "OCInjectedFileChangesHandler: " + message + " (event = " + e + ")," + " myInjectedFile.isValid = " + this.myInjectedFile.isValid() + ", isValid = " + this.isValid();
        Object[] objectArray2 = new Attachment[4];
        Object object2 = (Trinity)CollectionsKt.firstOrNull((List)this.getMarkers());
        if (object2 == null || (object2 = OCInjectedFileChangesHandlerProviderKt.access$getHost$p(object2)) == null || (object2 = object2.getText()) == null) {
            object2 = "<null>";
        }
        objectArray2[0] = new Attachment("host", (String)object2);
        objectArray2[1] = new Attachment("markers", this.getMarkers().toString());
        objectArray2[2] = new Attachment("injected document", this.myNewDocument.getText());
        Object[] objectArray3 = objectArray2;
        Object[] objectArray4 = objectArray2;
        int n = 3;
        Exception exception2 = exception;
        if (exception2 != null) {
            object = exception2;
            int n2 = n;
            Object[] objectArray5 = objectArray3;
            objectArray = objectArray4;
            string = string2;
            Exception it = object;
            boolean bl = false;
            Attachment attachment2 = new Attachment("exception", (Throwable)it);
            string2 = string;
            objectArray4 = objectArray;
            objectArray3 = objectArray5;
            n = n2;
            attachment = attachment2;
        } else {
            attachment = null;
        }
        objectArray3[n] = attachment;
        object = CollectionsKt.listOfNotNull((Object[])objectArray4);
        string = string2;
        void v8 = $receiver$iv;
        if (v8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v8;
        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
        if (attachmentArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = attachmentArray;
        Attachment[] attachmentArray2 = (Attachment[])objectArray;
        Attachment[] attachmentArray3 = Arrays.copyOf(attachmentArray2, attachmentArray2.length);
        String string3 = string;
        throw (Throwable)new RuntimeExceptionWithAttachments(string3, attachmentArray3);
    }

    static /* synthetic */ Void failAndReport$default(OCInjectedFileChangesHandler oCInjectedFileChangesHandler, String string, DocumentEvent documentEvent, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            documentEvent = null;
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        return oCInjectedFileChangesHandler.failAndReport(string, documentEvent, exception);
    }

    private final String substringVerbose(@NotNull String $receiver, int start, int cursor) {
        String string;
        try {
            String string2 = string = $receiver;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start, cursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
        }
        catch (StringIndexOutOfBoundsException e) {
            Void void_ = OCInjectedFileChangesHandler.failAndReport$default(this, "can't get substring (" + start + ", " + cursor + ") of '" + $receiver + "'[" + $receiver.length() + ']', null, e, 2, null);
            throw null;
        }
        return string;
    }

    public OCInjectedFileChangesHandler(@NotNull List<? extends PsiLanguageInjectionHost.Shred> shreds, @NotNull Editor editor, @NotNull Document newDocument, @NotNull PsiFile injectedFile) {
        super(shreds, editor, newDocument, injectedFile);
        this.myOrigCreationStamp = this.myOrigDocument.getModificationStamp();
        int lastEnd = -1;
        for (Trinity marker : this.getMarkers()) {
            if (OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).getStartOffset() == lastEnd) {
                OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).setGreedyToLeft(false);
            }
            lastEnd = OCInjectedFileChangesHandlerProviderKt.access$getLocal$p(marker).getEndOffset();
        }
        this.myOrigDocument.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (UndoManager.getInstance((Project)myProject).isUndoInProgress()) {
                    PsiDocumentManagerBase.addRunOnCommit((Document)myOrigDocument, (Runnable)new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            if (OCInjectedFileChangesHandler.access$getMyOrigCreationStamp$p(this.this$0.this) <= OCInjectedFileChangesHandler.access$getMyOrigDocument$p(this.this$0.this).getModificationStamp()) {
                                OCInjectedFileChangesHandler.access$rebuildLocalMarkersFromShreds(this.this$0.this);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ long access$getMyOrigCreationStamp$p(OCInjectedFileChangesHandler $this) {
        return $this.myOrigCreationStamp;
    }

    public static final /* synthetic */ void access$rebuildLocalMarkersFromShreds(OCInjectedFileChangesHandler $this) {
        $this.rebuildLocalMarkersFromShreds();
    }
}

