/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLineIndentProvider
extends JavaLikeLangLineIndentProvider
implements JoinedLinesSpacingCalculator {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();
    private static final SemanticEditorPosition.Rule LINE_STARTER;
    private static boolean ourCanUseFormatterForIndent;
    private static final SemanticEditorPosition.SyntaxElement[] LEFTS;
    private static final SemanticEditorPosition.SyntaxElement[] RIGHTS;
    private static final IndentCalculator.BaseLineOffsetCalculator STRONG_LINE_BEFORE;

    public static void skipWhiteSpacesInLine(@NotNull HighlighterIterator it, @NotNull CharSequence sequence, boolean forward) {
        while (!it.atEnd() && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType()) && !OCLineIndentProvider.hasNewLine(sequence, it)) {
            if (forward) {
                it.advance();
                continue;
            }
            it.retreat();
        }
    }

    static boolean hasNewLine(@NotNull CharSequence sequence, @NotNull HighlighterIterator it) {
        return OCLineIndentProvider.containsNewLine(sequence, it.getStart(), it.getEnd());
    }

    @Contract(pure=true)
    static boolean containsNewLine(@NotNull CharSequence text, int start, int end) {
        return start < end && StringUtil.contains((CharSequence)text, (int)start, (int)end, (char)'\n');
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        return OCLineIndentProvider.getSyntaxElement(tokenType);
    }

    @Nullable
    public static SemanticEditorPosition.SyntaxElement getSyntaxElement(@Nullable IElementType tokenType) {
        return (SemanticEditorPosition.SyntaxElement)SYNTAX_MAP.get((Object)tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        return language.isKindOf((Language)OCLanguage.getInstance());
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        CommonCodeStyleSettings commonCodeStyleSettings;
        SemanticEditorPosition beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        if (beforeStart.isAtEnd()) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.NORMAL);
        }
        EditorEx editor = blockStartPosition.getEditor();
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument());
        boolean validSource = file instanceof OCFile && language instanceof OCLanguage;
        OCCodeStyleSettings codeStyleSettings = validSource ? (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class) : null;
        CommonCodeStyleSettings commonCodeStyleSettings2 = commonCodeStyleSettings = validSource ? CodeStyle.getLanguageSettings((PsiFile)file) : null;
        if (validSource && (beforeStart.isAt((IElementType)OCTokenTypes.RBRACKET) || beforeStart.isAt((IElementType)OCTokenTypes.LPAR) || beforeStart.isAt((IElementType)OCTokenTypes.XOR))) {
            return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_INSIDE_CODE_BLOCK);
        }
        if (beforeStart.isAt((IElementType)OCTokenTypes.EQ) || beforeStart.isAt((IElementType)OCTokenTypes.AT)) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (validSource) {
            OCTypedHandlerDelegate.ContextType blockType = OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(beforeStart));
            switch (blockType) {
                case Namespace: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_NAMESPACE_MEMBERS);
                }
                case ClassCPP: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_CLASS_MEMBERS);
                }
                case StructLike: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_C_STRUCT_MEMBERS);
                }
                case SwitchStatement: {
                    return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonCodeStyleSettings.INDENT_CASE_FROM_SWITCH ? Indent.Type.NORMAL : Indent.Type.NONE));
                }
            }
        }
        return super.getIndentInBlock(project2, language, blockStartPosition);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        return statementBeforeSemicolon.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.ReturnLike);
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        return OCLineIndentProvider.isSwitchContext(OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position));
    }

    @Contract(pure=true)
    private static boolean isSwitchContext(@NotNull Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context) {
        SemanticEditorPosition editorPosition = (SemanticEditorPosition)context.first;
        if (editorPosition == null) {
            return false;
        }
        SemanticEditorPosition.SyntaxElement element = editorPosition.getCurrElement();
        return element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCSElement.Identifier && context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement;
    }

    @NotNull
    public static Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> getColonAfterLabelCaseDefaultPublicContext(@NotNull SemanticEditorPosition finPos) {
        if (!finPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            return Pair.create(null, null);
        }
        SemanticEditorPosition maybeCaseDefaultPublic = finPos.copy();
        SemanticEditorPosition.SyntaxElement element = maybeCaseDefaultPublic.elementAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault, OCSElement.PublicLike});
        if (element != null) {
            return Pair.create((Object)maybeCaseDefaultPublic, null);
        }
        SemanticEditorPosition maybeLabelId = finPos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
        if (maybeLabelId.getCurrElement() == OCSElement.Identifier && maybeLabelId.before().isAtMultiline(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            SemanticEditorPosition pos = maybeLabelId.copy();
            pos.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            if (!pos.isAtEnd()) {
                return Pair.create((Object)maybeLabelId, (Object)((Object)OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(pos))));
            }
        }
        return Pair.create(null, null);
    }

    @NotNull
    private static HighlighterIterator createEditorIteratorAtPosition(@NotNull SemanticEditorPosition pos) {
        return pos.getEditor().getHighlighter().createIterator(pos.getStartOffset());
    }

    @Nullable
    private static OCLanguageKind getLanguageKind(@NotNull SemanticEditorPosition pos) {
        PsiFile file;
        EditorEx editor = pos.getEditor();
        if (editor.getProject() != null && editor.getVirtualFile() != null && (file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile((Document)editor.getDocument())) instanceof OCFile) {
            return OCLanguageKindCalculator.calculateLanguageKind(null, editor.getVirtualFile(), editor.getProject(), false);
        }
        return null;
    }

    protected boolean isInsideForLikeConstruction(@NotNull SemanticEditorPosition finPos) {
        return finPos.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    @NotNull
    protected HighlighterIterator getIteratorAtPosition(final @NotNull EditorEx editor, int offset) {
        return new HighlighterIteratorWrapper(editor.getHighlighter().createIterator(offset)){

            public void advance() {
                super.advance();
                CharSequence sequence = this.getDocument().getCharsSequence();
                while (this.isInDirective()) {
                    while (this.atTheSameLine(sequence)) {
                        super.advance();
                    }
                    super.advance();
                }
            }

            public void retreat() {
                super.retreat();
                CharSequence sequence = this.getDocument().getCharsSequence();
                while (this.isInDirective()) {
                    while (this.atTheSameLine(sequence)) {
                        super.retreat();
                    }
                    super.retreat();
                }
            }

            boolean atTheSameLine(CharSequence sequence) {
                return !this.atEnd() && !StringUtil.contains((CharSequence)sequence, (int)this.getStart(), (int)this.getEnd(), (char)'\n');
            }

            boolean isInDirective() {
                if (this.atEnd()) {
                    return false;
                }
                if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(this.getTokenType())) {
                    return true;
                }
                Document document2 = this.getDocument();
                int offset = document2.getLineStartOffset(document2.getLineNumber(this.getStart()));
                if (offset < 0) {
                    return false;
                }
                HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
                while (!iterator2.atEnd() && OCTokenTypes.WHITESPACES.contains(iterator2.getTokenType())) {
                    iterator2.advance();
                }
                return OCFormatterUtil.FORMAT_DIRECTIVES.contains(iterator2.getTokenType());
            }
        };
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !(!ignoreLabels ? position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.PublicLike, OCSElement.Identifier}) : position.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike));
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        SemanticEditorPosition maybeLineStarter;
        Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context;
        IndentCalculator indent;
        SemanticEditorPosition pos = this.getPosition(editor, offset);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)editor);
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        Document document2 = editor.getDocument();
        boolean inNewLineSpace = pos.matchesRule(LINE_STARTER);
        SemanticEditorPosition firstTokenAtNewLine = pos.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (inNewLineSpace) {
            SemanticEditorPosition secondToken = firstTokenAtNewLine.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if ((firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike) && secondToken.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) && document2.getLineNumber(offset + 1) == document2.getLineNumber(firstTokenAtNewLine.getStartOffset())) {
                return this.createInBlockSpaceIndentCalculator(project2, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
        }
        if ((indent = super.getIndent(project2, editor, language, offset)) != null) {
            return indent;
        }
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory myFactory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project2, editor);
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions options = commonSettings.getIndentOptions();
        if (inNewLineSpace) {
            SemanticEditorPosition lastTokenInLine = OCLineIndentProvider.getLastAnchorTokenInPrevLine(pos.before());
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, position -> lastTokenInLine.getStartOffset());
            }
            if (lastTokenInLine.isAtEnd() || lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment)) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace})) {
                return this.getIndent(project2, editor, language, this.getBlockStatementStartOffset(lastTokenInLine));
            }
            if (lastTokenInLine.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && pos.after().afterOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At).isAt((IElementType)OCTokenTypes.STRING_LITERAL)) {
                return this.getAlignWithPrevLiteralIndent(project2, editor, document2, lastTokenInLine);
            }
            context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(lastTokenInLine);
            if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                    return this.createInBlockSpaceIndentCalculator(project2, editor, customSettings.INDENT_CLASS_MEMBERS);
                }
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.Identifier && options != null) {
                    SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore((SemanticEditorPosition)context.first);
                    if (element != null) {
                        return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                    }
                    return this.createInBlockSpaceIndentCalculator(project2, editor, options.INDENT_SIZE + (context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement && commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0));
                }
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                return myFactory.createIndentCalculator(this.getIndentInBlock(project2, language, lastTokenInLine.before()), arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0));
            }
            if (lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.StructLike}) && !lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Typedef})) {
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition testEqAnchor = lastTokenInLine;
            SemanticEditorPosition maybeLeft = lastTokenInLine.copy();
            maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, self -> self.isAtMultiline());
            if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket)) {
                testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
            } else {
                maybeLeft = lastTokenInLine.copy();
                maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, self -> self.isAtMultiline());
                if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
                }
            }
            if (OCLineIndentProvider.isEqLikeOnLineBefore(testEqAnchor)) {
                IndentCalculator it;
                if (OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) && (it = this.getAlignIndentCalculator(project2, editor, document2, maybeLeft)) != null) {
                    return it;
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (OCLineIndentProvider.isTemplateLikeOnLineBefore(lastTokenInLine)) {
                SemanticEditorPosition after2 = lastTokenInLine.after().afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
                if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                if (lastTokenInLine.isAt((IElementType)OCTokenTypes.GT) || lastTokenInLine.isAt((IElementType)OCTokenTypes.GTGT)) {
                    if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    if (OCLineIndentProvider.isLikeFunctionDecl(after2)) {
                        return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(customSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && customSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma) || firstTokenAtNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                maybeLeft = OCLineIndentProvider.findLeftBracketInLine(lastTokenInLine);
                if (maybeLeft.isAtAnyOf(LEFTS)) {
                    IndentCalculator it;
                    if (OCLineIndentProvider.isAlignCollectionStarter(commonSettings, maybeLeft) && (it = this.getAlignIndentCalculator(project2, editor, document2, maybeLeft)) != null) {
                        return it;
                    }
                    return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
        }
        if ((maybeLineStarter = OCLineIndentProvider.getLineStarterBeforeFirstStringOnLine(pos)) != null) {
            return this.getAlignWithPrevLiteralIndent(project2, editor, document2, maybeLineStarter.before());
        }
        context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(pos.copy());
        if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
            if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                return this.createInBlockSpaceIndentCalculator(project2, editor, customSettings.INDENT_VISIBILITY_KEYWORDS);
            }
            if (options != null) {
                SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore(((SemanticEditorPosition)context.first).before());
                if (element != null) {
                    return new IndentCalculator(project2, editor, STRONG_LINE_BEFORE, OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonSettings.INDENT_CASE_FROM_SWITCH && element == OCSElement.Switch ? Indent.Type.NORMAL : Indent.Type.NONE)));
                }
                if (OCLineIndentProvider.isSwitchContext(context)) {
                    return this.createInBlockSpaceIndentCalculator(project2, editor, commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0);
                }
                return options.LABEL_INDENT_ABSOLUTE ? this.createAbsoluteSpaceIndentCalculator(project2, editor, options.LABEL_INDENT_SIZE) : this.createInBlockSpaceIndentCalculator(project2, editor, options.INDENT_SIZE + options.LABEL_INDENT_SIZE);
            }
        }
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(pos)) ? null : myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    private static boolean isAlignCollectionStarter(@NotNull CommonCodeStyleSettings commonSettings, @NotNull SemanticEditorPosition maybeLeft) {
        return maybeLeft.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket}) && commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION;
    }

    @Nullable
    private IndentCalculator getAlignIndentCalculator(@NotNull Project project2, @NotNull Editor editor, @NotNull Document document2, @NotNull SemanticEditorPosition anyLeftBracket) {
        HighlighterIterator it = OCLineIndentProvider.createEditorIteratorAtPosition(anyLeftBracket.after());
        OCLineIndentProvider.skipWhiteSpacesInLine(it, anyLeftBracket.getChars(), true);
        if (!it.atEnd() && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType())) {
            return this.createAbsoluteSpaceIndentCalculator(project2, editor, OCLineIndentProvider.getOffsetInLine(document2, it.getStart()));
        }
        return null;
    }

    @NotNull
    private static SemanticEditorPosition findLeftBracketInLine(@NotNull SemanticEditorPosition inSeqPos) {
        SemanticEditorPosition copy = inSeqPos.copy();
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(copy, self -> self.isAtAnyOf(LEFTS) || self.isAtMultiline());
        return copy;
    }

    @NotNull
    private static SemanticEditorPosition getLastAnchorTokenInPrevLine(@NotNull SemanticEditorPosition positionBeforeNewLine) {
        while (!positionBeforeNewLine.isAtEnd() && !positionBeforeNewLine.isAtMultiline() && positionBeforeNewLine.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            positionBeforeNewLine.moveBefore();
        }
        return positionBeforeNewLine.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) ? positionBeforeNewLine.after() : positionBeforeNewLine;
    }

    protected int getBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position.isAtEnd()) {
            return 0;
        }
        SemanticEditorPosition originalPos = position.copy();
        int originalStatementOffset = super.getBlockStatementStartOffset(position);
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Editor)position.getEditor());
        CommonCodeStyleSettings commonSettings = styleSettings.getCommonSettings((Language)OCLanguage.getInstance());
        OCCodeStyleSettings customSettings = (OCCodeStyleSettings)styleSettings.getCustomSettings(OCCodeStyleSettings.class);
        SemanticEditorPosition originalBlockAnchor = this.getPosition((Editor)position.getEditor(), originalStatementOffset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        if (originalBlockAnchor.isAtEnd() || originalBlockAnchor.before().isAtEnd() || originalPos.getStartOffset() == originalBlockAnchor.getStartOffset()) {
            return originalStatementOffset;
        }
        if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
            SemanticEditorPosition ipos = originalPos.copy();
            ipos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset());
            SemanticEditorPosition kpos = ipos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) ? ipos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}) : originalPos.copy();
            SemanticEditorPosition spos = kpos.copy();
            kpos.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, pos -> pos.getStartOffset() <= originalBlockAnchor.getStartOffset() || pos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis));
            if (kpos.after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis)) {
                while (!kpos.isAtEnd() && kpos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (kpos.before().matchesRule(LINE_STARTER)) {
                        return kpos.getStartOffset();
                    }
                    kpos.moveBefore();
                }
            } else {
                boolean beforeStruct = false;
                while (!spos.isAtEnd() && spos.getStartOffset() > originalBlockAnchor.getStartOffset()) {
                    if (spos.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        beforeStruct = true;
                    }
                    if (spos.before().matchesRule(LINE_STARTER) && beforeStruct) {
                        return spos.getStartOffset();
                    }
                    spos.moveBefore();
                }
            }
        } else if (originalBlockAnchor.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
            SemanticEditorPosition before = originalBlockAnchor.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (before.isAtEnd() || before.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace}) || before.getStartOffset() >= position.getStartOffset()) {
                return originalStatementOffset;
            }
            SemanticEditorPosition move = before.copy();
            if (move.after().isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
                move.moveAfter();
            }
            int offset = this.getBlockStatementStartOffset(move);
            SemanticEditorPosition blockAnchor = this.getPosition((Editor)position.getEditor(), offset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{OCSElement.DirectiveLike, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            int nextLineStyleAfterBrace = blockAnchor.isAtEnd() ? 4 : (blockAnchor.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike) ? commonSettings.CLASS_BRACE_STYLE : (blockAnchor.isAt((IElementType)OCTokenTypes.NAMESPACE_CPP_KEYWORD) ? customSettings.NAMESPACE_BRACE_PLACEMENT : (blockAnchor.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword}) ? commonSettings.BRACE_STYLE : customSettings.FUNCTION_BRACE_PLACEMENT)));
            return nextLineStyleAfterBrace == 4 ? originalStatementOffset : offset;
        }
        return originalStatementOffset;
    }

    @NotNull
    private IndentCalculator getAlignWithPrevLiteralIndent(@NotNull Project project2, @NotNull Editor editor, @NotNull Document document2, @NotNull SemanticEditorPosition lastTokenInLine) {
        SemanticEditorPosition maybeAt = lastTokenInLine.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        SemanticEditorPosition anchor = maybeAt.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) ? maybeAt : lastTokenInLine;
        Lexer lexer = OCLineIndentProvider.getLexerAtOffset(anchor.getStartOffset() + 1, document2.getCharsSequence());
        return this.createAbsoluteSpaceIndentCalculator(project2, editor, OCLineIndentProvider.getOffsetInLine(document2, lexer.getTokenStart()));
    }

    public static boolean setCanUseFormatterForIndent(boolean suggest) {
        boolean oldValue = ourCanUseFormatterForIndent;
        ourCanUseFormatterForIndent = suggest;
        return oldValue;
    }

    private static boolean canUseFormatterForIndentProcessing(@Nullable OCLanguageKind kind) {
        if (kind == null || kind.isObjC()) {
            return !Registry.is((String)"cidr.indent.lexer.only.objc");
        }
        return ourCanUseFormatterForIndent && !Registry.is((String)"cidr.indent.lexer.only.cpp");
    }

    private static int getOffsetInLine(@NotNull Document document2, int start) {
        return start - document2.getLineStartOffset(document2.getLineNumber(start));
    }

    private static boolean isLikeFunctionDecl(@NotNull SemanticEditorPosition maybeFuncStart) {
        if (maybeFuncStart.isAtEnd()) {
            return false;
        }
        CharSequence chars = maybeFuncStart.getChars();
        HighlighterIterator position = OCLineIndentProvider.createEditorIteratorAtPosition(maybeFuncStart);
        while (!position.atEnd() && !OCLineIndentProvider.containsNewLine(chars, position.getStart(), position.getEnd())) {
            IElementType type = position.getTokenType();
            if (type == OCTokenTypes.SEMICOLON || type == OCTokenTypes.RPAR) {
                return false;
            }
            if (type == OCTokenTypes.LPAR) {
                return true;
            }
            position.advance();
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getColonOrSwitchInNonBlockSwitchOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Colon, OCSElement.Switch});
    }

    private static boolean isEqLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.EqualLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma}) == OCSElement.EqualLike;
    }

    private static boolean isTemplateLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{OCSElement.TemplateLike, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}) == OCSElement.TemplateLike;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getElementsOnLineBefore(@NotNull SemanticEditorPosition pos, SemanticEditorPosition.SyntaxElement ... syntaxElements) {
        SemanticEditorPosition position = pos.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        OCLineIndentProvider.moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(position, self -> self.isAtAnyOf(syntaxElements) || self.isAtMultiline());
        return position.isAtAnyOf(syntaxElements) ? position.getCurrElement() : null;
    }

    private static void moveToLeftInBlockParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SemanticEditorPosition pos, @NotNull Predicate<SemanticEditorPosition> terminationCondition) {
        block0: while (!pos.isAtEnd() && !terminationCondition.test(pos)) {
            for (int i = 0; i < LEFTS.length; ++i) {
                if (!pos.isAt(RIGHTS[i])) continue;
                pos.moveBeforeParentheses(LEFTS[i], RIGHTS[i]);
                continue block0;
            }
            if (pos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) break;
            pos.moveBefore();
        }
    }

    @NotNull
    private IndentCalculator createInBlockSpaceIndentCalculator(@NotNull Project project2, @NotNull Editor editor, int spaces) {
        return new IndentCalculator(project2, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false));
    }

    @NotNull
    private IndentCalculator createAbsoluteSpaceIndentCalculator(@NotNull Project project2, @NotNull Editor editor, int spaces) {
        return new IndentCalculator(project2, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false)){

            @NotNull
            protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
                return "";
            }
        };
    }

    @NotNull
    public static Lexer getLexerAtOffset(int offset, CharSequence text) {
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault();
        lexer.start(text);
        while (lexer.getTokenEnd() < offset) {
            lexer.advance();
        }
        return lexer;
    }

    @Nullable
    public static SemanticEditorPosition getLineStarterBeforeFirstStringOnLine(@NotNull SemanticEditorPosition pos) {
        SemanticEditorPosition maybeLineStarter = pos.before().beforeOptional((SemanticEditorPosition.SyntaxElement)OCSElement.At);
        return pos.isAt((IElementType)OCTokenTypes.STRING_LITERAL) && maybeLineStarter.matchesRule(LINE_STARTER) && maybeLineStarter.before().isAt((IElementType)OCTokenTypes.STRING_LITERAL) ? maybeLineStarter : null;
    }

    public int getJoinedLinesSpacing(@NotNull Project project2, @NotNull Editor editor, Language language, int offset) {
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(this.getPosition(editor, offset))) ? -1 : 0;
    }

    static {
        SYNTAX_MAP.put((Object)TokenType.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put((Object)OCTokenTypes.SEMICOLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put((Object)OCTokenTypes.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put((Object)OCTokenTypes.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put((Object)OCTokenTypes.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put((Object)OCTokenTypes.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put((Object)OCTokenTypes.RPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put((Object)OCTokenTypes.LPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put((Object)OCTokenTypes.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put((Object)OCTokenTypes.CASE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put((Object)OCTokenTypes.DEFAULT_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put((Object)OCTokenTypes.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.WHILE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.CATCH_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.BLOCK_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put((Object)OCTokenTypes.LT, (Object)OCSElement.Lt);
        SYNTAX_MAP.put((Object)OCTokenTypes.EOL_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.TRY_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.STRUCT_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.CLASS_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.ENUM_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.UNION_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.IDENTIFIER, (Object)OCSElement.Identifier);
        SYNTAX_MAP.put((Object)OCTokenTypes.RETURN_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.BREAK_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.CONTINUE_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PUBLIC_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PROTECTED_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PRIVATE_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.EOL_ESCAPE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.TYPEDEF_KEYWORD, (Object)OCSElement.Typedef);
        SYNTAX_MAP.put((Object)OCTokenTypes.SWITCH_KEYWORD, (Object)OCSElement.Switch);
        for (IElementType type : OCTokenTypes.ASSIGNMENT_OPERATIONS.getTypes()) {
            SYNTAX_MAP.put((Object)type, (Object)OCSElement.EqualLike);
        }
        for (IElementType type : OCFormatterUtil.FORMAT_DIRECTIVES.getTypes()) {
            SYNTAX_MAP.put((Object)type, (Object)OCSElement.DirectiveLike);
        }
        SYNTAX_MAP.put((Object)OCTokenTypes.TEMPLATE_CPP_KEYWORD, (Object)OCSElement.TemplateLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.AT, (Object)OCSElement.At);
        LINE_STARTER = position -> position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && position.isAtMultiline();
        ourCanUseFormatterForIndent = !ApplicationManager.getApplication().isUnitTestMode();
        LEFTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis};
        RIGHTS = new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis};
        STRONG_LINE_BEFORE = new IndentCalculator.BaseLineOffsetCalculator(){

            public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
                DocumentEx document2 = currPosition.getEditor().getDocument();
                int lineNo = document2.getLineNumber(currPosition.getStartOffset());
                return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)document2.getLineEndOffset(lineNo == 0 ? 0 : lineNo - 1), (String)" \t\n\r");
            }
        };
    }

    public static enum OCSElement implements SemanticEditorPosition.SyntaxElement
    {
        StructLike,
        ReturnLike,
        DirectiveLike,
        Identifier,
        PublicLike,
        EqualLike,
        At,
        Lt,
        TemplateLike,
        Switch,
        Typedef;

    }
}

