/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCAsyncParamInfoModel;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCSyncParameterInfoHandler;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.SignatureInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.impl.OCAsyncParamInfoResult;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCMacroParameterInfoHandler
implements OCSyncParameterInfoHandler {
    private SmartPsiElementPointer<OCMacroCall> myElement = null;
    private OCMacroSymbol myMacro = null;

    @Override
    public boolean init(Project project2, PsiFile file, int offset) {
        OCMacroCall call = OCMacroParameterInfoHandler.findMacroCall(file, offset);
        if (call == null) {
            return false;
        }
        List<OCMacroCallArgument> arguments = call.getArguments();
        if (arguments.isEmpty()) {
            return false;
        }
        this.myElement = SmartPointerManager.createPointer((PsiElement)call);
        this.myMacro = call.resolveToSymbol();
        if (this.myMacro == null) {
            OCLog.LOG.error("can't resolve macro for '" + call.getText() + "'", new Attachment[]{new Attachment("file.mm", call.getContainingFile().getText())});
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public OCAsyncParamInfoModel.Result calculate(int offset) {
        OCMacroCall call = (OCMacroCall)this.myElement.getElement();
        if (call == null || !call.getTextRange().contains(offset)) {
            return null;
        }
        int index = OCMacroParameterInfoHandler.getCurrentParameterIndex(offset, call);
        OCMacroCall.ParameterCheckResult result = call.checkParameters(this.myMacro);
        SignatureInfo info = this.getInfo(index, result.getActualCount() <= result.getAllowedCount(), this.myMacro);
        return new OCAsyncParamInfoResult(offset, Collections.singletonList(info));
    }

    @Nullable
    private static OCMacroCall findMacroCall(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        while (element != null && !(element instanceof OCMacroCall)) {
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        OCMacroCall macroCall = (OCMacroCall)element;
        OCReferenceElement re = macroCall.getMacroReferenceElement();
        return re == null || re.getRangeWithMacros().containsOffset(offset) ? null : macroCall;
    }

    private static int getCurrentParameterIndex(int offset, OCMacroCall call) {
        int index = 0;
        for (ASTNode child = call.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        return index;
    }

    private SignatureInfo getInfo(int currentParameterIndex, boolean isEnabled, OCMacroSymbol symbol) {
        StringBuilder buffer = new StringBuilder();
        List<String> paramNames = symbol.getUserFriendlyParameterNames();
        int paramCount = paramNames.size();
        int currentParameter = Math.min(currentParameterIndex, paramCount - 1);
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramCount == 0) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            for (int j = 0; j < paramCount; ++j) {
                int startOffset = buffer.length();
                buffer.append(paramNames.get(j));
                int endOffset = buffer.length();
                if (j < paramCount - 1) {
                    buffer.append(", ");
                }
                if (j != currentParameter || !isEnabled) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new SignatureInfo(buffer.toString(), highlightStartOffset, highlightEndOffset, !isEnabled, false, false, null);
    }
}

