/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCAsyncParamInfoModel;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.OCSyncParameterInfoHandler;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.SignatureInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.async.impl.OCAsyncParamInfoResult;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodParameterInfoHandler
implements OCSyncParameterInfoHandler {
    private SmartPsiElementPointer<OCSendMessageExpression> myElement = null;
    private List<OCMethodSymbol> myResponders = null;

    @Override
    public boolean init(Project project2, PsiFile file, int offset) {
        OCSendMessageExpression callExpression = OCMethodParameterInfoHandler.findArgList(file, offset);
        if (callExpression == null) {
            return false;
        }
        this.myElement = SmartPointerManager.createPointer((PsiElement)callExpression);
        this.myResponders = callExpression.getProbableResponders().getFilteredByStaticnessResponders();
        return !this.myResponders.isEmpty();
    }

    @Override
    @Nullable
    public OCAsyncParamInfoModel.Result calculate(int offset) {
        OCSendMessageExpression call = (OCSendMessageExpression)this.myElement.getElement();
        if (call == null || !call.getTextRange().contains(offset)) {
            return null;
        }
        int index = OCMethodParameterInfoHandler.getCurrentParameterIndex(call, offset);
        List<SignatureInfo> signatures = this.myResponders.stream().map(it -> OCMethodParameterInfoHandler.getInfo(it, index, it.getSelectors().size() >= index)).collect(Collectors.toList());
        return new OCAsyncParamInfoResult(offset, signatures);
    }

    @Nullable
    private static OCSendMessageExpression findArgList(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        while (element != null) {
            if (element instanceof OCSendMessageExpression && element.getTextRange().getStartOffset() < offset) {
                return (OCSendMessageExpression)element;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    private static int getCurrentParameterIndex(@NotNull OCSendMessageExpression parameterOwner, int offset) {
        int index = -1;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCElementTypes.MESSAGE_ARGUMENT) {
                ++index;
                if (child.getTextRange().contains(offset)) break;
            }
            if (child.getStartOffset() >= offset) break;
        }
        return index;
    }

    private static SignatureInfo getInfo(OCMethodSymbol p, int currentParameter, boolean isEnabled) {
        StringBuilder buffer = new StringBuilder();
        List<OCMethodSymbol.SelectorPartSymbol> parms = p.getSelectors();
        int numParams = parms.size();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams == 0 || numParams == 1 && parms.get(0).getParameter() == null) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            for (int j = 0; j < numParams; ++j) {
                OCMethodSymbol.SelectorPartSymbol parm = parms.get(j);
                int startOffset = buffer.length();
                buffer.append(parm.getSelectorName());
                OCDeclaratorSymbol param = parm.getParameter();
                if (param != null) {
                    buffer.append('(').append(param.getType().getName()).append(")");
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(" ");
                }
                if (!isEnabled || j != currentParameter) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new SignatureInfo(buffer.toString(), highlightStartOffset, highlightEndOffset, !isEnabled, false, false, null);
    }
}

