/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!(file.getLanguage() instanceof OCLanguage)) {
            return null;
        }
        boolean isLiteral = true;
        for (int i = 0; i < startOffsets.length && isLiteral; ++i) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file, startOffsets[i], endOffsets[i]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!(file.getLanguage() instanceof OCLanguage)) {
            return text;
        }
        Document document2 = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = "\\n\"\n \"";
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i == lines.length - 1) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            return OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
        }
        return text;
    }

    @Nullable
    private static IElementType findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelection = file.findElementAt(selectionStart);
        if (elementAtSelection == null) {
            return null;
        }
        if (elementAtSelection.getNode() == null) {
            OCLog.LOG.error("node is null for " + elementAtSelection + "\n\tin " + file);
            return null;
        }
        IElementType tokenType = elementAtSelection.getNode().getElementType();
        if (tokenType != OCTokenTypes.STRING_LITERAL && tokenType != OCTokenTypes.CHARACTER_LITERAL) {
            return null;
        }
        TextRange textRange = elementAtSelection.getTextRange();
        if (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return tokenType;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        return buffer.toString();
    }
}

