/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTodoIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet LEXER_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.BLOCK_COMMENT, OCTokenTypes.EOL_COMMENT});

    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file instanceof OCFile) {
            return OCLexerWithDirectives.createDefault();
        }
        return null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file instanceof OCFile) {
            return LEXER_COMMENTS;
        }
        return null;
    }

    public int getCommentStartDelta(@NotNull IElementType tokenType) {
        if (tokenType == OCTokenTypes.BLOCK_COMMENT || tokenType == OCTokenTypes.EOL_COMMENT) {
            return 2;
        }
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == OCTokenTypes.BLOCK_COMMENT ? 2 : 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        return tokenType == OCTokenTypes.BLOCK_COMMENT ? "*|" : "/";
    }
}

