/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    @Nullable
    private PsiElement myContextExpression;

    FunctionInsertHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
    }

    public static void changeQualifyingTokenIfNeeded(InsertionContext context, PsiElement contextExpression, LookupElement item) {
        if (contextExpression instanceof OCQualifiedExpression) {
            OCUsageTriggerCollector.trigger("completion.qualified");
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)contextExpression;
            OCPunctuatorElementType actualToken = qualifiedExpression.getQualifyingTokenKind();
            OCPunctuatorElementType completionToken = (OCPunctuatorElementType)((Object)OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.get((UserDataHolder)item));
            if (!qualifiedExpression.canChangeQualifyingToken() || completionToken == null || completionToken == actualToken) {
                return;
            }
            Document document2 = context.getDocument();
            OCElement qualifyingElement = qualifiedExpression.getQualifyingElement();
            TextRange range = OCElementUtil.getUserVisibleRangeInDocument(qualifyingElement);
            if (range != null) {
                OCUsageTriggerCollector.trigger("completion.qualified.changeQualifyingToken." + (actualToken == OCTokenTypes.DOT ? "fromDot" : "fromDereference"));
                document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)completionToken.getName());
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document2);
            }
        }
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (FunctionInsertHandler.isUsedAsAName(this.mySymbol, this.myContextExpression)) {
            return;
        }
        List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
        boolean hasParams = !params.isEmpty();
        CallableInsertUtils.addParensIfRequired(context, item, hasParams);
        if (hasParams && CallableInsertUtils.shouldInsertPlaceholders(context)) {
            StringBuilder insertion = new StringBuilder();
            int paramCount = params.size();
            boolean mergeLast = this.mySymbol.isVararg() && params.get(paramCount - 1).isUnnamed();
            int varargIdx = mergeLast ? paramCount - 1 : Integer.MAX_VALUE;
            int firstTemplateStart = -1;
            int firstTemplateEnd = -1;
            for (int i = 0; i < paramCount; ++i) {
                OCDeclaratorSymbol param = params.get(i);
                OCType type = param.getType();
                if (type instanceof OCVoidType) continue;
                if (i > 0) {
                    insertion.append(", ");
                }
                if (i == 0 || i < varargIdx) {
                    if (firstTemplateStart == -1) {
                        firstTemplateStart = insertion.length();
                    }
                    insertion.append("<#");
                }
                if (i == varargIdx) {
                    insertion.append("...");
                } else {
                    insertion.append(param.getType().getBestNameInContext((PsiElement)context.getFile(), OCElementUtil.getTypeTextWithModifiers(param, context.getProject())));
                    if (!param.isUnnamed()) {
                        insertion.append(' ');
                        insertion.append(param.getName());
                    }
                }
                if (i == varargIdx - 1) continue;
                insertion.append("#>");
                if (firstTemplateEnd != -1) continue;
                firstTemplateEnd = insertion.length();
            }
            context.getDocument().insertString(context.getEditor().getCaretModel().getOffset(), (CharSequence)insertion.toString());
            CallableInsertUtils.selectFirstPlaceholderIfPresent(context);
        }
        FunctionInsertHandler.changeQualifyingTokenIfNeeded(context, this.myContextExpression, item);
        if (hasParams) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    private static boolean isUsedAsAName(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement context) {
        if (context != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof OCExpression) {
                PsiElement superParent = parent.getParent();
                if (superParent instanceof OCUnaryExpression) {
                    return ((OCUnaryExpression)superParent).isGetAddress();
                }
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes((OCExpression)parent, false, resolveContext);
                for (OCType type : types) {
                    OCFunctionType ft;
                    if (!((type = type.resolve(resolveContext)) instanceof OCPointerType) || !(((OCPointerType)type).getRefType() instanceof OCFunctionType) || (ft = (OCFunctionType)((OCPointerType)type).getRefType()).checkCompatible(symbol.getResolvedType(resolveContext), null, context, resolveContext).getState() != OCTypeCheckState.OK) continue;
                    return true;
                }
            } else if (parent instanceof OCCppUsingStatement) {
                return true;
            }
        }
        return false;
    }
}

