/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.editor.completion.ConsumedTokenFinder;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    protected final OCMethodSymbol mySymbol;
    @Nullable
    private final PsiElement myContextExpression;
    @NotNull
    private final String myQualifier;
    private final boolean myInsideSendMessage;

    MethodInsertHandler(@NotNull OCMethodSymbol symbol, @Nullable PsiElement contextExpression, boolean insideSendMessage, @NotNull String qualifier) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
        this.myInsideSendMessage = insideSendMessage;
        this.myQualifier = qualifier;
    }

    @NotNull
    protected String getInsertionDeclaration(@NotNull InsertionContext context, @NotNull LookupElement item) {
        OCMethod method;
        assert (this.isInDeclarationContext());
        assert (context.getStartOffset() == context.getEditor().getCaretModel().getOffset() - item.getLookupString().length());
        assert (context.getTailOffset() == context.getEditor().getCaretModel().getOffset());
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.myQualifier);
        if (!this.myQualifier.isEmpty()) {
            insertion.append(' ');
        }
        OCElement body = null;
        if (this.myQualifier.isEmpty() && context.getCompletionChar() == '\t') {
            MethodInsertHandler.smartNormalizeNextSelector(context, item);
            method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(context.getStartOffset()), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class});
            body = method != null ? method.getBody() : null;
        }
        MethodInsertHandler.appendParameters(this.mySymbol, context, insertion, false);
        if (body != null) {
            int endOffset = body.getRangeWithMacros().getStartOffset();
            context.setTailOffset(endOffset);
        }
        if ((method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(context.getStartOffset()), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class})) != null && method.getReturnTypeElement() == null) {
            String name2 = this.mySymbol.getEffectiveType(method.getProject()).getBestNameInContext(method, OCElementUtil.getReturnTypeText(this.mySymbol, method.getProject()));
            insertion.insert(0, "(" + name2 + ")");
        }
        if (body == null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getFile(), OCCodeStyleSettings.class);
            insertion.append(settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "{ }");
        }
        return insertion.toString();
    }

    @NotNull
    protected String getInsertionCall(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean noClosingBracketMatched;
        int autoOpenOffset;
        boolean smartInsert;
        assert (!this.isInDeclarationContext());
        assert (context.getStartOffset() == context.getEditor().getCaretModel().getOffset() - item.getLookupString().length());
        assert (context.getTailOffset() == context.getEditor().getCaretModel().getOffset());
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.myQualifier);
        if (!this.myQualifier.isEmpty()) {
            insertion.append(' ');
        }
        boolean bl = smartInsert = this.myQualifier.isEmpty() && context.getCompletionChar() == '\t';
        if (smartInsert) {
            MethodInsertHandler.smartNormalizeNextSelector(context, item);
        }
        boolean insertedOpeningBracket = (autoOpenOffset = this.autoOpenBracket(context, item)) >= 0;
        boolean closingBracketNecessary = autoOpenOffset != Integer.MIN_VALUE;
        OCSendMessageExpression expr = MethodInsertHandler.getSendMessage(context.getFile(), context.getStartOffset());
        boolean isSmart = expr != null;
        boolean bl2 = noClosingBracketMatched = isSmart && expr.getNode().getLastChildNode().getElementType() != OCTokenTypes.RBRACKET;
        if (isSmart && smartInsert) {
            int endOffset;
            List<OCMessageArgument> args = expr.getArguments();
            int usedArguments = MethodInsertHandler.appendParameters(this.mySymbol, context, insertion, true, args, !noClosingBracketMatched);
            if (usedArguments < args.size()) {
                endOffset = usedArguments > 0 ? args.get(usedArguments - 1).getRangeWithMacros().getEndOffset() : MethodInsertHandler.offsetBeforeExpression(args.get(0));
                closingBracketNecessary = false;
            } else {
                endOffset = expr.getRangeWithMacros().getEndOffset();
                if (noClosingBracketMatched) {
                    closingBracketNecessary = false;
                }
            }
            insertion.append(']');
            context.setTailOffset(endOffset);
        } else {
            OCElement lastNonWsChild;
            MethodInsertHandler.appendParameters(this.mySymbol, context, insertion, true);
            if (isSmart && !noClosingBracketMatched && (lastNonWsChild = (OCElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expr.getLastChild())) != null && context.getTailOffset() < lastNonWsChild.getRangeWithMacros().getEndOffset()) {
                noClosingBracketMatched = true;
            }
        }
        if (!this.myQualifier.isEmpty() && !this.myInsideSendMessage || closingBracketNecessary && (isSmart ? noClosingBracketMatched || ConsumedTokenFinder.consumedClosingBracketOfParent(expr) : insertedOpeningBracket || !MethodInsertHandler.nextIsAClosingBracket(context.getFile(), context.getTailOffset()))) {
            insertion.append(']');
        }
        return insertion.toString();
    }

    private static void smartNormalizeNextSelector(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Document document2 = context.getDocument();
        int tailOffset = context.getTailOffset();
        if (item.getLookupString().endsWith(":")) {
            CharSequence text = document2.getImmutableCharSequence();
            for (int i = tailOffset; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == ':') {
                    tailOffset = i + 1;
                    break;
                }
                if (!Character.isSpaceChar(c)) break;
            }
            document2.replaceString(context.getStartOffset(), tailOffset, (CharSequence)"xxx:");
        } else {
            document2.replaceString(context.getStartOffset(), tailOffset, (CharSequence)"xxx");
        }
        context.commitDocument();
    }

    public static void appendParameters(@NotNull OCMethodSymbol methodSymbol, @NotNull InsertionContext context, @NotNull StringBuilder insertion, boolean template) {
        MethodInsertHandler.appendParameters(methodSymbol, context, insertion, template, Collections.emptyList(), false);
    }

    public static int appendParameters(@NotNull OCMethodSymbol methodSymbol, @NotNull InsertionContext context, @NotNull StringBuilder insertion, boolean template, @NotNull List<OCMessageArgument> args, boolean eager) {
        List<OCMethodSymbol.SelectorPartSymbol> selectors = methodSymbol.getSelectors();
        int varargIdx = methodSymbol.isVararg() ? selectors.size() - 1 : Integer.MAX_VALUE;
        int usedArgs = 0;
        boolean matchMore = true;
        int size = selectors.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                insertion.append(' ');
            }
            OCMethodSymbol.SelectorPartSymbol selector = selectors.get(i);
            insertion.append(selector.getSelectorName());
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) {
                if (usedArgs >= args.size() || args.get(usedArgs).getArgumentExpression() != null) continue;
                ++usedArgs;
                continue;
            }
            if (matchMore && usedArgs < args.size()) {
                OCExpression arg = args.get(usedArgs).getArgumentExpression();
                if (arg == null) {
                    ++usedArgs;
                } else {
                    if (eager || arg.getPrevSibling().getText().indexOf(10) < 0) {
                        insertion.append(arg.getTextWithMacros());
                        ++usedArgs;
                        continue;
                    }
                    matchMore = false;
                }
            }
            if (template) {
                insertion.append("<#");
            }
            MethodInsertHandler.appendParameterName(insertion, context.getFile(), param);
            if (i == varargIdx) {
                insertion.append(", ...");
            }
            if (!template) continue;
            insertion.append("#>");
        }
        return usedArgs;
    }

    private int autoOpenBracket(@NotNull InsertionContext context, @NotNull LookupElement item) {
        this.adjustDotSyntax(context);
        int autoOpenOffset = this.calculateAutoOpenOffset(context, item);
        if (autoOpenOffset >= 0) {
            context.getDocument().insertString(autoOpenOffset, (CharSequence)"[");
            context.commitDocument();
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), autoOpenOffset, autoOpenOffset + 2);
        }
        return autoOpenOffset;
    }

    private static int offsetBeforeExpression(@NotNull OCMessageArgument messageArgument) {
        OCArgumentSelector selector = messageArgument.getArgumentSelector();
        return selector.getRangeWithMacros().getEndOffset();
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (this.isInDeclarationContext()) {
            String insertion = this.getInsertionDeclaration(context, item);
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
            CallableInsertUtils.moveCaretToCallableBody(context);
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
        } else {
            this.handleCall(context, item);
        }
    }

    public void handleCall(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String insertion = this.getInsertionCall(context, item);
        context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        context.commitDocument();
        this.postInsertionHook(context);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context.getProject());
        foldManager.updateFoldRegions(context.getEditor());
        MethodInsertHandler.advanceTailOffsetToEndOffset(context);
        MethodInsertHandler.advanceTailOffsetOverWs(context);
        MethodInsertHandler.insertTrailingSpacing(context);
        PsiFile file = context.getFile();
        if (file instanceof OCFile && !OCFileSymbols.isSymbolImported((OCFile)file, this.mySymbol)) {
            OCImportSymbolFix.fixAfterCompletionAtOffset(context.getEditor(), file, context.getStartOffset(), this.mySymbol);
        }
        if (context.getCompletionChar() == '(' && insertion.endsWith(")") || context.getCompletionChar() == ']') {
            context.setAddCompletionChar(false);
        }
        MethodInsertHandler.reformatCall(context);
        MethodInsertHandler.moveCaretOffset(context);
    }

    private static void advanceTailOffsetToEndOffset(@NotNull InsertionContext context) {
        OCSendMessageExpression call = MethodInsertHandler.getSendMessage(context.getFile(), context.getStartOffset());
        if (call == null) {
            return;
        }
        int endOffset = call.getRangeWithMacros().getEndOffset();
        if (context.getTailOffset() < endOffset) {
            context.setTailOffset(endOffset);
        }
    }

    private static void advanceTailOffsetOverWs(@NotNull InsertionContext context) {
        char nextChar;
        int tailOffset;
        Document document2 = context.getDocument();
        CharSequence documentText = document2.getImmutableCharSequence();
        int i = tailOffset = context.getTailOffset();
        while (i < documentText.length() && Character.isSpaceChar(nextChar = documentText.charAt(i))) {
            tailOffset = i++;
        }
        context.setTailOffset(tailOffset);
    }

    private static void reformatCall(@NotNull InsertionContext context) {
        PsiFile file = context.getFile();
        PostprocessReformattingAspect.getInstance((Project)file.getProject()).doPostponedFormatting();
        Document document2 = context.getDocument();
        CharSequence documentText = document2.getImmutableCharSequence();
        int tailOffset = context.getTailOffset();
        OffsetKey nextNonWs = OffsetKey.create((String)"nonWsAfterTail", (boolean)true);
        context.getOffsetMap().addOffset(nextNonWs, CharArrayUtil.shiftForward((CharSequence)documentText, (int)tailOffset, (String)" \t\n"));
        if (context.getStartOffset() < tailOffset && tailOffset < documentText.length() && documentText.charAt(tailOffset - 1) == ';') {
            if (context.getCompletionChar() == ' ') {
                document2.insertString(tailOffset, (CharSequence)" ");
                context.commitDocument();
                context.setAddCompletionChar(false);
            }
            OCChangeUtil.reformatTextIfNotInjected(file, tailOffset, tailOffset + 1);
            context.setTailOffset(tailOffset);
        }
        OCChangeUtil.reformatTextIfNotInjected(file, context.getStartOffset(), tailOffset);
        if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            context.setTailOffset(context.getOffset(nextNonWs));
        }
    }

    private static void insertTrailingSpacing(@NotNull InsertionContext context) {
        int tailOffset = context.getTailOffset();
        if (tailOffset <= context.getStartOffset() || context.getCompletionChar() == ' ') {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context.getProject());
        int spacing = codeStyleManager.getSpacing(context.getFile(), tailOffset);
        if (spacing < 1) {
            return;
        }
        context.getDocument().insertString(tailOffset, (CharSequence)" ");
        context.commitDocument();
    }

    private static void moveCaretOffset(@NotNull InsertionContext context) {
        CharSequence documentText = context.getDocument().getImmutableCharSequence();
        int firstParamStart = StringUtil.indexOf((CharSequence)documentText, (CharSequence)"<#", (int)context.getStartOffset(), (int)context.getTailOffset());
        int firstParamEnd = firstParamStart >= 0 ? StringUtil.indexOf((CharSequence)documentText, (CharSequence)"#>", (int)firstParamStart, (int)context.getTailOffset()) : -1;
        int caretOffset = context.getTailOffset();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < caretOffset) {
            context.setAddCompletionChar(false);
            caretOffset = firstParamStart;
            context.getEditor().getSelectionModel().setSelection(caretOffset, firstParamEnd + 2);
        }
        context.getEditor().getCaretModel().moveToOffset(caretOffset);
    }

    private void adjustDotSyntax(@NotNull InsertionContext context) {
        if (!(this.myContextExpression instanceof OCQualifiedExpression)) {
            return;
        }
        if (this.mySymbol.isGetter(OCResolveContext.forPsi((PsiElement)context.getFile())) && context.getCompletionChar() != ']') {
            return;
        }
        TextRange range = ((OCQualifiedExpression)this.myContextExpression).getQualifyingToken().getTextRange();
        context.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)" ");
    }

    private int calculateAutoOpenOffset(@NotNull InsertionContext context, @NotNull LookupElement item) {
        PsiElement prev;
        Document document2 = context.getDocument();
        PsiFile file = context.getFile();
        MethodSelectorCompletionContributor.Context completionCtx = (MethodSelectorCompletionContributor.Context)MethodSelectorCompletionContributor.CONTEXT.get((UserDataHolder)item);
        PsiElement originalReceiver = completionCtx == null ? null : completionCtx.getReceiver();
        int autoOpenOffset = -1;
        if (this.myContextExpression instanceof OCQualifiedExpression) {
            if (this.mySymbol.isGetter(OCResolveContext.forPsi((PsiElement)file)) && context.getCompletionChar() != ']') {
                return Integer.MIN_VALUE;
            }
            autoOpenOffset = this.myContextExpression.getTextRange().getStartOffset();
        } else if (originalReceiver != null && ((prev = OCElementUtil.getPrevSignificantSibling(originalReceiver)) == null || prev.getNode().getElementType() != OCTokenTypes.LBRACKET || prev.getParent() instanceof OCNSArrayLiteral)) {
            OCElement receiver;
            TextRange originalRange = originalReceiver.getTextRange();
            CharSequence docText = document2.getImmutableCharSequence();
            int nonWs = CharArrayUtil.shiftBackward((CharSequence)docText, (int)(context.getStartOffset() - 1), (String)" \t\n");
            Class stopAt = originalReceiver instanceof OCBlockExpression ? OCCallable.class : OCBlockStatement.class;
            for (receiver = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file, (int)nonWs, OCExpression.class, (boolean)false, (Class[])new Class[]{stopAt}); !originalRange.isEmpty() && receiver != null && receiver.getParent() instanceof OCExpression && receiver.getTextRange().getLength() < originalRange.getLength(); receiver = (OCExpression)receiver.getParent()) {
            }
            if (receiver == null) {
                receiver = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file, (int)nonWs, OCMacroCall.class, (boolean)false, (Class[])new Class[]{stopAt});
            }
            if (receiver != null) {
                autoOpenOffset = receiver.getTextRange().getStartOffset();
            } else {
                OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file, (int)nonWs, OCTypeElement.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
                if (typeElement != null) {
                    autoOpenOffset = typeElement.getTextRange().getStartOffset();
                }
            }
        }
        return autoOpenOffset;
    }

    protected void postInsertionHook(@NotNull InsertionContext context) {
        Document document2 = context.getDocument();
        PsiFile file = context.getFile();
        OCSendMessageExpression call = (OCSendMessageExpression)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file, (int)context.getStartOffset(), OCSendMessageExpression.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
        if (call != null && this.mySymbol.getReturnType(context.getProject()).isVoid() && call.getParent() instanceof OCExpressionStatement) {
            OCExpressionStatement st = (OCExpressionStatement)call.getParent();
            if (st.getNode().getLastChildNode().getElementType() == OCTokenTypes.SEMICOLON) {
                return;
            }
            int endOffset = call.getTextRange().getEndOffset();
            document2.insertString(endOffset, (CharSequence)";");
            context.setTailOffset(++endOffset);
        }
    }

    private static boolean nextIsAClosingBracket(@NotNull PsiFile file, int offset) {
        PsiElement next;
        for (next = file.findElementAt(offset); next != null && OCTokenTypes.WHITESPACES.contains(next.getNode().getElementType()); next = next.getNextSibling()) {
        }
        return next != null && next.getNode().getElementType() == OCTokenTypes.RBRACKET;
    }

    private boolean isInDeclarationContext() {
        if (this.myContextExpression == null) {
            return false;
        }
        PsiElement parent = this.myContextExpression.getParent();
        return parent instanceof OCMethodSelectorPart && parent.getParent() instanceof OCMethod;
    }

    @Nullable
    protected static OCSendMessageExpression getSendMessage(@NotNull PsiFile file, int offset) {
        return (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), OCSendMessageExpression.class, (boolean)true, (Class[])new Class[]{OCCallable.class, OCQualifiedExpression.class});
    }

    protected static void appendParameterName(@NotNull StringBuilder insertion, @NotNull PsiFile file, @NotNull OCDeclaratorSymbol p) {
        insertion.append("(").append(p.getType().getBestNameInContext((PsiElement)file, OCElementUtil.getTypeTextWithModifiers(p, file.getProject()))).append(')');
        if (!p.isUnnamed()) {
            insertion.append(p.getName());
        }
    }

    @NotNull
    private static String debug(@NotNull InsertionContext context, @Nullable PsiElement expr) {
        Document document2 = context.getDocument();
        CaretModel caretModel = context.getEditor().getCaretModel();
        int caretOffset = caretModel.getOffset();
        TextRange exprRange = expr != null ? (expr instanceof OCElement ? ((OCElement)expr).getRangeWithMacros() : expr.getTextRange()) : null;
        int exprStart = exprRange != null ? exprRange.getStartOffset() : Integer.MIN_VALUE;
        int exprEnd = exprRange != null && exprStart != exprRange.getEndOffset() ? exprRange.getEndOffset() : Integer.MIN_VALUE;
        OCStatement statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, OCStatement.class);
        TextRange statementRange = statement2 != null ? statement2.getRangeWithMacros() : null;
        int statementStart = statementRange != null ? statementRange.getStartOffset() : Integer.MIN_VALUE;
        int statementEnd = statementRange != null ? statementRange.getEndOffset() : Integer.MIN_VALUE;
        OCStatement nextStatement = (OCStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, OCStatement.class);
        TextRange nextStatementRange = nextStatement != null ? nextStatement.getRangeWithMacros() : null;
        int nextStatementStart = nextStatementRange != null ? nextStatementRange.getStartOffset() : Integer.MIN_VALUE;
        ContainerUtil.KeyOrderedMultiMap markers = new ContainerUtil.KeyOrderedMultiMap();
        markers.putValue((Object)exprStart, (Object)"<expr>");
        markers.putValue((Object)exprEnd, (Object)"</expr>");
        markers.putValue((Object)statementStart, (Object)"<statement>");
        markers.putValue((Object)statementEnd, (Object)"</statement>");
        markers.putValue((Object)nextStatementStart, (Object)"<nextStatement>");
        markers.putValue((Object)caretOffset, (Object)"<caret>");
        for (OffsetKey offset2 : context.getOffsetMap().getAllOffsets()) {
            markers.putValue((Object)context.getOffset(offset2), (Object)("<" + StringUtil.trimEnd((String)offset2.toString(), (String)"Offset") + ">"));
        }
        NavigableSet<Integer> markerOffsets = markers.navigableKeySet().descendingSet();
        CharSequence text = document2.getImmutableCharSequence();
        int startLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)(markerOffsets.lower(Integer.MIN_VALUE) + 1)) - 1;
        int endLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)((Integer)markerOffsets.first() - 1)) + 2;
        int start = StringUtil.lineColToOffset((CharSequence)text, (int)startLine, (int)0);
        int end = StringUtil.lineColToOffset((CharSequence)text, (int)endLine, (int)0) - 1;
        if (start < 0 || text.length() < start) {
            start = 0;
        }
        if (end < 0 || text.length() < end) {
            end = text.length();
        }
        StringBuilder extract = new StringBuilder(text.subSequence(start, end));
        int extractStart = start;
        markerOffsets.forEach(offset -> {
            if (offset >= extractStart) {
                markers.get(offset).forEach(marker -> extract.insert(offset - extractStart, (String)marker));
            }
        });
        return extract.toString();
    }
}

