/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.lang.Language;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.completion.OCNewExpressionCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAvailabilityExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionAssociation;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCImportModuleStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCObjCErrorKeywordImpl;
import org.jetbrains.annotations.NotNull;

public class OCCompletionPatterns {
    public static final PsiElementPattern.Capture<PsiElement> ELEMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)OCLanguage.getInstance());
    public static final ElementPattern<PsiElement> TOP_LEVEL = OCCompletionPatterns.like(OCFile.class);
    public static final PsiElementPattern.Capture<PsiElement> TOP_LEVEL_ELEMENT = (PsiElementPattern.Capture)ELEMENT.withParent(TOP_LEVEL);
    public static final PsiElementPattern.Capture<PsiElement> REFERENCE_ELEMENT = (PsiElementPattern.Capture)ELEMENT.withParent(OCReferenceElement.class);
    public static final PsiElementPattern.Capture<PsiElement> LITERAL_EXPRESSION = (PsiElementPattern.Capture)ELEMENT.withParent(OCLiteralExpression.class);
    public static final PatternCondition<PsiElement> CPP_ELEMENT_PATTERN = new PatternCondition<PsiElement>("CPP_ELEMENT"){

        public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
            PsiFile file = psiElement.getContainingFile().getOriginalFile();
            return file instanceof OCFile && ((OCFile)file).getKind().isCpp();
        }
    };
    public static final PatternCondition<PsiElement> C_OR_OBJC_ELEMENT_PATTERN = new PatternCondition<PsiElement>("C_OBJC_ELEMENT"){

        public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
            PsiFile file = psiElement.getContainingFile().getOriginalFile();
            return file instanceof OCFile && (((OCFile)file).getKind() == CLanguageKind.C || ((OCFile)file).getKind() == CLanguageKind.OBJ_C);
        }
    };
    public static final PatternCondition<PsiElement> OBJC_ELEMENT_PATTERN = new PatternCondition<PsiElement>("OBJC_ELEMENT"){

        public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
            PsiFile file = psiElement.getContainingFile().getOriginalFile();
            return file instanceof OCFile && ((OCFile)file).getKind().isObjC();
        }
    };
    private static final PsiElementPattern.Capture<OCTypeElement> TYPE_DECLARATION = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCTypeElement.class).withChild((ElementPattern)PlatformPatterns.psiElement((IElementType)OCElementTypes.EMPTY_NAME));
    public static final PsiElementPattern.Capture<PsiElement> TILDE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("~");
    public static final PsiElementPattern.Capture<PsiElement> AFTER_TILDE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(TILDE);
    public static final PsiElementPattern.Capture<PsiElement> WITH_QUALIFIER = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeafSkipping(TILDE, (ElementPattern)PlatformPatterns.psiElement().withText("::"));
    public static final PsiElementPattern.Capture<PsiElement> AFTER_DOT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText((ElementPattern)StandardPatterns.string().endsWith(".")));
    public static final PsiElementPattern.Capture<PsiElement> AT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText((ElementPattern)StandardPatterns.string().endsWith("@"));
    public static final PsiElementPattern.Capture<PsiElement> WHITESPACES_AND_COMMENTS = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
    public static final PsiElementPattern.Capture<PsiElement> OBJC_ERROR_KEYWORD = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().with(OBJC_ELEMENT_PATTERN)).afterLeafSkipping(WHITESPACES_AND_COMMENTS, AT)).withParent(OCObjCErrorKeywordImpl.class);
    public static final PsiElementPattern.Capture<PsiElement> OC_ELEMENT_CAPTURE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)OCLanguage.getInstance())).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"::"}))).andNot(AFTER_DOT);
    public static final PsiElementPattern.Capture<PsiElement> AT_EXPRESSION_LEVEL = (PsiElementPattern.Capture)OC_ELEMENT_CAPTURE.withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)OCElementTypes.REFERENCE_ELEMENT).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)OCElementTypes.REFERENCE_EXPRESSION)));
    public static final PsiElementPattern.Capture<PsiElement> TYPE_IN_CAST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(OCReferenceElement.class)).withSuperParent(2, OCTypeElement.class)).withSuperParent(3, OCCastExpression.class), AT_EXPRESSION_LEVEL.withSuperParent(3, OCParenthesizedExpression.class)});
    public static final PsiElementPattern.Capture<PsiElement> TYPE_IN_DECLARATION = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, OCTypeElement.class)).andNot(TYPE_IN_CAST), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, OCReferenceExpression.class)).withSuperParent(3, OCExpressionStatement.class), PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(OCDeclarator.class).afterSibling(TYPE_DECLARATION)), PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(OCArgumentList.class).withParent(OCDeclarator.class))), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, OCReferenceExpression.class)).withSuperParent(3, OCTemplateArgumentList.class)).andNot(WITH_QUALIFIER)).andNot(AFTER_DOT)})).andNot(OCNewExpressionCompletionContributor.TYPE_IN_NEW_EXPRESSION);
    public static final PsiElementPattern.Capture<PsiElement> SIMPLE_TYPE_IN_DECLARATION = (PsiElementPattern.Capture)((PsiElementPattern.Capture)TYPE_IN_DECLARATION.andNot(WITH_QUALIFIER)).andNot(AFTER_DOT);
    public static final PsiElementPattern.Capture<PsiElement> SIMPLE_TYPE_IN_CAST = (PsiElementPattern.Capture)((PsiElementPattern.Capture)TYPE_IN_CAST.andNot(WITH_QUALIFIER)).andNot(AFTER_DOT);
    public static final PsiElementPattern.Capture<PsiElement> SIMPLE_TYPE_IN_TOP_LEVEL_DECLARATION = OCCompletionPatterns.typeInDeclarationAt(TOP_LEVEL);
    public static final PsiElementPattern.Capture<PsiElement> SIMPLE_TYPE_IN_NON_BLOCK_DECLARATION = OCCompletionPatterns.typeInDeclarationAt((ElementPattern<PsiElement>)StandardPatterns.or((ElementPattern[])new ElementPattern[]{TOP_LEVEL, OCCompletionPatterns.like(OCStructLike.class), OCCompletionPatterns.like(OCCppNamespace.class)}));
    public static final PsiElementPattern.Capture<PsiElement> SIMPLE_TYPE_IN_NAMESPACE_DECLARATION = OCCompletionPatterns.typeInDeclarationAt(OCCompletionPatterns.like(OCCppNamespace.class));
    public static final PsiElementPattern.Capture<PsiElement> IDENTIFIER = PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER);
    public static final PsiElementPattern.Capture<PsiElement> NAME_IN_DECLARATION = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)IDENTIFIER.andNot(WITH_QUALIFIER)).withParent(OCDeclarator.class)).andNot(TYPE_IN_DECLARATION);
    public static final PsiElementPattern.Capture<PsiElement> NAME_IN_CLASS_DECLARATION = (PsiElementPattern.Capture)IDENTIFIER.withParent(OCClassDeclaration.class);
    public static final PsiElementPattern.Capture<OCTypeElement> DECLARATION_IN_DECLARATION_STATEMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCTypeElement.class).withSuperParent(2, OCDeclarationStatement.class);
    public static final PsiElementPattern.Capture<OCReferenceExpression> REFERENCE_EXPRESSION_IN_EXPRESSION_STATEMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCReferenceExpression.class).withParent(OCExpressionStatement.class);
    public static final PsiElementPattern.Capture<PsiElement> AT_STATEMENT_LEVEL = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OC_ELEMENT_CAPTURE.inside(OCBlockStatement.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)OCElementTypes.REFERENCE_ELEMENT).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{DECLARATION_IN_DECLARATION_STATEMENT, REFERENCE_EXPRESSION_IN_EXPRESSION_STATEMENT}))), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PsiErrorElement.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, OCMessageArgument.class))});
    public static final PsiElementPattern.Capture<PsiElement> AT_ANY_PROPERTY_ATTRIBUTE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OC_ELEMENT_CAPTURE.withParent(OCCompletionPatterns.like(OCPropertyAttribute.class))).andNot((ElementPattern)OC_ELEMENT_CAPTURE.afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("=")));
    public static final PsiElementPattern.Capture<PsiElement> AT_PROPERTY_ATTRIBUTE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OC_ELEMENT_CAPTURE.withSuperParent(3, OCProperty.class)).and(AT_ANY_PROPERTY_ATTRIBUTE);
    public static final PsiElementPattern.Capture<PsiElement> IN_STRUCT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)SIMPLE_TYPE_IN_DECLARATION.inside(OCStructLike.class)).andNot(AT_STATEMENT_LEVEL);
    public static final PsiElementPattern.Capture<PsiElement> IN_CPP_STRUCT = (PsiElementPattern.Capture)IN_STRUCT.with(CPP_ELEMENT_PATTERN);
    public static final PsiElementPattern.Capture<PsiElement> IN_CPP_NAMESPACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)SIMPLE_TYPE_IN_DECLARATION.with(CPP_ELEMENT_PATTERN)).withSuperParent(3, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(OCCppNamespace.class), PlatformPatterns.psiElement(OCFile.class)}));
    public static final PsiElementPattern.Capture<PsiElement> IN_LOOP = (PsiElementPattern.Capture)AT_STATEMENT_LEVEL.inside(OCLoopStatement.class);
    public static final PsiElementPattern.Capture<PsiElement> IN_FOR = (PsiElementPattern.Capture)((PsiElementPattern.Capture)OC_ELEMENT_CAPTURE.withSuperParent(3, OCCondition.class)).withSuperParent(4, OCForStatement.class);
    public static final PsiElementPattern.Capture<PsiElement> IN_SWITCH = (PsiElementPattern.Capture)AT_STATEMENT_LEVEL.inside(OCSwitchStatement.class);
    public static final PsiElementPattern.Capture<PsiElement> IN_GENERIC_ASSOCIATION = (PsiElementPattern.Capture)((PsiElementPattern.Capture)ELEMENT.inside(OCGenericSelectionAssociation.class)).inside(OCTypeElement.class);
    public static final PsiElementPattern.Capture<PsiElement> IN_AVAILABILITY_EXPRESSION = (PsiElementPattern.Capture)ELEMENT.inside(OCAvailabilityExpression.class);
    public static final ElementPattern<PsiElement> ELSE_POSITION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("}")).withSuperParent(2, OCIfStatement.class)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(";")).withSuperParent(1, OCIfStatement.class)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(";")).withSuperParent(2, OCIfStatement.class)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(";")).withSuperParent(3, OCIfStatement.class))});
    public static final PsiElementPattern.Capture<PsiElement> AT_CLASS_FUNCTION_BODY_PLACEHOLDER = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(4, (ElementPattern)PlatformPatterns.psiElement(OCFunctionDeclaration.class).withParent(OCStruct.class))).afterLeafSkipping(WHITESPACES_AND_COMMENTS, (ElementPattern)PlatformPatterns.psiElement((IElementType)OCTokenTypes.EQ));
    public static final PsiElementPattern.Capture<PsiElement> AT_IMPORT_MODULE_STATEMENT = (PsiElementPattern.Capture)ELEMENT.withParent(OCImportModuleStatementImpl.class);

    private static PsiElementPattern.Capture<PsiElement> typeInDeclarationAt(ElementPattern<PsiElement> place) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCTypeElement.class).withSuperParent(2, place)), PlatformPatterns.psiElement().withParent((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(OCDeclarator.class).afterSibling(TYPE_DECLARATION)).withSuperParent(2, place))})).andNot(WITH_QUALIFIER)).andNot(AFTER_DOT);
    }

    public static PsiElementPattern.Capture<PsiElement> afterTry(final boolean isCpp) {
        PsiElementPattern.Capture tryCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCTryStatement.class).with((PatternCondition)new PatternCondition<OCTryStatement>("fromLanguage"){

            public boolean accepts(@NotNull OCTryStatement statement2, ProcessingContext context) {
                return statement2.isCppStatement() == isCpp;
            }
        });
        PsiElementPattern.Capture catchCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(OCCatchSection.class).with((PatternCondition)new PatternCondition<OCCatchSection>("fromLanguage"){

            public boolean accepts(@NotNull OCCatchSection section, ProcessingContext context) {
                return section.isCppStatement() == isCpp;
            }
        });
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("}")).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{tryCapture, catchCapture})));
    }

    public static ElementPattern<PsiElement> like(Class<? extends PsiElement> type) {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(type), PlatformPatterns.psiElement(PsiErrorElement.class).withParent(type)});
    }

    private OCCompletionPatterns() {
    }
}

