/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import org.jetbrains.annotations.NotNull;

public enum OCCompletionPriority {
    HIGHEST_PRIORITY(1000.0f),
    HIGH_KEYWORDS_PRIORITY(150.0f),
    HIGH_PRIORITY4(140.0f),
    HIGH_PRIORITY3(130.0f),
    HIGH_PRIORITY2(120.0f),
    HIGH_PRIORITY1(110.0f),
    HIGH_SMART_COMPLETION_PRIORITY(107.0f),
    SMART_COMPLETION_PRIORITY(105.0f),
    HIGH_PRIORITY(100.0f),
    NORMAL_PRIORITY(50.0f),
    LOW_PRIORITY2(20.0f),
    LOW_PRIORITY1(10.0f),
    LOW_PRIORITY0(5.0f),
    NORMAL_KEYWORDS_PRIORITY(-10.0f),
    LOW_KEYWORDS_PRIORITY(-15.0f);

    private final float myValue;

    private OCCompletionPriority(float value) {
        this.myValue = value;
    }

    public static LookupElement elementWithPriority(LookupElement element, OCCompletionPriority priority) {
        return OCCompletionPriority.elementWithPriority(element, priority, false);
    }

    private static LookupElement elementWithPriority(LookupElement element, OCCompletionPriority priority, boolean makeBold) {
        if (makeBold && element instanceof LookupElementBuilder) {
            element = ((LookupElementBuilder)element).bold();
        }
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority.myValue);
    }

    public static LookupElement keywordWithPriority(String keyword, OCCompletionPriority priority) {
        return OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)keyword), priority, true);
    }

    public static LookupElement keywordWithPriority(LookupElement keyword, OCCompletionPriority priority) {
        return OCCompletionPriority.elementWithPriority(keyword, priority, true);
    }

    public float getValue() {
        return this.myValue;
    }

    public static OCCompletionPriority getPriority(OCSymbol symbol, @NotNull Project project2) {
        String name2;
        OCSymbolKind kind = symbol.getKind();
        if (kind.isLocal() || kind == OCSymbolKind.MACRO_PARAMETER) {
            return symbol instanceof OCThisSelfSuperSymbol ? NORMAL_PRIORITY : HIGH_PRIORITY4;
        }
        if (kind == OCSymbolKind.MACRO && ("nil".equals(name2 = symbol.getName()) || "null".equals(name2) || "YES".equals(name2) || "NO".equals(name2))) {
            return HIGH_PRIORITY3;
        }
        if (kind.isTemplateParameter()) {
            return HIGH_PRIORITY3;
        }
        if (kind == OCSymbolKind.INSTANCE_VARIABLE || kind == OCSymbolKind.PROPERTY || kind == OCSymbolKind.STRUCT_FIELD) {
            return HIGH_PRIORITY1;
        }
        if (kind.isConstructorOrDestructor()) {
            return LOW_PRIORITY1;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(OCResolveContext.forSymbol(symbol, project2)) instanceof OCStructSymbol) {
            return HIGH_PRIORITY1;
        }
        if (kind.isStructLike() && symbol.isPredeclaration()) {
            return LOW_PRIORITY0;
        }
        return NORMAL_PRIORITY;
    }
}

