/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.NotNull;

public class OCSymbolKindWeigher
extends CompletionWeigher {
    public Comparable weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        Object item = element.getObject();
        if (item instanceof OCSymbolNavigationItem) {
            OCSymbol symbol = ((OCSymbolNavigationItem)item).getSymbol();
            OCCompletionPriority priority = OCCompletionPriority.getPriority(symbol, location.getProject());
            return Float.valueOf(priority.getValue() - (float)symbol.getKind().ordinal());
        }
        if (item instanceof String && item.toString().endsWith(".xib\"")) {
            return Float.valueOf(-1.0f);
        }
        if (item instanceof String || item instanceof TemplateInsertHandler.TemplateObject) {
            return Float.valueOf(OCCompletionPriority.NORMAL_PRIORITY.getValue() - (float)OCSymbolKind.STRUCT_FIELD.ordinal() - 0.5f);
        }
        return null;
    }
}

